/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Map;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceMetricsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMetricsChecker.class);
    private static final ResourceMetricsChecker INITIAL_MANDATORY_RES_CHECKER = new ResourceMetricsChecker().gaugeLong(ResourceMetricsKey.ALLOCATED_MB, 0L).gaugeInt(ResourceMetricsKey.ALLOCATED_V_CORES, 0).gaugeInt(ResourceMetricsKey.ALLOCATED_CONTAINERS, 0).counter(ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 0L).counter(ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 0L).gaugeLong(ResourceMetricsKey.AVAILABLE_MB, 0L).gaugeInt(ResourceMetricsKey.AVAILABLE_V_CORES, 0).gaugeLong(ResourceMetricsKey.PENDING_MB, 0L).gaugeInt(ResourceMetricsKey.PENDING_V_CORES, 0).gaugeInt(ResourceMetricsKey.PENDING_CONTAINERS, 0).gaugeLong(ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeInt(ResourceMetricsKey.RESERVED_CONTAINERS, 0);
    private static final ResourceMetricsChecker INITIAL_CHECKER = new ResourceMetricsChecker().gaugeLong(ResourceMetricsKey.ALLOCATED_MB, 0L).gaugeInt(ResourceMetricsKey.ALLOCATED_V_CORES, 0).gaugeInt(ResourceMetricsKey.ALLOCATED_CONTAINERS, 0).counter(ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 0L).counter(ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 0L).gaugeLong(ResourceMetricsKey.AVAILABLE_MB, 0L).gaugeInt(ResourceMetricsKey.AVAILABLE_V_CORES, 0).gaugeLong(ResourceMetricsKey.PENDING_MB, 0L).gaugeInt(ResourceMetricsKey.PENDING_V_CORES, 0).gaugeInt(ResourceMetricsKey.PENDING_CONTAINERS, 0).gaugeLong(ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeInt(ResourceMetricsKey.RESERVED_CONTAINERS, 0).gaugeLong(ResourceMetricsKey.ALLOCATED_CUSTOM_RES1, 0L).gaugeLong(ResourceMetricsKey.ALLOCATED_CUSTOM_RES2, 0L).gaugeLong(ResourceMetricsKey.AVAILABLE_CUSTOM_RES1, 0L).gaugeLong(ResourceMetricsKey.AVAILABLE_CUSTOM_RES2, 0L).gaugeLong(ResourceMetricsKey.PENDING_CUSTOM_RES1, 0L).gaugeLong(ResourceMetricsKey.PENDING_CUSTOM_RES2, 0L).gaugeLong(ResourceMetricsKey.RESERVED_CUSTOM_RES1, 0L).gaugeLong(ResourceMetricsKey.RESERVED_CUSTOM_RES2, 0L).gaugeLong(ResourceMetricsKey.AGGREGATE_PREEMPTED_SECONDS_CUSTOM_RES1, 0L).gaugeLong(ResourceMetricsKey.AGGREGATE_PREEMPTED_SECONDS_CUSTOM_RES2, 0L);
    private final Map<ResourceMetricsKey, Long> gaugesLong;
    private final Map<ResourceMetricsKey, Integer> gaugesInt;
    private final Map<ResourceMetricsKey, Long> counters;

    private ResourceMetricsChecker() {
        this.gaugesLong = Maps.newHashMap();
        this.gaugesInt = Maps.newHashMap();
        this.counters = Maps.newHashMap();
    }

    private ResourceMetricsChecker(ResourceMetricsChecker checker) {
        this.gaugesLong = Maps.newHashMap(checker.gaugesLong);
        this.gaugesInt = Maps.newHashMap(checker.gaugesInt);
        this.counters = Maps.newHashMap(checker.counters);
    }

    public static ResourceMetricsChecker createFromChecker(ResourceMetricsChecker checker) {
        return new ResourceMetricsChecker(checker);
    }

    public static ResourceMetricsChecker create() {
        return new ResourceMetricsChecker(INITIAL_CHECKER);
    }

    public static ResourceMetricsChecker createMandatoryResourceChecker() {
        return new ResourceMetricsChecker(INITIAL_MANDATORY_RES_CHECKER);
    }

    ResourceMetricsChecker gaugeLong(ResourceMetricsKey key, long value) {
        this.ensureTypeIsCorrect(key, ResourceMetricType.GAUGE_LONG);
        this.gaugesLong.put(key, value);
        return this;
    }

    ResourceMetricsChecker gaugeInt(ResourceMetricsKey key, int value) {
        this.ensureTypeIsCorrect(key, ResourceMetricType.GAUGE_INT);
        this.gaugesInt.put(key, value);
        return this;
    }

    ResourceMetricsChecker counter(ResourceMetricsKey key, long value) {
        this.ensureTypeIsCorrect(key, ResourceMetricType.COUNTER_LONG);
        this.counters.put(key, value);
        return this;
    }

    private void ensureTypeIsCorrect(ResourceMetricsKey key, ResourceMetricType actualType) {
        if (key.type != actualType) {
            throw new IllegalStateException("Metrics type should be " + key.type + " instead of " + actualType + " for metrics: " + key.value);
        }
    }

    ResourceMetricsChecker checkAgainst(MetricsSource source) {
        if (source == null) {
            throw new IllegalStateException("MetricsSource should not be null!");
        }
        MetricsRecordBuilder recordBuilder = MetricsAsserts.getMetrics((MetricsSource)source);
        this.logAssertingMessage(source);
        for (Map.Entry<ResourceMetricsKey, Long> entry : this.gaugesLong.entrySet()) {
            MetricsAsserts.assertGauge((String)entry.getKey().value, (long)entry.getValue(), (MetricsRecordBuilder)recordBuilder);
        }
        for (Map.Entry<ResourceMetricsKey, Number> entry : this.gaugesInt.entrySet()) {
            MetricsAsserts.assertGauge((String)entry.getKey().value, (int)((Integer)entry.getValue()), (MetricsRecordBuilder)recordBuilder);
        }
        for (Map.Entry<ResourceMetricsKey, Number> entry : this.counters.entrySet()) {
            MetricsAsserts.assertCounter((String)entry.getKey().value, (long)((Long)entry.getValue()), (MetricsRecordBuilder)recordBuilder);
        }
        return this;
    }

    private void logAssertingMessage(MetricsSource source) {
        String queueName = ((QueueMetrics)source).queueName;
        Map users = ((QueueMetrics)source).users;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Asserting Resource metrics.. QueueName: " + queueName + ", users: " + (users != null && !users.isEmpty() ? users : ""));
        }
    }

    static enum ResourceMetricType {
        GAUGE_INT,
        GAUGE_LONG,
        COUNTER_INT,
        COUNTER_LONG;

    }

    static enum ResourceMetricsKey {
        ALLOCATED_MB("AllocatedMB", ResourceMetricType.GAUGE_LONG),
        ALLOCATED_V_CORES("AllocatedVCores", ResourceMetricType.GAUGE_INT),
        ALLOCATED_CONTAINERS("AllocatedContainers", ResourceMetricType.GAUGE_INT),
        AGGREGATE_CONTAINERS_ALLOCATED("AggregateContainersAllocated", ResourceMetricType.COUNTER_LONG),
        AGGREGATE_CONTAINERS_RELEASED("AggregateContainersReleased", ResourceMetricType.COUNTER_LONG),
        AVAILABLE_MB("AvailableMB", ResourceMetricType.GAUGE_LONG),
        AVAILABLE_V_CORES("AvailableVCores", ResourceMetricType.GAUGE_INT),
        PENDING_MB("PendingMB", ResourceMetricType.GAUGE_LONG),
        PENDING_V_CORES("PendingVCores", ResourceMetricType.GAUGE_INT),
        PENDING_CONTAINERS("PendingContainers", ResourceMetricType.GAUGE_INT),
        RESERVED_MB("ReservedMB", ResourceMetricType.GAUGE_LONG),
        RESERVED_V_CORES("ReservedVCores", ResourceMetricType.GAUGE_INT),
        RESERVED_CONTAINERS("ReservedContainers", ResourceMetricType.GAUGE_INT),
        AGGREGATE_VCORE_SECONDS_PREEMPTED("AggregateVcoreSecondsPreempted", ResourceMetricType.COUNTER_LONG),
        AGGREGATE_MEMORY_MB_SECONDS_PREEMPTED("AggregateMemoryMBSecondsPreempted", ResourceMetricType.COUNTER_LONG),
        ALLOCATED_CUSTOM_RES1("AllocatedResource.custom_res_1", ResourceMetricType.GAUGE_LONG),
        ALLOCATED_CUSTOM_RES2("AllocatedResource.custom_res_2", ResourceMetricType.GAUGE_LONG),
        AVAILABLE_CUSTOM_RES1("AvailableResource.custom_res_1", ResourceMetricType.GAUGE_LONG),
        AVAILABLE_CUSTOM_RES2("AvailableResource.custom_res_2", ResourceMetricType.GAUGE_LONG),
        PENDING_CUSTOM_RES1("PendingResource.custom_res_1", ResourceMetricType.GAUGE_LONG),
        PENDING_CUSTOM_RES2("PendingResource.custom_res_2", ResourceMetricType.GAUGE_LONG),
        RESERVED_CUSTOM_RES1("ReservedResource.custom_res_1", ResourceMetricType.GAUGE_LONG),
        RESERVED_CUSTOM_RES2("ReservedResource.custom_res_2", ResourceMetricType.GAUGE_LONG),
        AGGREGATE_PREEMPTED_SECONDS_CUSTOM_RES1("AggregatePreemptedSeconds.custom_res_1", ResourceMetricType.GAUGE_LONG),
        AGGREGATE_PREEMPTED_SECONDS_CUSTOM_RES2("AggregatePreemptedSeconds.custom_res_2", ResourceMetricType.GAUGE_LONG);

        private String value;
        private ResourceMetricType type;

        private ResourceMetricsKey(String value, ResourceMetricType type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public ResourceMetricType getType() {
            return this.type;
        }
    }
}

