/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resourcetracker;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNMExpiry {
    private static final Logger LOG = LoggerFactory.getLogger(TestNMExpiry.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    ResourceTrackerService resourceTrackerService;
    boolean stopT = false;
    RegisterNodeManagerRequest request3;

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        InlineDispatcher dispatcher = new InlineDispatcher();
        RMContextImpl context = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, null, null, null, null);
        dispatcher.register(SchedulerEventType.class, (EventHandler)new InlineDispatcher.EmptyEventHandler());
        dispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)context));
        TestNmLivelinessMonitor nmLivelinessMonitor = new TestNmLivelinessMonitor((Dispatcher)dispatcher);
        nmLivelinessMonitor.init(conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)context);
        nodesListManager.init(conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.start();
        this.resourceTrackerService = new ResourceTrackerService((RMContext)context, nodesListManager, (NMLivelinessMonitor)nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        this.resourceTrackerService.init(conf);
        this.resourceTrackerService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNMExpiry() throws Exception {
        String hostname1 = "localhost1";
        String hostname2 = "localhost2";
        String hostname3 = "localhost3";
        Resource capability = Resources.createResource((int)1024);
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
        request1.setNodeId(nodeId1);
        request1.setHttpPort(0);
        request1.setResource(capability);
        request1.setNodeStatus(mockNodeStatus);
        this.resourceTrackerService.registerNodeManager(request1);
        RegisterNodeManagerRequest request2 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId2 = NodeId.newInstance((String)hostname2, (int)0);
        request2.setNodeId(nodeId2);
        request2.setHttpPort(0);
        request2.setResource(capability);
        request2.setNodeStatus(mockNodeStatus);
        this.resourceTrackerService.registerNodeManager(request2);
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumLostNMs() != 2 && waitCount++ < 20) {
            TestNMExpiry testNMExpiry = this;
            synchronized (testNMExpiry) {
                this.wait(100L);
            }
        }
        Assert.assertEquals((long)2L, (long)ClusterMetrics.getMetrics().getNumLostNMs());
        this.request3 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId3 = NodeId.newInstance((String)hostname3, (int)0);
        this.request3.setNodeId(nodeId3);
        this.request3.setHttpPort(0);
        this.request3.setResource(capability);
        this.resourceTrackerService.registerNodeManager(this.request3);
        this.stopT = false;
        new ThirdNodeHeartBeatThread().start();
        Assert.assertEquals((long)2L, (long)ClusterMetrics.getMetrics().getNumLostNMs());
        this.stopT = true;
    }

    private class TestNmLivelinessMonitor
    extends NMLivelinessMonitor {
        public TestNmLivelinessMonitor(Dispatcher dispatcher) {
            super(dispatcher);
        }

        public void serviceInit(Configuration conf) throws Exception {
            conf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 1000L);
            super.serviceInit(conf);
        }
    }

    private class ThirdNodeHeartBeatThread
    extends Thread {
        private ThirdNodeHeartBeatThread() {
        }

        @Override
        public void run() {
            int lastResponseID = 0;
            while (!TestNMExpiry.this.stopT) {
                try {
                    NodeStatus nodeStatus = (NodeStatus)recordFactory.newRecordInstance(NodeStatus.class);
                    nodeStatus.setNodeId(TestNMExpiry.this.request3.getNodeId());
                    nodeStatus.setResponseId(lastResponseID);
                    nodeStatus.setNodeHealthStatus((NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class));
                    nodeStatus.getNodeHealthStatus().setIsNodeHealthy(true);
                    NodeHeartbeatRequest request = (NodeHeartbeatRequest)recordFactory.newRecordInstance(NodeHeartbeatRequest.class);
                    request.setNodeStatus(nodeStatus);
                    lastResponseID = TestNMExpiry.this.resourceTrackerService.nodeHeartbeat(request).getResponseId();
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LOG.info("failed to heartbeat ", (Throwable)e);
                }
            }
        }
    }
}

