/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.DataInputStream;
import java.io.DataOutput;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.junit.Assert;
import org.junit.Test;

public class TestRMStateStoreUtils {
    @Test
    public void testReadRMDelegationTokenIdentifierData() throws Exception {
        this.testReadRMDelegationTokenIdentifierData(false);
    }

    @Test
    public void testReadRMDelegationTokenIdentifierDataOldFormat() throws Exception {
        this.testReadRMDelegationTokenIdentifierData(true);
    }

    public void testReadRMDelegationTokenIdentifierData(boolean oldFormat) throws Exception {
        RMDelegationTokenIdentifier token = new RMDelegationTokenIdentifier(new Text("alice"), new Text("bob"), new Text("colin"));
        token.setIssueDate(123L);
        token.setMasterKeyId(321);
        token.setMaxDate(314L);
        token.setSequenceNumber(12345);
        DataInputBuffer inBuf = new DataInputBuffer();
        if (oldFormat) {
            DataOutputBuffer outBuf = new DataOutputBuffer();
            token.writeInOldFormat((DataOutput)outBuf);
            outBuf.writeLong(42L);
            inBuf.reset(outBuf.getData(), 0, outBuf.getLength());
        } else {
            RMDelegationTokenIdentifierData tokenIdentifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)token, 42L);
            byte[] data = tokenIdentifierData.toByteArray();
            inBuf.reset(data, 0, data.length);
        }
        RMDelegationTokenIdentifierData identifierData = RMStateStoreUtils.readRMDelegationTokenIdentifierData((DataInputStream)inBuf);
        Assert.assertEquals((String)"Found unexpected data still in the InputStream", (long)-1L, (long)inBuf.read());
        RMDelegationTokenIdentifier identifier = identifierData.getTokenIdentifier();
        Assert.assertEquals((Object)"alice", (Object)identifier.getUser().getUserName());
        Assert.assertEquals((Object)new Text("bob"), (Object)identifier.getRenewer());
        Assert.assertEquals((Object)"colin", (Object)identifier.getUser().getRealUser().getUserName());
        Assert.assertEquals((long)123L, (long)identifier.getIssueDate());
        Assert.assertEquals((long)321L, (long)identifier.getMasterKeyId());
        Assert.assertEquals((long)314L, (long)identifier.getMaxDate());
        Assert.assertEquals((long)12345L, (long)identifier.getSequenceNumber());
        Assert.assertEquals((long)42L, (long)identifierData.getRenewDate());
    }
}

