/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.mockito.Mockito;

public class MockQueueHierarchyBuilder {
    private static final String ROOT = "root";
    private static final String QUEUE_SEP = ".";
    private List<String> queuePaths = Lists.newArrayList();
    private List<String> managedParentQueues = Lists.newArrayList();
    private List<String> dynamicParentQueues = Lists.newArrayList();
    private Set<String> ambiguous = Sets.newHashSet();
    private Map<String, String> shortNameMapping = Maps.newHashMap();
    private CapacitySchedulerQueueManager queueManager;
    private Map<String, List<CSQueue>> childrenMap = Maps.newHashMap();

    public static MockQueueHierarchyBuilder create() {
        return new MockQueueHierarchyBuilder();
    }

    public MockQueueHierarchyBuilder withQueueManager(CapacitySchedulerQueueManager queueManager) {
        this.queueManager = queueManager;
        return this;
    }

    public MockQueueHierarchyBuilder withQueue(String queue) {
        this.queuePaths.add(queue);
        return this;
    }

    public MockQueueHierarchyBuilder withManagedParentQueue(String managedQueue) {
        this.managedParentQueues.add(managedQueue);
        return this;
    }

    public MockQueueHierarchyBuilder withDynamicParentQueue(String dynamicQueue) {
        this.dynamicParentQueues.add(dynamicQueue);
        return this;
    }

    public void build() {
        if (this.queueManager == null) {
            throw new IllegalStateException("QueueManager instance is not provided!");
        }
        for (String managedParentQueue : this.managedParentQueues) {
            if (!this.queuePaths.contains(managedParentQueue)) {
                this.queuePaths.add(managedParentQueue);
                continue;
            }
            throw new IllegalStateException("Cannot add a managed parent and a simple queue with the same path");
        }
        for (String dynamicParentQueue : this.dynamicParentQueues) {
            if (!this.queuePaths.contains(dynamicParentQueue)) {
                this.queuePaths.add(dynamicParentQueue);
                continue;
            }
            throw new IllegalStateException("Cannot add a dynamic parent and a simple queue with the same path");
        }
        HashMap queues = Maps.newHashMap();
        for (String queuePath : this.queuePaths) {
            this.addQueues(queues, queuePath);
        }
        this.ambiguous.forEach(queue -> {
            if (queue.equals(ROOT)) {
                return;
            }
            Mockito.when((Object)this.queueManager.isAmbiguous(queue)).thenReturn((Object)true);
            Mockito.when((Object)this.queueManager.getQueue(queue)).thenReturn(null);
        });
    }

    private void addQueues(Map<String, AbstractCSQueue> queues, String queuePath) {
        String[] pathComponents = queuePath.split("\\.");
        Object currentQueuePath = "";
        for (int i = 0; i < pathComponents.length; ++i) {
            boolean isLeaf = i == pathComponents.length - 1;
            String queueName = pathComponents[i];
            String parentPath = currentQueuePath;
            currentQueuePath = (String)currentQueuePath + (String)(((String)currentQueuePath).equals("") ? queueName : QUEUE_SEP + queueName);
            if (this.shortNameMapping.containsKey(queueName) && !this.shortNameMapping.get(queueName).equals(currentQueuePath)) {
                this.ambiguous.add(queueName);
            }
            this.shortNameMapping.put(queueName, (String)currentQueuePath);
            if (this.managedParentQueues.contains(parentPath) && !isLeaf) {
                throw new IllegalStateException("Cannot add a queue under managed parent");
            }
            if (queues.containsKey(currentQueuePath)) continue;
            ParentQueue parentQueue = (ParentQueue)queues.get(parentPath);
            AbstractCSQueue queue = this.createQueue(parentQueue, queueName, (String)currentQueuePath, isLeaf);
            queues.put((String)currentQueuePath, queue);
        }
    }

    private AbstractCSQueue createQueue(ParentQueue parentQueue, String queueName, String currentQueuePath, boolean isLeaf) {
        if (queueName.equals(ROOT)) {
            return this.createRootQueue(ROOT);
        }
        if (this.managedParentQueues.contains(currentQueuePath)) {
            return this.addManagedParentQueueAsChildOf(parentQueue, queueName);
        }
        if (this.dynamicParentQueues.contains(currentQueuePath)) {
            return this.addParentQueueAsChildOf(parentQueue, queueName, true);
        }
        if (isLeaf) {
            return this.addLeafQueueAsChildOf(parentQueue, queueName);
        }
        return this.addParentQueueAsChildOf(parentQueue, queueName, false);
    }

    private AbstractCSQueue createRootQueue(String rootQueueName) {
        ParentQueue root = (ParentQueue)Mockito.mock(ParentQueue.class);
        Mockito.when((Object)root.getQueuePath()).thenReturn((Object)rootQueueName);
        Mockito.when((Object)this.queueManager.getQueue(rootQueueName)).thenReturn((Object)root);
        Mockito.when((Object)this.queueManager.getQueueByFullName(rootQueueName)).thenReturn((Object)root);
        return root;
    }

    private AbstractCSQueue addParentQueueAsChildOf(ParentQueue parent, String queueName, boolean isDynamic) {
        ParentQueue queue = (ParentQueue)Mockito.mock(ParentQueue.class);
        Mockito.when((Object)queue.isEligibleForAutoQueueCreation()).thenReturn((Object)isDynamic);
        this.setQueueFields(parent, (AbstractCSQueue)queue, queueName);
        return queue;
    }

    private AbstractCSQueue addManagedParentQueueAsChildOf(ParentQueue parent, String queueName) {
        ManagedParentQueue queue = (ManagedParentQueue)Mockito.mock(ManagedParentQueue.class);
        this.setQueueFields(parent, (AbstractCSQueue)queue, queueName);
        return queue;
    }

    private AbstractCSQueue addLeafQueueAsChildOf(ParentQueue parent, String queueName) {
        LeafQueue queue = (LeafQueue)Mockito.mock(LeafQueue.class);
        this.setQueueFields(parent, (AbstractCSQueue)queue, queueName);
        return queue;
    }

    private void setQueueFields(ParentQueue parent, AbstractCSQueue newQueue, String queueName) {
        String fullPathOfParent = parent.getQueuePath();
        String fullPathOfQueue = fullPathOfParent + QUEUE_SEP + queueName;
        this.addQueueToQueueManager(queueName, newQueue, fullPathOfQueue);
        if (this.childrenMap.get(fullPathOfParent) == null) {
            this.childrenMap.put(fullPathOfParent, new ArrayList());
        }
        this.childrenMap.get(fullPathOfParent).add((CSQueue)newQueue);
        Mockito.when((Object)parent.getChildQueues()).thenReturn(this.childrenMap.get(fullPathOfParent));
        Mockito.when((Object)newQueue.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)newQueue.getQueuePath()).thenReturn((Object)fullPathOfQueue);
        Mockito.when((Object)newQueue.getQueueName()).thenReturn((Object)queueName);
    }

    private void addQueueToQueueManager(String queueName, AbstractCSQueue queue, String fullPathOfQueue) {
        Mockito.when((Object)this.queueManager.getQueue(queueName)).thenReturn((Object)queue);
        Mockito.when((Object)this.queueManager.getQueue(fullPathOfQueue)).thenReturn((Object)queue);
        Mockito.when((Object)this.queueManager.getQueueByFullName(fullPathOfQueue)).thenReturn((Object)queue);
    }
}

