/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockQueueHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(MockQueueHierarchy.class);
    private final String ROOT = "root";
    private final ParentQueue rootQueue;
    private String config;
    private final CapacityScheduler cs;
    private CapacitySchedulerConfiguration conf;
    private final ResourceCalculator resourceCalculator;
    private final Map<String, CSQueue> nameToCSQueues;
    private final Map<String, Resource> partitionToResource;

    MockQueueHierarchy(String config, CapacityScheduler cs, CapacitySchedulerConfiguration conf, ResourceCalculator resourceCalculator, Map<String, Resource> partitionToResource) {
        this.config = config;
        this.cs = cs;
        this.conf = conf;
        this.resourceCalculator = resourceCalculator;
        this.nameToCSQueues = new HashMap<String, CSQueue>();
        this.partitionToResource = partitionToResource;
        this.rootQueue = this.init();
    }

    public ParentQueue getRootQueue() {
        return this.rootQueue;
    }

    Map<String, CSQueue> getNameToCSQueues() {
        return this.nameToCSQueues;
    }

    private ParentQueue init() {
        String[] queueExprArray = this.config.split(";");
        ParentQueue rootQueue = null;
        for (int idx = 0; idx < queueExprArray.length; ++idx) {
            ParentQueue queue;
            String q = queueExprArray[idx];
            if (this.isParent(queueExprArray, idx)) {
                ParentQueue parentQueue;
                queue = parentQueue = (ParentQueue)Mockito.mock(ParentQueue.class);
                ArrayList children = new ArrayList();
                Mockito.when((Object)parentQueue.getChildQueues()).thenReturn(children);
                QueueOrderingPolicy policy = (QueueOrderingPolicy)Mockito.mock(QueueOrderingPolicy.class);
                Mockito.when((Object)policy.getConfigName()).thenReturn((Object)"priority-utilization");
                Mockito.when((Object)parentQueue.getQueueOrderingPolicy()).thenReturn((Object)policy);
            } else {
                LeafQueue leafQueue = (LeafQueue)Mockito.mock(LeafQueue.class);
                final TreeSet<FiCaSchedulerApp> apps = new TreeSet<FiCaSchedulerApp>(new Comparator<FiCaSchedulerApp>(){

                    @Override
                    public int compare(FiCaSchedulerApp a1, FiCaSchedulerApp a2) {
                        if (a1.getPriority() != null && !a1.getPriority().equals((Object)a2.getPriority())) {
                            return a1.getPriority().compareTo(a2.getPriority());
                        }
                        return a1.getApplicationId().compareTo(a2.getApplicationId());
                    }
                });
                Mockito.when((Object)leafQueue.getApplications()).thenReturn(apps);
                Mockito.when((Object)leafQueue.getAllApplications()).thenReturn(apps);
                OrderingPolicy so = (OrderingPolicy)Mockito.mock(OrderingPolicy.class);
                String opName = this.conf.get("yarn.scheduler.capacity.root." + this.getQueueName(q) + ".ordering-policy", "fifo");
                if (opName.equals("fair")) {
                    so = (OrderingPolicy)Mockito.spy((Object)new FairOrderingPolicy());
                }
                Mockito.when((Object)so.getPreemptionIterator()).thenAnswer(new Answer(){

                    public Object answer(InvocationOnMock invocation) {
                        return apps.descendingIterator();
                    }
                });
                Mockito.when((Object)leafQueue.getOrderingPolicy()).thenReturn((Object)so);
                HashMap ignorePartitionContainers = new HashMap();
                Mockito.when((Object)leafQueue.getIgnoreExclusivityRMContainers()).thenReturn(ignorePartitionContainers);
                queue = leafQueue;
            }
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            Mockito.when((Object)queue.getReadLock()).thenReturn((Object)lock.readLock());
            this.setupQueue((CSQueue)queue, q, queueExprArray, idx);
            if (!queue.getQueuePath().equals("root")) continue;
            rootQueue = queue;
        }
        return rootQueue;
    }

    private void setupQueue(CSQueue queue, String q, String[] queueExprArray, int idx) {
        LOG.debug("*** Setup queue, source=" + q);
        Object queuePath = null;
        int myLevel = this.getLevel(q);
        if (0 == myLevel) {
            Mockito.when((Object)queue.getQueuePath()).thenReturn((Object)"root");
            queuePath = "root";
        }
        String queueName = this.getQueueName(q);
        Mockito.when((Object)queue.getQueueName()).thenReturn((Object)queueName);
        ParentQueue parentQueue = this.getParentQueue(queueExprArray, idx, myLevel);
        if (null != parentQueue) {
            Mockito.when((Object)queue.getParent()).thenReturn((Object)parentQueue);
            parentQueue.getChildQueues().add(queue);
            queuePath = parentQueue.getQueuePath() + "." + queueName;
        }
        Mockito.when((Object)queue.getQueuePath()).thenReturn(queuePath);
        QueueCapacities qc = new QueueCapacities(0 == myLevel);
        ResourceUsage ru = new ResourceUsage();
        QueueResourceQuotas qr = new QueueResourceQuotas();
        Mockito.when((Object)queue.getQueueCapacities()).thenReturn((Object)qc);
        Mockito.when((Object)queue.getQueueResourceUsage()).thenReturn((Object)ru);
        Mockito.when((Object)queue.getQueueResourceQuotas()).thenReturn((Object)qr);
        LOG.debug("Setup queue, short name=" + queue.getQueueName() + " path=" + queue.getQueuePath());
        LOG.debug("Parent=" + (parentQueue == null ? "null" : parentQueue.getQueuePath()));
        String capacitySettingStr = q.substring(q.indexOf("(") + 1, q.indexOf(")"));
        for (String s : capacitySettingStr.split(",")) {
            String partitionName = s.substring(0, s.indexOf("="));
            String[] values = s.substring(s.indexOf("[") + 1, s.indexOf("]")).split(" ");
            float epsilon = 1.0E-6f;
            Resource toResourcePerPartition = this.partitionToResource.get(partitionName);
            float absGuaranteed = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)toResourcePerPartition, (Resource)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[0].trim()), (Resource)toResourcePerPartition) + epsilon;
            float absMax = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)toResourcePerPartition, (Resource)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[1].trim()), (Resource)toResourcePerPartition) + epsilon;
            float absUsed = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)toResourcePerPartition, (Resource)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[2].trim()), (Resource)toResourcePerPartition) + epsilon;
            float used = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)toResourcePerPartition, (Resource)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[2].trim()), (Resource)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[0].trim())) + epsilon;
            Resource pending = ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[3].trim());
            qc.setAbsoluteCapacity(partitionName, absGuaranteed);
            qc.setAbsoluteMaximumCapacity(partitionName, absMax);
            qc.setAbsoluteUsedCapacity(partitionName, absUsed);
            qc.setUsedCapacity(partitionName, used);
            qr.setEffectiveMaxResource(ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[1].trim()));
            qr.setEffectiveMinResource(ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[0].trim()));
            qr.setEffectiveMaxResource(partitionName, ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[1].trim()));
            qr.setEffectiveMinResource(partitionName, ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[0].trim()));
            Mockito.when((Object)Float.valueOf(queue.getUsedCapacity())).thenReturn((Object)Float.valueOf(used));
            Mockito.when((Object)queue.getEffectiveCapacity(partitionName)).thenReturn((Object)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[0].trim()));
            Mockito.when((Object)queue.getEffectiveMaxCapacity(partitionName)).thenReturn((Object)ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[1].trim()));
            ru.setPending(partitionName, pending);
            Resource reserved = Resources.none();
            if (values.length == 5) {
                reserved = ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[4].trim());
                ru.setReserved(partitionName, reserved);
            }
            if (!this.isParent(queueExprArray, idx)) {
                LeafQueue lq = (LeafQueue)queue;
                Mockito.when((Object)lq.getTotalPendingResourcesConsideringUserLimit((Resource)ArgumentMatchers.isA(Resource.class), (String)ArgumentMatchers.isA(String.class), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)pending);
                Mockito.when((Object)lq.getTotalPendingResourcesConsideringUserLimit((Resource)ArgumentMatchers.isA(Resource.class), (String)ArgumentMatchers.isA(String.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Resources.subtract((Resource)pending, (Resource)reserved));
            }
            ru.setUsed(partitionName, ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(values[2].trim()));
            LOG.debug("Setup queue=" + queueName + " partition=" + partitionName + " [abs_guaranteed=" + absGuaranteed + ",abs_max=" + absMax + ",abs_used" + absUsed + ",pending_resource=" + pending + ", reserved_resource=" + reserved + "]");
        }
        Mockito.when((Object)queue.getPreemptionDisabled()).thenReturn((Object)this.conf.getPreemptionDisabled((String)queuePath, false));
        Map<String, String> otherConfigs = this.getOtherConfigurations(queueExprArray[idx]);
        if (otherConfigs.containsKey("priority")) {
            Mockito.when((Object)queue.getPriority()).thenReturn((Object)Priority.newInstance((int)Integer.valueOf(otherConfigs.get("priority"))));
        } else {
            Mockito.when((Object)queue.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
        }
        if (otherConfigs.containsKey("disable_preemption")) {
            Mockito.when((Object)queue.getPreemptionDisabled()).thenReturn((Object)Boolean.valueOf(otherConfigs.get("disable_preemption")));
        }
        this.nameToCSQueues.put((String)queuePath, queue);
        this.nameToCSQueues.put(queueName, queue);
        Mockito.when((Object)this.cs.getQueue((String)ArgumentMatchers.eq((Object)queuePath))).thenReturn((Object)queue);
        Mockito.when((Object)this.cs.getQueue((String)ArgumentMatchers.eq((Object)queueName))).thenReturn((Object)queue);
        Mockito.when((Object)this.cs.normalizeQueueName((String)ArgumentMatchers.eq((Object)queuePath))).thenReturn(queuePath);
        Mockito.when((Object)this.cs.normalizeQueueName((String)ArgumentMatchers.eq((Object)queueName))).thenReturn(queuePath);
    }

    private Map<String, String> getOtherConfigurations(String queueExpr) {
        if (queueExpr.contains("{")) {
            int left = queueExpr.indexOf(123);
            int right = queueExpr.indexOf(125);
            if (right > left) {
                HashMap<String, String> configs = new HashMap<String, String>();
                String subStr = queueExpr.substring(left + 1, right);
                for (String kv : subStr.split(",")) {
                    if (!kv.contains("=")) continue;
                    String key = kv.substring(0, kv.indexOf("="));
                    String value = kv.substring(kv.indexOf("=") + 1);
                    configs.put(key, value);
                }
                return configs;
            }
        }
        return Collections.emptyMap();
    }

    private String getQueueName(String q) {
        int idx;
        for (idx = 0; idx < q.length() && q.charAt(idx) == '-'; ++idx) {
        }
        if (idx == q.length()) {
            throw new IllegalArgumentException("illegal input:" + q);
        }
        String name = q.substring(idx, q.indexOf(40));
        if (name.isEmpty()) {
            throw new IllegalArgumentException("queue name shouldn't be empty:" + q);
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("queue name shouldn't contain '.':" + name);
        }
        return name;
    }

    private ParentQueue getParentQueue(String[] queueExprArray, int idx, int myLevel) {
        --idx;
        while (idx >= 0) {
            int level = this.getLevel(queueExprArray[idx]);
            if (level < myLevel) {
                String parentQueueName = this.getQueueName(queueExprArray[idx]);
                return (ParentQueue)this.nameToCSQueues.get(parentQueueName);
            }
            --idx;
        }
        return null;
    }

    private boolean isParent(String[] queues, int idx) {
        int myLevel = this.getLevel(queues[idx]);
        ++idx;
        while (idx < queues.length && this.getLevel(queues[idx]) == myLevel) {
            ++idx;
        }
        return idx < queues.length && this.getLevel(queues[idx]) >= myLevel;
    }

    private int getLevel(String q) {
        int level;
        for (level = 0; level < q.length() && q.charAt(level) == '-'; ++level) {
        }
        return level;
    }
}

