/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockNodeLabelsManager {
    private static final Logger LOG = LoggerFactory.getLogger(MockNodeLabelsManager.class);
    private String config;
    private final Resource clusterResource;
    private final Map<String, Resource> partitionToResource;
    private final RMNodeLabelsManager nodeLabelsManager;

    MockNodeLabelsManager(String config, RMNodeLabelsManager nodeLabelsManager, Map<String, Resource> partitionToResource) throws IOException {
        this.config = config;
        this.partitionToResource = partitionToResource;
        this.clusterResource = Resources.createResource((int)0);
        this.nodeLabelsManager = nodeLabelsManager;
        this.parse();
    }

    private void parse() throws IOException {
        String[] partitionConfigArr;
        for (String p : partitionConfigArr = this.config.split(";")) {
            String partitionName = p.substring(0, p.indexOf("="));
            Resource res = ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(p.substring(p.indexOf("=") + 1, p.indexOf(",")));
            boolean exclusivity = Boolean.valueOf(p.substring(p.indexOf(",") + 1));
            Mockito.when((Object)this.nodeLabelsManager.getResourceByLabel((String)ArgumentMatchers.eq((Object)partitionName), (Resource)ArgumentMatchers.any(Resource.class))).thenReturn((Object)res);
            Mockito.when((Object)this.nodeLabelsManager.isExclusiveNodeLabel((String)ArgumentMatchers.eq((Object)partitionName))).thenReturn((Object)exclusivity);
            this.partitionToResource.put(partitionName, res);
            LOG.debug("add partition=" + partitionName + " totalRes=" + res + " exclusivity=" + exclusivity);
            Resources.addTo((Resource)this.clusterResource, (Resource)res);
        }
        Mockito.when((Object)this.nodeLabelsManager.getClusterNodeLabelNames()).thenReturn(this.partitionToResource.keySet());
    }

    public Resource getClusterResource() {
        return this.clusterResource;
    }
}

