/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.DecommissioningNodesWatcher;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDecommissioningNodesWatcher {
    private MockRM rm;

    @Test
    public void testDecommissioningNodesWatcher() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanager-graceful-decommission-timeout-secs", "40");
        this.rm = new MockRM(conf);
        this.rm.start();
        DecommissioningNodesWatcher watcher = new DecommissioningNodesWatcher(this.rm.getRMContext());
        MockNM nm1 = this.rm.registerNode("host1:1234", 10240);
        RMNodeImpl node1 = (RMNodeImpl)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        NodeId id1 = nm1.getNodeId();
        this.rm.waitForState(id1, NodeState.RUNNING);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, this.rm);
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        NodeStatus nodeStatus = this.createNodeStatus(id1, app, 3);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        this.rm.sendNodeGracefulDecommission(nm1, 3600);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        nodeStatus = this.createNodeStatus(id1, app, 3);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        watcher.update((RMNode)node1, nodeStatus);
        nodeStatus = this.createNodeStatus(id1, app, 2);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        watcher.update((RMNode)node1, nodeStatus);
        Assert.assertFalse((boolean)watcher.checkReadyToBeDecommissioned(id1));
        nodeStatus = this.createNodeStatus(id1, app, 1);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        watcher.update((RMNode)node1, nodeStatus);
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.WAIT_CONTAINER, (Object)watcher.checkDecommissioningStatus(id1));
        nodeStatus = this.createNodeStatus(id1, app, 0);
        watcher.update((RMNode)node1, nodeStatus);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.WAIT_APP, (Object)watcher.checkDecommissioningStatus(id1));
        MockRM.finishAMAndVerifyAppState(app, this.rm, nm1, am);
        this.rm.waitForState(app.getApplicationId(), RMAppState.FINISHED);
        watcher.update((RMNode)node1, nodeStatus);
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.READY, (Object)watcher.checkDecommissioningStatus(id1));
    }

    @Test
    public void testDecommissioningNodesWatcherWithPreviousRunningApps() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanager-graceful-decommission-timeout-secs", "40");
        this.rm = new MockRM(conf);
        this.rm.start();
        DecommissioningNodesWatcher watcher = new DecommissioningNodesWatcher(this.rm.getRMContext());
        MockNM nm1 = this.rm.registerNode("host1:1234", 10240);
        RMNodeImpl node1 = (RMNodeImpl)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        NodeId id1 = nm1.getNodeId();
        this.rm.waitForState(id1, NodeState.RUNNING);
        RMApp app = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(2000L, this.rm).build());
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        NodeStatus nodeStatus = this.createNodeStatus(id1, app, 3);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        Assert.assertEquals((long)1L, (long)node1.getRunningApps().size());
        nodeStatus = this.createNodeStatus(id1, app, 0);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        Assert.assertEquals((long)1L, (long)node1.getRunningApps().size());
        this.rm.sendNodeGracefulDecommission(nm1, 3600);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        watcher.update((RMNode)node1, nodeStatus);
        Assert.assertFalse((boolean)watcher.checkReadyToBeDecommissioned(id1));
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.WAIT_APP, (Object)watcher.checkDecommissioningStatus(id1));
        MockRM.finishAMAndVerifyAppState(app, this.rm, nm1, am);
        this.rm.waitForState(app.getApplicationId(), RMAppState.FINISHED);
        Assert.assertEquals((long)0L, (long)node1.getRunningApps().size());
        watcher.update((RMNode)node1, nodeStatus);
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.READY, (Object)watcher.checkDecommissioningStatus(id1));
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    private NodeStatus createNodeStatus(NodeId nodeId, RMApp app, int numRunningContainers) {
        return NodeStatus.newInstance((NodeId)nodeId, (int)0, this.getContainerStatuses(app, numRunningContainers), Collections.emptyList(), (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, (String)"", (long)(System.currentTimeMillis() - 1000L)), null, null, null);
    }

    private List<ContainerStatus> getContainerStatuses(RMApp app, int numRunningContainers) {
        int total = 3;
        numRunningContainers = Math.min(3, numRunningContainers);
        ArrayList<ContainerStatus> output = new ArrayList<ContainerStatus>();
        for (int i = 0; i < 3; ++i) {
            ContainerState cstate = i >= numRunningContainers ? ContainerState.COMPLETE : ContainerState.RUNNING;
            output.add(ContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)0), (long)i), (ContainerState)cstate, (String)"", (int)0));
        }
        return output;
    }
}

