/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterServiceTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationMasterServiceFair
extends ApplicationMasterServiceTestBase {
    private static final String DEFAULT_QUEUE = "root.default";

    @Override
    protected YarnConfiguration createYarnConfig() {
        FairSchedulerConfiguration fsConf = new FairSchedulerConfiguration();
        YarnConfiguration yarnConf = new YarnConfiguration((Configuration)fsConf);
        yarnConf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        return yarnConf;
    }

    @Override
    protected Resource getResourceUsageForQueue(ResourceManager rm, String queue) {
        FairScheduler fs = (FairScheduler)rm.getResourceScheduler();
        FSLeafQueue leafQueue = fs.getQueueManager().getLeafQueue(DEFAULT_QUEUE, false);
        return leafQueue.getResourceUsage();
    }

    @Override
    protected String getDefaultQueueName() {
        return DEFAULT_QUEUE;
    }

    @Test
    public void testRequestCapacityMinMaxAllocationWithDifferentUnits() throws Exception {
        Map<String, ResourceInformation> riMap = this.initializeMandatoryResources();
        ResourceInformation res1 = ResourceInformation.newInstance((String)"res_1", (String)"G", (long)0L, (long)4L);
        riMap.put("res_1", res1);
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        YarnConfiguration yarnConf = this.createYarnConfig();
        yarnConf.setBoolean("yarn.test.reset-resource-types", false);
        yarnConf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", false);
        MockRM rm = new MockRM((Configuration)yarnConf);
        rm.start();
        MockNM nm1 = rm.registerNode("199.99.99.1:1234", ResourceTypesTestHelper.newResource((long)8192L, (int)4, (Map)ImmutableMap.builder().put((Object)"res_1", (Object)"5G").build()));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue(DEFAULT_QUEUE).withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        try {
            am1.allocate(Collections.singletonList(ResourceRequest.newBuilder().capability(ResourceTypesTestHelper.newResource((long)4096L, (int)1, (Map)ImmutableMap.builder().put((Object)"res_1", (Object)"500M").build())).numContainers(1).resourceName("*").build()), null);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)("Allocate request should be accepted but exception was thrown: " + e));
        }
        rm.close();
    }
}

