/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.CommitResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RestartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RollbackResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.ProxyCAManager;
import org.apache.hadoop.yarn.server.security.AMSecretKeys;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyCA;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestApplicationMasterLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TestApplicationMasterLauncher.class);

    @Test
    public void testAMLaunchAndCleanup() throws Exception {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        final MyContainerManagerImpl containerManager = new MyContainerManagerImpl();
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, rm);
        nm1.nodeHeartbeat(true);
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return containerManager.launched;
                }
            }, (long)100L, (long)20000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for AM Launch to happen.");
        }
        Assert.assertTrue((boolean)containerManager.launched);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId appAttemptId = attempt.getAppAttemptId();
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)containerManager.attemptIdAtContainerManager);
        Assert.assertEquals((long)app.getSubmitTime(), (long)containerManager.submitTimeAtContainerManager);
        Assert.assertEquals((Object)app.getRMAppAttempt(appAttemptId).getMasterContainer().getId().toString(), (Object)containerManager.containerIdAtContainerManager);
        Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)containerManager.nmHostAtContainerManager);
        Assert.assertEquals((long)2L, (long)containerManager.maxAppAttempts);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), appAttemptId);
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return containerManager.cleanedup;
                }
            }, (long)100L, (long)20000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for AM cleanup to happen.");
        }
        Assert.assertTrue((boolean)containerManager.cleanedup);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        rm.stop();
    }

    @Test
    public void testAMCleanupBeforeLaunch() throws Exception {
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, rm);
        nm1.nodeHeartbeat(true);
        final RMAppAttempt attempt = app.getCurrentAppAttempt();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return attempt.getMasterContainer() != null;
                }
            }, (long)10L, (long)20000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for AM Launch to happen.");
        }
        rm.killApp(app.getApplicationId());
        rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        AMLauncher launcher = new AMLauncher(rm.getRMContext(), attempt, AMLauncherEventType.LAUNCH, rm.getConfig()){

            public void onAMLaunchFailed(ContainerId containerId, Exception e) {
                Assert.assertFalse((String)("NullPointerException happens  while launching " + containerId), (boolean)(e instanceof NullPointerException));
            }

            protected ContainerManagementProtocol getContainerMgrProxy(ContainerId containerId) {
                return new MyContainerManagerImpl();
            }
        };
        launcher.run();
        rm.stop();
    }

    @Test
    public void testRetriesOnFailures() throws Exception {
        final ContainerManagementProtocol mockProxy = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        StartContainersResponse mockResponse = (StartContainersResponse)Mockito.mock(StartContainersResponse.class);
        Mockito.when((Object)mockProxy.startContainers((StartContainersRequest)ArgumentMatchers.any(StartContainersRequest.class))).thenThrow(new Throwable[]{new NMNotYetReadyException("foo")}).thenReturn((Object)mockResponse);
        Configuration conf = new Configuration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        conf.setInt("yarn.client.nodemanager-connect.retry-interval-ms", 1);
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(conf, null){

            @Override
            protected ApplicationMasterLauncher createAMLauncher() {
                return new ApplicationMasterLauncher(this.getRMContext()){

                    protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
                        return new AMLauncher(this.context, application, event, this.getConfig()){

                            protected YarnRPC getYarnRPC() {
                                YarnRPC mockRpc = (YarnRPC)Mockito.mock(YarnRPC.class);
                                Mockito.when((Object)mockRpc.getProxy((Class)ArgumentMatchers.any(Class.class), (InetSocketAddress)ArgumentMatchers.any(InetSocketAddress.class), (Configuration)ArgumentMatchers.any(Configuration.class))).thenReturn((Object)mockProxy);
                                return mockRpc;
                            }
                        };
                    }
                };
            }
        };
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, rm);
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        MockRM.waitForState(app.getCurrentAppAttempt(), RMAppAttemptState.LAUNCHED, 500);
    }

    @Test(timeout=100000L)
    public void testallocateBeforeAMRegistration() throws Exception {
        boolean thrown = false;
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        int request = 2;
        AllocateResponse ar = null;
        try {
            ar = am.allocate("h1", 1000, request, new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException applicationMasterNotRegisteredException) {
            // empty catch block
        }
        nm1.nodeHeartbeat(true);
        AllocateResponse amrs = null;
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException applicationMasterNotRegisteredException) {
            // empty catch block
        }
        am.registerAppAttempt();
        try {
            am.registerAppAttempt(false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is already registered : " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
        }
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationAttemptNotFoundException applicationAttemptNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSetupTokensWithoutHTTPS() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        this.testSetupTokens(false, conf);
        conf.set("yarn.resourcemanager.application-https.policy", "NONE");
        this.testSetupTokens(false, conf);
    }

    @Test
    public void testSetupTokensWithHTTPS() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.application-https.policy", "LENIENT");
        this.testSetupTokens(true, conf);
        conf.set("yarn.resourcemanager.application-https.policy", "STRICT");
        this.testSetupTokens(true, conf);
    }

    @Test
    public void testAMMasterContainerHost() throws Exception {
        MockRM rm = new MockRM();
        rm.start();
        String host = "127.0.0.1";
        String port = "1234";
        MockNM nm1 = rm.registerNode(host + ":" + port, 5120);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, rm);
        nm1.nodeHeartbeat(true);
        final RMAppAttempt attempt = app.getCurrentAppAttempt();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return attempt.getMasterContainer() != null;
                }
            }, (long)10L, (long)20000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for AM Launch to happen.");
        }
        Assert.assertEquals((Object)app.getCurrentAppAttempt().getMasterContainer().getNodeId().getHost(), (Object)host);
        rm.killApp(app.getApplicationId());
        rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        rm.stop();
    }

    private void testSetupTokens(boolean https, YarnConfiguration conf) throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = MockRMAppSubmitter.submitWithMemory(2000L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        AMRMTokenIdentifier tokenIdentifier = new AMRMTokenIdentifier(attempt.getAppAttemptId(), 1);
        ProxyCA proxyCA = (ProxyCA)Mockito.mock(ProxyCA.class);
        Mockito.when((Object)proxyCA.generateKeyStorePassword()).thenReturn((Object)"kPassword").thenReturn((Object)"tPassword");
        Mockito.when((Object)proxyCA.createChildKeyStore((ApplicationId)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"keystore".getBytes());
        Mockito.when((Object)proxyCA.getChildTrustStore((String)ArgumentMatchers.any())).thenReturn((Object)"truststore".getBytes());
        RMContext rmContext = (RMContext)Mockito.spy((Object)rm.getRMContext());
        ProxyCAManager proxyCAManager = (ProxyCAManager)Mockito.mock(ProxyCAManager.class);
        Mockito.when((Object)proxyCAManager.getProxyCA()).thenReturn((Object)proxyCA);
        Mockito.when((Object)rmContext.getProxyCAManager()).thenReturn((Object)proxyCAManager);
        MyAMLauncher launcher = new MyAMLauncher(rmContext, attempt, AMLauncherEventType.LAUNCH, rm.getConfig(), tokenIdentifier);
        DataOutputBuffer dob = new DataOutputBuffer();
        Credentials ts = new Credentials();
        ts.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(null, null, null, null, (ByteBuffer)securityTokens, null);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attempt.getAppAttemptId(), (long)0L);
        try {
            launcher.setupTokens(amContainer, containerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            launcher.setupTokens(amContainer, containerId);
        }
        catch (EOFException e) {
            Assert.fail((String)"EOFException should not happen.");
        }
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        dibb.reset(new ByteBuffer[]{amContainer.getTokens()});
        Credentials credentials = new Credentials();
        credentials.readTokenStorageStream((DataInputStream)dibb);
        Assert.assertEquals((long)1L, (long)credentials.numberOfTokens());
        Token token = (Token)credentials.getAllTokens().iterator().next();
        Assert.assertEquals((Object)tokenIdentifier.getKind(), (Object)token.getKind());
        Assert.assertArrayEquals((byte[])tokenIdentifier.getBytes(), (byte[])token.getIdentifier());
        Assert.assertArrayEquals((byte[])"password".getBytes(), (byte[])token.getPassword());
        if (https) {
            Assert.assertEquals((long)4L, (long)credentials.numberOfSecretKeys());
            Assert.assertArrayEquals((byte[])"keystore".getBytes(), (byte[])credentials.getSecretKey(AMSecretKeys.YARN_APPLICATION_AM_KEYSTORE));
            Assert.assertArrayEquals((byte[])"kPassword".getBytes(), (byte[])credentials.getSecretKey(AMSecretKeys.YARN_APPLICATION_AM_KEYSTORE_PASSWORD));
            Assert.assertArrayEquals((byte[])"truststore".getBytes(), (byte[])credentials.getSecretKey(AMSecretKeys.YARN_APPLICATION_AM_TRUSTSTORE));
            Assert.assertArrayEquals((byte[])"tPassword".getBytes(), (byte[])credentials.getSecretKey(AMSecretKeys.YARN_APPLICATION_AM_TRUSTSTORE_PASSWORD));
        } else {
            Assert.assertEquals((long)0L, (long)credentials.numberOfSecretKeys());
        }
    }

    private static final class MyContainerManagerImpl
    implements ContainerManagementProtocol {
        boolean launched = false;
        boolean cleanedup = false;
        String attemptIdAtContainerManager = null;
        String containerIdAtContainerManager = null;
        String nmHostAtContainerManager = null;
        long submitTimeAtContainerManager;
        int maxAppAttempts;

        private MyContainerManagerImpl() {
        }

        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
            StartContainerRequest request = (StartContainerRequest)requests.getStartContainerRequests().get(0);
            LOG.info("Container started by MyContainerManager: " + request);
            this.launched = true;
            Map env = request.getContainerLaunchContext().getEnvironment();
            org.apache.hadoop.yarn.api.records.Token containerToken = request.getContainerToken();
            ContainerTokenIdentifier tokenId = null;
            try {
                tokenId = BuilderUtils.newContainerTokenIdentifier((org.apache.hadoop.yarn.api.records.Token)containerToken);
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            ContainerId containerId = tokenId.getContainerID();
            this.containerIdAtContainerManager = containerId.toString();
            this.attemptIdAtContainerManager = containerId.getApplicationAttemptId().toString();
            this.nmHostAtContainerManager = tokenId.getNmHostAddress();
            this.submitTimeAtContainerManager = Long.parseLong((String)env.get("APP_SUBMIT_TIME_ENV"));
            this.maxAppAttempts = 2;
            return StartContainersResponse.newInstance(new HashMap(), new ArrayList(), new HashMap());
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            LOG.info("Container cleaned up by MyContainerManager");
            this.cleanedup = true;
            return null;
        }

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            return null;
        }

        @Deprecated
        public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest request) throws YarnException {
            return null;
        }

        public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
            return null;
        }

        public ResourceLocalizationResponse localize(ResourceLocalizationRequest request) throws YarnException, IOException {
            return null;
        }

        public ReInitializeContainerResponse reInitializeContainer(ReInitializeContainerRequest request) throws YarnException, IOException {
            return null;
        }

        public RestartContainerResponse restartContainer(ContainerId containerId) throws YarnException, IOException {
            return null;
        }

        public RollbackResponse rollbackLastReInitialization(ContainerId containerId) throws YarnException, IOException {
            return null;
        }

        public CommitResponse commitLastReInitialization(ContainerId containerId) throws YarnException, IOException {
            return null;
        }

        public ContainerUpdateResponse updateContainer(ContainerUpdateRequest request) throws YarnException, IOException {
            return null;
        }

        public GetLocalizationStatusesResponse getLocalizationStatuses(GetLocalizationStatusesRequest request) throws YarnException, IOException {
            return null;
        }
    }

    static class MyAMLauncher
    extends AMLauncher {
        int count = 0;
        AMRMTokenIdentifier tokenIdentifier;

        public MyAMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, Configuration conf, AMRMTokenIdentifier tokenIdentifier) {
            super(rmContext, application, eventType, conf);
            this.tokenIdentifier = tokenIdentifier;
        }

        protected Token<AMRMTokenIdentifier> createAndSetAMRMToken() {
            ++this.count;
            if (this.count == 1) {
                throw new RuntimeException("createAndSetAMRMToken failure");
            }
            return new Token(this.tokenIdentifier.getBytes(), "password".getBytes(), this.tokenIdentifier.getKind(), new Text());
        }

        protected void setupTokens(ContainerLaunchContext container, ContainerId containerID) throws IOException {
            super.setupTokens(container, containerID);
        }
    }
}

