/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.AppManagerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAppManager
extends AppManagerTestBase {
    @Rule
    public UseCapacitySchedulerRule shouldUseCs = new UseCapacitySchedulerRule();
    private static final Logger LOG = LoggerFactory.getLogger(TestAppManager.class);
    private static RMAppEventType appEventType = RMAppEventType.KILL;
    private static String USER = "user_";
    private static String USER0 = USER + "0";
    private ResourceScheduler scheduler;
    private static final String USER_ID_PREFIX = "userid=";
    private static final String ROOT_PARENT = "yarn.scheduler.capacity.root.parent.";
    private RMContext rmContext;
    private SystemMetricsPublisher metricsPublisher;
    private AppManagerTestBase.TestRMAppManager appMonitor;
    private ApplicationSubmissionContext asContext;
    private ApplicationId appId;
    private QueueInfo mockDefaultQueueInfo;

    public synchronized RMAppEventType getAppEventType() {
        return appEventType;
    }

    public synchronized void setAppEventType(RMAppEventType newType) {
        appEventType = newType;
    }

    private static List<RMApp> newRMApps(int n, long time, RMAppState state) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(new MockRMApp(i, time, state));
        }
        return list;
    }

    public RMContext mockRMContext(int n, long time) {
        List<RMApp> apps = TestAppManager.newRMApps(n, time, RMAppState.FINISHED);
        final ConcurrentMap map = Maps.newConcurrentMap();
        for (RMApp app : apps) {
            map.put(app.getApplicationId(), app);
        }
        AsyncDispatcher rmDispatcher = new AsyncDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = new ContainerAllocationExpirer((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amLivelinessMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amFinishingMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl context = new RMContextImpl((Dispatcher)rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, null, null, null, null, null){

            public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
                return map;
            }
        };
        ((RMContextImpl)context).setStateStore((RMStateStore)Mockito.mock(RMStateStore.class));
        this.metricsPublisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        context.setSystemMetricsPublisher(this.metricsPublisher);
        context.setRMApplicationHistoryWriter(writer);
        ((RMContextImpl)context).setYarnConfiguration((Configuration)new YarnConfiguration());
        return context;
    }

    protected void addToCompletedApps(AppManagerTestBase.TestRMAppManager appMonitor, RMContext rmContext) {
        for (RMApp app : rmContext.getRMApps().values()) {
            if (app.getState() != RMAppState.FINISHED && app.getState() != RMAppState.KILLED && app.getState() != RMAppState.FAILED) continue;
            appMonitor.finishApplication(app.getApplicationId());
        }
    }

    @Before
    public void setUp() throws IOException {
        long now = System.currentTimeMillis();
        this.rmContext = this.mockRMContext(1, now - 10L);
        this.rmContext.setRMTimelineCollectorManager((RMTimelineCollectorManager)Mockito.mock(RMTimelineCollectorManager.class));
        this.scheduler = this.shouldUseCs.useCapacityScheduler() ? TestAppManager.mockResourceScheduler(CapacityScheduler.class) : TestAppManager.mockResourceScheduler();
        ((RMContextImpl)this.rmContext).setScheduler(this.scheduler);
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        ((RMContextImpl)this.rmContext).setYarnConfiguration(conf);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)this.scheduler);
        this.appMonitor = new AppManagerTestBase.TestRMAppManager(this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)this.scheduler, masterService, new ApplicationACLsManager(conf), conf);
        this.appId = MockApps.newAppID((int)1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        this.asContext = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        this.asContext.setApplicationId(this.appId);
        this.asContext.setAMContainerSpec(TestAppManager.mockContainerLaunchContext(recordFactory));
        this.asContext.setResource(TestAppManager.mockResource());
        this.asContext.setPriority(Priority.newInstance((int)0));
        this.asContext.setQueue("default");
        this.mockDefaultQueueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)this.scheduler.getQueueInfo("default", false, false)).thenReturn((Object)this.mockDefaultQueueInfo);
        this.setupDispatcher(this.rmContext, conf);
    }

    public static PlacementManager createMockPlacementManager(String userRegex, final String placementQueue, final String placementParentQueue) throws YarnException {
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext(placementQueue, placementParentQueue);
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(ApplicationSubmissionContext.class), ArgumentMatchers.matches((String)userRegex), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue());
        return placementMgr;
    }

    private AppManagerTestBase.TestRMAppManager createAppManager(RMContext context, Configuration configuration) {
        ApplicationMasterService masterService = new ApplicationMasterService(context, (YarnScheduler)context.getScheduler());
        return new AppManagerTestBase.TestRMAppManager(context, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)context.getScheduler(), masterService, new ApplicationACLsManager(configuration), configuration);
    }

    @Test
    public void testQueueSubmitWithACLsEnabledWithQueueMapping() throws YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "default,test");
        csConf.setCapacity("root.default", 50.0f);
        csConf.setMaximumCapacity("root.default", 100.0f);
        csConf.setCapacity("root.test", 50.0f);
        csConf.setMaximumCapacity("root.test", 100.0f);
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.test.acl_submit_applications", "test");
        csConf.set("yarn.scheduler.capacity.root.test.acl_administer_queue", "test");
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("test", "root.test", null));
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        ApplicationSubmissionContext submission = TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1));
        submission.setQueue("oldQueue");
        TestAppManager.verifyAppSubmission(submission, newAppMonitor, newMockRMContext, "test", "root.test");
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), "test1");
    }

    @Test
    public void testQueueSubmitWithLeafQueueName() throws YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "default,test");
        csConf.setCapacity("root.default", 50.0f);
        csConf.setMaximumCapacity("root.default", 100.0f);
        csConf.setCapacity("root.test", 50.0f);
        csConf.setMaximumCapacity("root.test", 100.0f);
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        ApplicationSubmissionContext submission = TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1));
        submission.setQueue("test");
        TestAppManager.verifyAppSubmission(submission, newAppMonitor, newMockRMContext, "test", "root.test");
    }

    @Test
    public void testQueueSubmitWithACLsEnabledWithQueueMappingForLegacyAutoCreatedQueue() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "default,managedparent");
        csConf.setCapacity("root.default", 50.0f);
        csConf.setMaximumCapacity("root.default", 100.0f);
        csConf.setCapacity("root.managedparent", 50.0f);
        csConf.setMaximumCapacity("root.managedparent", 100.0f);
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.managedparent.acl_administer_queue", "admin");
        csConf.set("yarn.scheduler.capacity.root.managedparent.acl_submit_applications", "user1");
        csConf.setAutoCreateChildQueueEnabled("root.managedparent", true);
        csConf.setAutoCreatedLeafQueueConfigCapacity("root.managedparent", 30.0f);
        csConf.setAutoCreatedLeafQueueConfigMaxCapacity("root.managedparent", 100.0f);
        MockRM newMockRM = new MockRM((Configuration)csConf);
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        ManagedParentQueue managedParentQueue = new ManagedParentQueue(cs.getQueueContext(), "managedparent", cs.getQueue("root"), null);
        cs.getCapacitySchedulerQueueManager().addQueue("managedparent", (CSQueue)managedParentQueue);
        RMContext newMockRMContext = newMockRM.getRMContext();
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1|user2", "user1", "root.managedparent"));
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        ApplicationSubmissionContext submission = TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1));
        submission.setQueue("oldQueue");
        TestAppManager.verifyAppSubmission(submission, newAppMonitor, newMockRMContext, "user1", "root.managedparent.user1");
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), "user2");
    }

    @Test
    public void testLegacyAutoCreatedQueuesWithACLTemplates() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "parent");
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        csConf.setCapacity("root.parent", 100.0f);
        csConf.set("yarn.scheduler.capacity.root.parent.acl_administer_queue", "user1,user4");
        csConf.set("yarn.scheduler.capacity.root.parent.acl_submit_applications", "user1,user4");
        csConf.setAutoCreateChildQueueEnabled("root.parent", true);
        csConf.setAutoCreatedLeafQueueConfigCapacity("root.parent", 50.0f);
        csConf.setAutoCreatedLeafQueueConfigMaxCapacity("root.parent", 100.0f);
        csConf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)csConf.getAutoCreatedQueueTemplateConfPrefix("root.parent")) + "acl_administer_queue", "user2,user4");
        csConf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)csConf.getAutoCreatedQueueTemplateConfPrefix("root.parent")) + "acl_submit_applications", "user2,user4");
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1", "user1", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1)), newAppMonitor, newMockRMContext, "user1", "root.parent.user1");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1|user2|user3|user4", "user2", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), newAppMonitor, newMockRMContext, "user2", "root.parent.user2");
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)3)), "user3");
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)4)), newAppMonitor, newMockRMContext, "user4", "root.parent.user2");
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        cs.getCapacitySchedulerQueueManager().createQueue(new QueuePath("root.parent.user2"));
        AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)cs.getQueue("user2");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        ManagedParentQueue parentQueue = (ManagedParentQueue)cs.getQueue("parent");
        Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue.getParent());
        cs.reinitialize((Configuration)csConf, newMockRMContext);
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)5)), newAppMonitor, newMockRMContext, "user2", "root.parent.user2");
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)6)), "user3");
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)7)), newAppMonitor, newMockRMContext, "user1", "root.parent.user2");
    }

    @Test
    public void testFlexibleAutoCreatedQueuesWithSpecializedACLTemplatesAndDynamicParentQueue() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = this.createFlexibleAQCBaseACLConfiguration(conf);
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.parent-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.parent-template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.parent-template.acl_submit_applications", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "user3");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "user3");
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1", "user1", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1)), newAppMonitor, newMockRMContext, "user1", "root.parent.user1");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user2", "user2", "root.parent"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), "user2");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.parent.user2"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)3)), newAppMonitor, newMockRMContext, "user3", "root.parent.user2.user3");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user4", "user4", "root.parent.user2"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)4)), "user4");
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        cs.getCapacitySchedulerQueueManager().createQueue(new QueuePath("root.parent.user2.user3"));
        ParentQueue autoCreatedParentQueue = (ParentQueue)cs.getQueue("user2");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedParentQueue);
        ParentQueue parentQueue = (ParentQueue)cs.getQueue("parent");
        Assert.assertEquals((Object)parentQueue, (Object)autoCreatedParentQueue.getParent());
        LeafQueue autoCreatedLeafQueue = (LeafQueue)cs.getQueue("user3");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        Assert.assertEquals((Object)autoCreatedParentQueue, (Object)autoCreatedLeafQueue.getParent());
        cs.reinitialize((Configuration)csConf, newMockRMContext);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.parent.user2"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)5)), newAppMonitor, newMockRMContext, "user3", "root.parent.user2.user3");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user4", "user4", "root.parent.user2"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)6)), "user4");
    }

    @Test
    public void testFlexibleAutoCreatedQueuesWithMixedCommonLeafACLTemplatesAndDynamicParentQueue() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = this.createFlexibleAQCBaseACLConfiguration(conf);
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.acl_submit_applications", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "user3");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "user3");
        this.testFlexibleAQCDWithMixedTemplatesDynamicParentACLScenario(conf, csConf);
    }

    @Test
    public void testFlexibleAutoCreatedQueuesWithMixedCommonCommonACLTemplatesAndDynamicParentQueue() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = this.createFlexibleAQCBaseACLConfiguration(conf);
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.acl_submit_applications", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.template.acl_administer_queue", "user3");
        csConf.set("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.template.acl_submit_applications", "user3");
        this.testFlexibleAQCDWithMixedTemplatesDynamicParentACLScenario(conf, csConf);
    }

    private void testFlexibleAQCDWithMixedTemplatesDynamicParentACLScenario(YarnConfiguration conf, CapacitySchedulerConfiguration csConf) throws YarnException, IOException {
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1", "user1", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1)), newAppMonitor, newMockRMContext, "user1", "root.parent.user1");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user2", "user2", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), newAppMonitor, newMockRMContext, "user2", "root.parent.user2");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.parent.user2"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)3)), newAppMonitor, newMockRMContext, "user3", "root.parent.user2.user3");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user4", "user4", "root.parent.user2"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)4)), "user4");
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        cs.getCapacitySchedulerQueueManager().createQueue(new QueuePath("root.parent.user2.user3"));
        ParentQueue autoCreatedParentQueue = (ParentQueue)cs.getQueue("user2");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedParentQueue);
        ParentQueue parentQueue = (ParentQueue)cs.getQueue("parent");
        Assert.assertEquals((Object)parentQueue, (Object)autoCreatedParentQueue.getParent());
        LeafQueue autoCreatedLeafQueue = (LeafQueue)cs.getQueue("user3");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        Assert.assertEquals((Object)autoCreatedParentQueue, (Object)autoCreatedLeafQueue.getParent());
        cs.reinitialize((Configuration)csConf, newMockRMContext);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.parent.user2"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)5)), newAppMonitor, newMockRMContext, "user3", "root.parent.user2.user3");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user4", "user4", "root.parent.user2"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)6)), "user4");
    }

    @Test
    public void testFlexibleAutoCreatedQueuesWithACLTemplatesALeafOnly() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = this.createFlexibleAQCBaseACLConfiguration(conf);
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.template.acl_submit_applications", "user2");
        this.testFlexibleAQCLeafOnly(conf, csConf);
    }

    @Test
    public void testFlexibleAutoCreatedQueuesWithSpecialisedACLTemplatesALeafOnly() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = this.createFlexibleAQCBaseACLConfiguration(conf);
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.leaf-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.leaf-template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.leaf-template.acl_submit_applications", "user2");
        this.testFlexibleAQCLeafOnly(conf, csConf);
    }

    private void testFlexibleAQCLeafOnly(YarnConfiguration conf, CapacitySchedulerConfiguration csConf) throws YarnException, IOException {
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1", "user1", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1)), newAppMonitor, newMockRMContext, "user1", "root.parent.user1");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user2", "user2", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), newAppMonitor, newMockRMContext, "user2", "root.parent.user2");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.parent"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)3)), "user3");
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        cs.getCapacitySchedulerQueueManager().createQueue(new QueuePath("root.parent.user2"));
        ParentQueue autoCreatedParentQueue = (ParentQueue)cs.getQueue("parent");
        LeafQueue autoCreatedLeafQueue = (LeafQueue)cs.getQueue("user2");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        Assert.assertEquals((Object)autoCreatedParentQueue, (Object)autoCreatedLeafQueue.getParent());
        cs.reinitialize((Configuration)csConf, newMockRMContext);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user2", "user2", "root.parent"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)4)), newAppMonitor, newMockRMContext, "user2", "root.parent.user2");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.parent"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)5)), "user3");
    }

    @Test
    public void testFlexibleAutoCreatedQueuesWithSpecializedACLTemplatesAndDynamicRootParentQueue() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "");
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", "user1");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", "admin1");
        csConf.setAutoQueueCreationV2Enabled("root", true);
        csConf.set("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.acl_submit_applications", "user2");
        csConf.set("yarn.scheduler.capacity.root.*.auto-queue-creation-v2.leaf-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "user3");
        csConf.set("yarn.scheduler.capacity.root.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "user3");
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user1", "user1", "root"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1)), newAppMonitor, newMockRMContext, "user1", "root.user1");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user2", "user2", "root"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), "user2");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.user2"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)3)), newAppMonitor, newMockRMContext, "user3", "root.user2.user3");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user4", "user4", "root.user2"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)4)), "user4");
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        cs.getCapacitySchedulerQueueManager().createQueue(new QueuePath("root.user2.user3"));
        ParentQueue autoCreatedParentQueue = (ParentQueue)cs.getQueue("user2");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedParentQueue);
        ParentQueue parentQueue = (ParentQueue)cs.getQueue("root");
        Assert.assertEquals((Object)parentQueue, (Object)autoCreatedParentQueue.getParent());
        LeafQueue autoCreatedLeafQueue = (LeafQueue)cs.getQueue("user3");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        Assert.assertEquals((Object)autoCreatedParentQueue, (Object)autoCreatedLeafQueue.getParent());
        cs.reinitialize((Configuration)csConf, newMockRMContext);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "user3", "root.user2"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)5)), newAppMonitor, newMockRMContext, "user3", "root.user2.user3");
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user4", "user4", "root.user2"));
        TestAppManager.verifyAppSubmissionFailure(newAppMonitor, TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)6)), "user4");
    }

    @Test
    public void testFlexibleAutoCreatedQueuesMultiLevelDynamicParentACL() throws IOException, YarnException {
        YarnConfiguration conf = this.createYarnACLEnabledConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "");
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", "user1");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", "admin1");
        csConf.setAutoQueueCreationV2Enabled("root", true);
        csConf.set("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.acl_administer_queue", "user2");
        csConf.set("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.acl_submit_applications", "user2");
        csConf.set("yarn.scheduler.capacity.root.user2.user3.auto-queue-creation-v2.leaf-template.capacity", "1w");
        csConf.set("yarn.scheduler.capacity.root.user2.user3.auto-queue-creation-v2.leaf-template.acl_administer_queue", "user3");
        csConf.set("yarn.scheduler.capacity.root.user2.user3.auto-queue-creation-v2.leaf-template.acl_submit_applications", "user3");
        csConf.setMaximumAutoCreatedQueueDepth(4);
        MockRM newMockRM = new MockRM((Configuration)csConf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(newMockRMContext, (Configuration)conf);
        newMockRMContext.setQueuePlacementManager(TestAppManager.createMockPlacementManager("user3", "queue", "root.user2.user3"));
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)1)), newAppMonitor, newMockRMContext, "user3", "root.user2.user3.queue");
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        cs.getCapacitySchedulerQueueManager().createQueue(new QueuePath("root.user2.user3.queue"));
        ParentQueue autoCreatedParentQueue = (ParentQueue)cs.getQueue("user2");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedParentQueue);
        ParentQueue parentQueue = (ParentQueue)cs.getQueue("root");
        Assert.assertEquals((Object)parentQueue, (Object)autoCreatedParentQueue.getParent());
        ParentQueue autoCreatedParentQueue2 = (ParentQueue)cs.getQueue("user3");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedParentQueue2);
        Assert.assertEquals((Object)autoCreatedParentQueue, (Object)autoCreatedParentQueue2.getParent());
        LeafQueue autoCreatedLeafQueue = (LeafQueue)cs.getQueue("queue");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        Assert.assertEquals((Object)autoCreatedParentQueue, (Object)autoCreatedParentQueue2.getParent());
        cs.reinitialize((Configuration)csConf, newMockRMContext);
        TestAppManager.verifyAppSubmission(TestAppManager.createAppSubmissionContext(MockApps.newAppID((int)2)), newAppMonitor, newMockRMContext, "user3", "root.user2.user3.queue");
    }

    private YarnConfiguration createYarnACLEnabledConfiguration() {
        YarnConfiguration conf = new YarnConfiguration(new Configuration(false));
        conf.set("yarn.acl.enable", "true");
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        return conf;
    }

    private CapacitySchedulerConfiguration createFlexibleAQCBaseACLConfiguration(YarnConfiguration conf) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "parent");
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        csConf.setCapacity("root.parent", "1w");
        csConf.set("yarn.scheduler.capacity.root.parent.acl_administer_queue", "user1");
        csConf.set("yarn.scheduler.capacity.root.parent.acl_submit_applications", "user1");
        csConf.setAutoQueueCreationV2Enabled("root.parent", true);
        return csConf;
    }

    private static void verifyAppSubmissionFailure(AppManagerTestBase.TestRMAppManager appManager, ApplicationSubmissionContext submission, String user) {
        try {
            appManager.submitApplication(submission, user);
            Assert.fail((String)String.format("should fail since %s does not have permission to submit to queue", user));
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AccessControlException));
        }
    }

    private static void verifyAppSubmission(ApplicationSubmissionContext submission, AppManagerTestBase.TestRMAppManager appManager, RMContext rmContext, String user, String expectedQueue) throws YarnException {
        appManager.submitApplication(submission, user);
        RMApp app = (RMApp)rmContext.getRMApps().get(submission.getApplicationId());
        Assert.assertNotNull((String)"app should not be null", (Object)app);
        Assert.assertEquals((String)String.format("the queue should be placed on '%s' queue", expectedQueue), (Object)expectedQueue, (Object)app.getQueue());
    }

    private static ApplicationSubmissionContext createAppSubmissionContext(ApplicationId id) {
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        ApplicationSubmissionContext appSubmission = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        appSubmission.setApplicationId(id);
        appSubmission.setAMContainerSpec(TestAppManager.mockContainerLaunchContext(recordFactory));
        appSubmission.setResource(TestAppManager.mockResource());
        appSubmission.setPriority(Priority.newInstance((int)0));
        appSubmission.setQueue("default");
        return appSubmission;
    }

    @After
    public void tearDown() {
        this.setAppEventType(RMAppEventType.KILL);
        ((Service)this.rmContext.getDispatcher()).stop();
        UserGroupInformation.reset();
    }

    @Test
    public void testRMAppRetireNone() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 10L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.max-completed-applications", 10);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before checkAppTimeLimit", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)10L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.never())).removeApplication((RMApp)ArgumentMatchers.isA(RMApp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueSubmitWithNoPermission() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        conf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        conf.set("yarn.scheduler.capacity.root.default.acl_submit_applications", " ");
        conf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", " ");
        conf.set("yarn.acl.enable", "true");
        MockRM mockRM = new MockRM((Configuration)conf);
        ClientRMService rmService = mockRM.getClientRMService();
        SubmitApplicationRequest req = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setApplicationId(this.appId);
        ResourceRequest resReg = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1);
        sub.setAMContainerResourceRequests(Collections.singletonList(resReg));
        req.setApplicationSubmissionContext(sub);
        sub.setAMContainerSpec((ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class));
        try {
            rmService.submitApplication(req);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof YarnException) {
                Assert.assertTrue((boolean)(e.getCause() instanceof AccessControlException));
            } else {
                Assert.fail((String)("Yarn exception is expected : " + e.getMessage()));
            }
        }
        finally {
            mockRM.close();
        }
    }

    @Test
    public void testRMAppRetireSome() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 3);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 3);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)3L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)3L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)7))).removeApplication((RMApp)ArgumentMatchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireSomeDifferentStates() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 2);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 2);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, (Configuration)conf);
        rmContext.getRMApps().clear();
        Assert.assertEquals((String)"map isn't empty", (long)0L, (long)rmContext.getRMApps().size());
        MockRMApp app = new MockRMApp(0, now - 20000L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(1, now - 200000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(2, now - 30000L, RMAppState.FINISHED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(3, now - 20000L, RMAppState.RUNNING);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(4, now - 20000L, RMAppState.NEW);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(5, now - 10001L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(6, now - 30000L, RMAppState.ACCEPTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(7, now - 20000L, RMAppState.SUBMITTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(8, now - 10001L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(9, now - 20000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)6L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)2L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)4))).removeApplication((RMApp)ArgumentMatchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireNullApp() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, new Configuration());
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        appMonitor.finishApplication(null);
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)0L, (long)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireZeroSetting() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 0);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 0);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)0L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)0L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)10))).removeApplication((RMApp)ArgumentMatchers.isA(RMApp.class));
    }

    @Test
    public void testStateStoreAppLimitLessThanMemoryAppLimit() {
        long now = System.currentTimeMillis();
        int allApps = 10;
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        int maxAppsInMemory = 8;
        int maxAppsInStateStore = 4;
        conf.setInt("yarn.resourcemanager.max-completed-applications", maxAppsInMemory);
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", maxAppsInStateStore);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, (Configuration)conf);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)maxAppsInMemory, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)maxAppsInMemory, (long)appMonitor.getCompletedAppsListSize());
        int numRemoveAppsFromStateStore = 10 - maxAppsInStateStore;
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)numRemoveAppsFromStateStore))).removeApplication((RMApp)ArgumentMatchers.isA(RMApp.class));
        Assert.assertEquals((long)maxAppsInStateStore, (long)appMonitor.getNumberOfCompletedAppsInStateStore());
    }

    @Test
    public void testStateStoreAppLimitGreaterThanMemoryAppLimit() {
        long now = System.currentTimeMillis();
        int allApps = 10;
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        int maxAppsInMemory = 8;
        conf.setInt("yarn.resourcemanager.max-completed-applications", maxAppsInMemory);
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 1000);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(rmContext, (Configuration)conf);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        int numRemoveApps = 10 - maxAppsInMemory;
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)maxAppsInMemory, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)maxAppsInMemory, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)numRemoveApps))).removeApplication((RMApp)ArgumentMatchers.isA(RMApp.class));
        Assert.assertEquals((long)maxAppsInMemory, (long)appMonitor.getNumberOfCompletedAppsInStateStore());
    }

    protected void setupDispatcher(RMContext rmContext, Configuration conf) {
        TestDispatcher testDispatcher = new TestDispatcher();
        TestAppManagerDispatcher testAppManagerDispatcher = new TestAppManagerDispatcher();
        rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)testDispatcher);
        rmContext.getDispatcher().register(RMAppManagerEventType.class, (EventHandler)testAppManagerDispatcher);
        ((Service)rmContext.getDispatcher()).init(conf);
        ((Service)rmContext.getDispatcher()).start();
        Assert.assertEquals((String)"app event type is wrong before", (Object)RMAppEventType.KILL, (Object)appEventType);
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequests() throws Exception {
        this.asContext.setResource(Resources.createResource((int)1024));
        this.asContext.setAMContainerResourceRequest(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true));
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"/rack", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"/rack/node", (Resource)Resources.createResource((int)1025), (int)1, (boolean)true));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        Assert.assertEquals(reqs.get(0), (Object)this.asContext.getAMContainerResourceRequest());
        Assert.assertEquals(reqs, (Object)this.asContext.getAMContainerResourceRequests());
        RMApp app = this.testRMAppSubmit();
        for (ResourceRequest req : reqs) {
            req.setNodeLabelExpression("");
        }
        Assert.assertEquals(reqs, (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequest() throws Exception {
        this.asContext.setResource(Resources.createResource((int)1024));
        this.asContext.setAMContainerResourceRequests(null);
        ResourceRequest req = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)true);
        req.setNodeLabelExpression("");
        this.asContext.setAMContainerResourceRequest(ResourceRequest.clone((ResourceRequest)req));
        Assert.assertEquals((Object)req, (Object)this.asContext.getAMContainerResourceRequest());
        Assert.assertEquals((Object)req, this.asContext.getAMContainerResourceRequests().get(0));
        Assert.assertEquals((long)1L, (long)this.asContext.getAMContainerResourceRequests().size());
        RMApp app = this.testRMAppSubmit();
        Assert.assertEquals(Collections.singletonList(req), (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitAMContainerWithNoLabelByRMDefaultAMNodeLabel() throws Exception {
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        ResourceRequest anyReq = ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)false, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
        reqs.add(anyReq);
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        this.asContext.setNodeLabelExpression("fixed");
        Configuration conf = new Configuration(false);
        String defaultAMNodeLabel = "core";
        conf.set("yarn.resourcemanager.node-labels.am.default-node-label-expression", defaultAMNodeLabel);
        Mockito.when((Object)this.mockDefaultQueueInfo.getAccessibleNodeLabels()).thenReturn((Object)new HashSet<String>(){
            {
                this.add("core");
            }
        });
        AppManagerTestBase.TestRMAppManager newAppMonitor = this.createAppManager(this.rmContext, conf);
        newAppMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        this.waitUntilEventProcessed();
        Assert.assertEquals((Object)defaultAMNodeLabel, (Object)((ResourceRequest)app.getAMResourceRequests().get(0)).getNodeLabelExpression());
    }

    @Test
    public void testRMAppSubmitResource() throws Exception {
        this.asContext.setResource(Resources.createResource((int)1024));
        this.asContext.setAMContainerResourceRequests(null);
        RMApp app = this.testRMAppSubmit();
        Assert.assertEquals(Collections.singletonList(ResourceRequest.newInstance((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, (String)"")), (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitNoResourceRequests() throws Exception {
        this.asContext.setResource(null);
        this.asContext.setAMContainerResourceRequests(null);
        try {
            this.testRMAppSubmit();
            Assert.fail((String)"Should have failed due to no ResourceRequest");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, no resources requested", (Object)e.getMessage());
        }
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequestsDisagree() throws Exception {
        this.asContext.setResource(null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        Mockito.when((Object)this.mockDefaultQueueInfo.getAccessibleNodeLabels()).thenReturn((Object)new HashSet<String>(){
            {
                this.add("label1");
                this.add("");
            }
        });
        ResourceRequest anyReq = ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)false, (String)"label1", (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
        reqs.add(anyReq);
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"/rack", (Resource)Resources.createResource((int)1025), (int)2, (boolean)false, (String)"", (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC)));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)3), (String)"/rack/node", (Resource)Resources.createResource((int)1026), (int)3, (boolean)true, (String)"", (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC)));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        RMApp app = this.testRMAppSubmit();
        for (ResourceRequest req : reqs) {
            req.setCapability(anyReq.getCapability());
            req.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
            req.setNumContainers(1);
            req.setPriority(Priority.newInstance((int)0));
        }
        Assert.assertEquals(reqs, (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequestsNoAny() throws Exception {
        this.asContext.setResource(null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/rack", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/rack/node", (Resource)Resources.createResource((int)1025), (int)1, (boolean)true));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        Assert.assertEquals(reqs, (Object)this.asContext.getAMContainerResourceRequests());
        try {
            this.testRMAppSubmit();
            Assert.fail((String)"Should have failed due to missing ANY ResourceRequest");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, no resource request specified with *", (Object)e.getMessage());
        }
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequestsTwoManyAny() throws Exception {
        this.asContext.setResource(null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        Assert.assertEquals(reqs, (Object)this.asContext.getAMContainerResourceRequests());
        try {
            this.testRMAppSubmit();
            Assert.fail((String)"Should have failed due to too many ANY ResourceRequests");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, only one resource request with * is allowed", (Object)e.getMessage());
        }
    }

    private RMApp testRMAppSubmit() throws Exception {
        this.appMonitor.submitApplication(this.asContext, "test");
        return this.waitUntilEventProcessed();
    }

    private RMApp waitUntilEventProcessed() throws InterruptedException {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)this.appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.NEW, (Object)app.getState());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
        return app;
    }

    @Test
    public void testRMAppSubmitWithInvalidTokens() throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.asContext.getAMContainerSpec().setTokens(securityTokens);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because Tokens are invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not java.io.EOFException", (boolean)e.getMessage().contains("java.io.EOFException"));
        }
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.APP_REJECTED, (Object)this.getAppEventType());
        this.asContext.getAMContainerSpec().setTokens(null);
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitMaxAppAttempts() throws Exception {
        int[] globalMaxAppAttempts = new int[]{10, 1};
        int[] rmAmMaxAttempts = new int[]{8, 1};
        int[][] individualMaxAppAttempts = new int[][]{{9, 10, 11, 0}, {1, 10, 0, -1}};
        int[][] expectedNums = new int[][]{{9, 10, 10, 8}, {1, 1, 1, 1}};
        for (int i = 0; i < globalMaxAppAttempts.length; ++i) {
            for (int j = 0; j < individualMaxAppAttempts.length; ++j) {
                this.scheduler = TestAppManager.mockResourceScheduler();
                Configuration conf = new Configuration();
                conf.setInt("yarn.resourcemanager.am.global.max-attempts", globalMaxAppAttempts[i]);
                conf.setInt("yarn.resourcemanager.am.max-attempts", rmAmMaxAttempts[i]);
                ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)this.scheduler);
                AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)this.scheduler, masterService, new ApplicationACLsManager(conf), conf);
                ApplicationId appID = MockApps.newAppID((int)(i * 4 + j + 1));
                this.asContext.setApplicationId(appID);
                if (individualMaxAppAttempts[i][j] != 0) {
                    this.asContext.setMaxAppAttempts(individualMaxAppAttempts[i][j]);
                }
                appMonitor.submitApplication(this.asContext, "test");
                RMApp app = (RMApp)this.rmContext.getRMApps().get(appID);
                Assert.assertEquals((String)"max application attempts doesn't match", (long)expectedNums[i][j], (long)app.getMaxAppAttempts());
                int timeoutSecs = 0;
                while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
                    Thread.sleep(1000L);
                }
                this.setAppEventType(RMAppEventType.KILL);
            }
        }
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitDuplicateApplicationId() throws Exception {
        ApplicationId appId = MockApps.newAppID((int)0);
        this.asContext.setApplicationId(appId);
        RMApp appOrig = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertTrue((String)"app name matches but shouldn't", ("testApp1" != appOrig.getName() ? 1 : 0) != 0);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Exception is expected when applicationId is duplicate.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not the expectd one.", (boolean)e.getMessage().contains("Cannot add a duplicate!"));
        }
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.FINISHED, (Object)app.getState());
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitInvalidResourceRequest() throws Exception {
        this.asContext.setResource(Resources.createResource((int)8193));
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because resource request is invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not InvalidResourceRequestException", (boolean)e.getMessage().contains("Invalid resource request"));
        }
    }

    @Test(timeout=30000L)
    public void testEscapeApplicationSummary() {
        RMApp app = (RMApp)Mockito.mock(RMAppImpl.class);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asc.getNodeLabelExpression()).thenReturn((Object)"test");
        Mockito.when((Object)app.getApplicationSubmissionContext()).thenReturn((Object)asc);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)100L, (int)1));
        Mockito.when((Object)app.getName()).thenReturn((Object)"Multiline\n\n\r\rAppName");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"Multiline\n\n\r\rUserName");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"Multiline\n\n\r\rQueueName");
        Mockito.when((Object)app.getState()).thenReturn((Object)RMAppState.RUNNING);
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"MAPREDUCE");
        Mockito.when((Object)app.getSubmitTime()).thenReturn((Object)1000L);
        Mockito.when((Object)app.getLaunchTime()).thenReturn((Object)2000L);
        Mockito.when((Object)app.getApplicationTags()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"tag2", "tag1"}));
        RMAppAttempt mockRMAppAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Container mockContainer = (Container)Mockito.mock(Container.class);
        NodeId mockNodeId = (NodeId)Mockito.mock(NodeId.class);
        String host = "127.0.0.1";
        Mockito.when((Object)mockNodeId.getHost()).thenReturn((Object)host);
        Mockito.when((Object)mockContainer.getNodeId()).thenReturn((Object)mockNodeId);
        Mockito.when((Object)mockRMAppAttempt.getMasterContainer()).thenReturn((Object)mockContainer);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)mockRMAppAttempt);
        HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
        resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), 16384L);
        resourceSecondsMap.put(ResourceInformation.VCORES.getName(), 64L);
        RMAppMetrics metrics = new RMAppMetrics(Resource.newInstance((int)1234, (int)56), 10, 1, resourceSecondsMap, new HashMap(), 1234);
        Mockito.when((Object)app.getRMAppMetrics()).thenReturn((Object)metrics);
        Mockito.when((Object)app.getDiagnostics()).thenReturn((Object)new StringBuilder("Multiline\n\n\r\rDiagnostics=Diagn,ostic"));
        new RMAppManager.ApplicationSummary();
        RMAppManager.ApplicationSummary.SummaryBuilder summary = RMAppManager.ApplicationSummary.createAppSummary((RMApp)app);
        String msg = summary.toString();
        LOG.info("summary: " + msg);
        Assert.assertFalse((boolean)msg.contains("\n"));
        Assert.assertFalse((boolean)msg.contains("\r"));
        String escaped = "\\n\\n\\r\\r";
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "AppName"));
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "UserName"));
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "QueueName"));
        Assert.assertTrue((boolean)msg.contains("appMasterHost=" + host));
        Assert.assertTrue((boolean)msg.contains("submitTime=1000"));
        Assert.assertTrue((boolean)msg.contains("launchTime=2000"));
        Assert.assertTrue((boolean)msg.contains("memorySeconds=16384"));
        Assert.assertTrue((boolean)msg.contains("vcoreSeconds=64"));
        Assert.assertTrue((boolean)msg.contains("preemptedAMContainers=1"));
        Assert.assertTrue((boolean)msg.contains("preemptedNonAMContainers=10"));
        Assert.assertTrue((boolean)msg.contains("preemptedResources=<memory:1234\\, vCores:56>"));
        Assert.assertTrue((boolean)msg.contains("applicationType=MAPREDUCE"));
        Assert.assertTrue((boolean)msg.contains("applicationTags=tag1\\,tag2"));
        Assert.assertTrue((boolean)msg.contains("applicationNodeLabel=test"));
        Assert.assertTrue((boolean)msg.contains("diagnostics=Multiline" + escaped + "Diagnostics\\=Diagn\\,ostic"));
        Assert.assertTrue((boolean)msg.contains("totalAllocatedContainers=1234"));
    }

    @Test
    public void testRMAppSubmitWithQueueChanged() throws Exception {
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext("newQueue");
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(ApplicationSubmissionContext.class), (String)ArgumentMatchers.any(String.class), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue());
        this.rmContext.setQueuePlacementManager(placementMgr);
        this.asContext.setQueue("oldQueue");
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        RMAppEvent event = new RMAppEvent(this.appId, RMAppEventType.START);
        ((RMApp)this.rmContext.getRMApps().get(this.appId)).handle((Event)event);
        event = new RMAppEvent(this.appId, RMAppEventType.APP_NEW_SAVED);
        ((RMApp)this.rmContext.getRMApps().get(this.appId)).handle((Event)event);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((Object)"newQueue", (Object)this.asContext.getQueue());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
    }

    private static ResourceScheduler mockResourceScheduler() {
        return TestAppManager.mockResourceScheduler(ResourceScheduler.class);
    }

    private static <T extends ResourceScheduler> ResourceScheduler mockResourceScheduler(Class<T> schedulerClass) {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(schedulerClass);
        Mockito.when((Object)scheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)scheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)scheduler.getMaximumResourceCapability((String)ArgumentMatchers.any(String.class))).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)scheduler.getMaximumResourceCapability(ArgumentMatchers.anyString())).thenReturn((Object)Resources.createResource((int)8192));
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)rs);
        Mockito.when((Object)scheduler.getNormalizedResource((Resource)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (Resource)invocationOnMock.getArguments()[0];
            }
        });
        return scheduler;
    }

    private static ContainerLaunchContext mockContainerLaunchContext(RecordFactory recordFactory) {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        amContainer.setApplicationACLs(new HashMap());
        return amContainer;
    }

    private static Resource mockResource() {
        return Resources.createResource((int)1024);
    }

    private static List<ResourceRequest> cloneResourceRequests(List<ResourceRequest> reqs) {
        ArrayList<ResourceRequest> cloneReqs = new ArrayList<ResourceRequest>();
        for (ResourceRequest req : reqs) {
            cloneReqs.add(ResourceRequest.clone((ResourceRequest)req));
        }
        return cloneReqs;
    }

    @Test
    public void testGetUserNameForPlacementTagBasedPlacementDisabled() throws YarnException {
        String user = "user1";
        String expectedQueue = "user1Queue";
        String userNameFromAppTag = "user2";
        String userIdTag = USER_ID_PREFIX + userNameFromAppTag;
        this.setApplicationTags("tag1", userIdTag, "tag2");
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, user);
    }

    @Test
    public void testGetUserNameForPlacementTagBasedPlacementEnabled() throws YarnException {
        String user = "user1";
        String usernameFromAppTag = "user2";
        String expectedQueue = "user1Queue";
        String expectedUser = usernameFromAppTag;
        String userIdTag = USER_ID_PREFIX + usernameFromAppTag;
        this.setApplicationTags("tag1", userIdTag, "tag2");
        this.enableApplicationTagPlacement(true, user);
        this.verifyPlacementUsername(expectedQueue, user, usernameFromAppTag, expectedUser);
    }

    @Test
    public void testGetUserNameForPlacementTagBasedPlacementMultipleUserIds() throws YarnException {
        String userNameFromAppTag;
        String user = "user1";
        String expectedQueue = "user1Queue";
        String expectedUser = userNameFromAppTag = "user2";
        String userIdTag = USER_ID_PREFIX + expectedUser;
        String userIdTag2 = "userid=user3";
        this.setApplicationTags("tag1", userIdTag, "tag2", userIdTag2);
        this.enableApplicationTagPlacement(true, user);
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, expectedUser);
    }

    @Test
    public void testGetUserNameForPlacementTagBasedPlacementNoUserId() throws YarnException {
        String user = "user1";
        String expectedQueue = "user1Queue";
        String userNameFromAppTag = null;
        this.setApplicationTags("tag1", "tag2");
        this.enableApplicationTagPlacement(true, user);
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, user);
    }

    @Test
    public void testGetUserNameForPlacementUserWithoutAccessToQueue() throws YarnException {
        String user = "user1";
        String expectedQueue = "user1Queue";
        String userNameFromAppTag = "user2";
        String userIdTag = USER_ID_PREFIX + userNameFromAppTag;
        this.setApplicationTags("tag1", userIdTag, "tag2");
        this.enableApplicationTagPlacement(false, user);
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, user);
    }

    @Test
    public void testGetUserNameForPlacementNotWhitelistedUser() throws YarnException {
        String user = "user1";
        String expectedQueue = "user1Queue";
        String userNameFromAppTag = "user2";
        String userIdTag = USER_ID_PREFIX + userNameFromAppTag;
        this.setApplicationTags("tag1", userIdTag, "tag2");
        this.enableApplicationTagPlacement(true, "someUser");
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, user);
    }

    @Test
    public void testGetUserNameForPlacementEmptyWhiteList() throws YarnException {
        String user = "user1";
        String expectedQueue = "user1Queue";
        String userNameFromAppTag = "user2";
        String userIdTag = USER_ID_PREFIX + userNameFromAppTag;
        this.setApplicationTags("tag1", userIdTag, "tag2");
        this.enableApplicationTagPlacement(false, new String[0]);
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, user);
    }

    @Test
    public void testGetUserNameForPlacementWronglyQualifiedFirstUserNameInTag() throws YarnException {
        String userNameFromAppTag;
        String user = "user1";
        String expectedQueue = "user1Queue";
        String expectedUser = userNameFromAppTag = "user2";
        String userIdTag = USER_ID_PREFIX + userNameFromAppTag;
        String wrongUserIdTag = USER_ID_PREFIX;
        this.setApplicationTags("tag1", wrongUserIdTag, userIdTag, "tag2");
        this.enableApplicationTagPlacement(true, user);
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, expectedUser);
    }

    @Test
    public void testGetUserNameForPlacementWronglyQualifiedUserNameInTag() throws YarnException {
        String user = "user1";
        String expectedQueue = "user1Queue";
        String userNameFromAppTag = "";
        String wrongUserIdTag = USER_ID_PREFIX;
        this.setApplicationTags("tag1", wrongUserIdTag, "tag2");
        this.enableApplicationTagPlacement(true, user);
        this.verifyPlacementUsername(expectedQueue, user, userNameFromAppTag, user);
    }

    @Test
    public void testGetUserNameForPlacementNoRuleDefined() throws YarnException {
        String user;
        String expectedUser = user = "user1";
        String userNameFromAppTag = "user2";
        String wrongUserIdTag = USER_ID_PREFIX + userNameFromAppTag;
        this.setApplicationTags("tag1", wrongUserIdTag, "tag2");
        this.enableApplicationTagPlacement(true, user);
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        Mockito.when((Object)placementMgr.placeApplication(this.asContext, userNameFromAppTag)).thenReturn(null);
        String userNameForPlacement = this.appMonitor.getUserNameForPlacement(user, this.asContext, placementMgr);
        Assert.assertEquals((Object)expectedUser, (Object)userNameForPlacement);
    }

    @Test
    @UseMockCapacityScheduler
    public void testCheckAccessFullPathWithCapacityScheduler() throws YarnException {
        this.testCheckAccess("root.users", "hadoop");
    }

    @Test
    @UseMockCapacityScheduler
    public void testCheckAccessLeafQueueOnlyWithCapacityScheduler() throws YarnException {
        this.testCheckAccess(null, "hadoop");
    }

    private void testCheckAccess(String parent, String queue) throws YarnException {
        Object expectedQueue;
        ApplicationPlacementContext appContext;
        this.enableApplicationTagPlacement(true, "hadoop");
        String userIdTag = "userid=hadoop";
        this.setApplicationTags("tag1", userIdTag, "tag2");
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        if (parent == null) {
            appContext = new ApplicationPlacementContext(queue);
            expectedQueue = queue;
        } else {
            appContext = new ApplicationPlacementContext(queue, parent);
            expectedQueue = parent + "." + queue;
        }
        Mockito.when((Object)placementMgr.placeApplication(this.asContext, "hadoop")).thenReturn((Object)appContext);
        this.appMonitor.getUserNameForPlacement("hadoop", this.asContext, placementMgr);
        ArgumentCaptor queueNameCaptor = ArgumentCaptor.forClass(String.class);
        ((ResourceScheduler)Mockito.verify((Object)this.scheduler)).checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (String)queueNameCaptor.capture());
        Assert.assertEquals((String)"Expected access check for queue", (Object)expectedQueue, (Object)queueNameCaptor.getValue());
    }

    private void enableApplicationTagPlacement(boolean userHasAccessToQueue, String ... whiteListedUsers) {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.application-tag-based-placement.enable", true);
        conf.setStrings("yarn.resourcemanager.application-tag-based-placement.username.whitelist", whiteListedUsers);
        ((RMContextImpl)this.rmContext).setYarnConfiguration(conf);
        Mockito.when((Object)this.scheduler.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.eq((Object)QueueACL.SUBMIT_APPLICATIONS), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)userHasAccessToQueue);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)this.scheduler);
        this.appMonitor = new AppManagerTestBase.TestRMAppManager(this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)this.scheduler, masterService, new ApplicationACLsManager(conf), conf);
    }

    private void verifyPlacementUsername(String queue, String submittingUser, String userNameFRomAppTag, String expectedUser) throws YarnException {
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ApplicationPlacementContext appContext = new ApplicationPlacementContext(queue);
        Mockito.when((Object)placementMgr.placeApplication(this.asContext, userNameFRomAppTag)).thenReturn((Object)appContext);
        String userNameForPlacement = this.appMonitor.getUserNameForPlacement(submittingUser, this.asContext, placementMgr);
        Assert.assertEquals((Object)expectedUser, (Object)userNameForPlacement);
    }

    private void setApplicationTags(String ... tags) {
        TreeSet applicationTags = new TreeSet();
        Collections.addAll(applicationTags, tags);
        this.asContext.setApplicationTags(applicationTags);
    }

    private class UseCapacitySchedulerRule
    extends TestWatcher {
        private boolean useCapacityScheduler;

        private UseCapacitySchedulerRule() {
        }

        protected void starting(Description d) {
            this.useCapacityScheduler = d.getAnnotation(UseMockCapacityScheduler.class) != null;
        }

        public boolean useCapacityScheduler() {
            return this.useCapacityScheduler;
        }
    }

    public class TestDispatcher
    implements EventHandler<RMAppEvent> {
        public void handle(RMAppEvent event) {
            TestAppManager.this.setAppEventType((RMAppEventType)event.getType());
            System.out.println("in handle routine " + TestAppManager.this.getAppEventType().toString());
        }
    }

    public class TestAppManagerDispatcher
    implements EventHandler<RMAppManagerEvent> {
        public void handle(RMAppManagerEvent event) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UseMockCapacityScheduler {
    }
}

