/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;

public class AppManagerTestBase {

    protected class TestRMAppManager
    extends RMAppManager {
        private final RMStateStore stateStore;

        public TestRMAppManager(RMContext context, Configuration conf) {
            super(context, null, null, new ApplicationACLsManager(conf), conf);
            this.stateStore = context.getStateStore();
        }

        public TestRMAppManager(RMContext context, ClientToAMTokenSecretManagerInRM clientToAMSecretManager, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
            super(context, scheduler, masterService, applicationACLsManager, conf);
            this.stateStore = context.getStateStore();
        }

        public void checkAppNumCompletedLimit() {
            super.checkAppNumCompletedLimit();
        }

        public void finishApplication(ApplicationId appId) {
            super.finishApplication(appId);
        }

        public int getCompletedAppsListSize() {
            return super.getCompletedAppsListSize();
        }

        public int getNumberOfCompletedAppsInStateStore() {
            return this.completedAppsInStateStore;
        }

        public void submitApplication(ApplicationSubmissionContext submissionContext, String user) throws YarnException {
            super.submitApplication(submissionContext, System.currentTimeMillis(), UserGroupInformation.createRemoteUser((String)user));
        }

        public String getUserNameForPlacement(String user, ApplicationSubmissionContext context, PlacementManager placementManager) throws YarnException {
            return super.getUserNameForPlacement(user, context, placementManager);
        }
    }
}

