/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestUsersManager {
    private static final Resource CLUSTER_RESOURCE = Resource.newInstance((int)16384, (int)16);
    private static final Resource MINIMUM_ALLOCATION = Resource.newInstance((int)1024, (int)1);
    private static final Resource MAX_RESOURCE_LIMIT = Resource.newInstance((int)9216, (int)1);
    private static final Resource NON_ZERO_CAPACITY = Resource.newInstance((int)8192, (int)1);
    private static final String TEST_USER = "test";
    private UsersManager usersManager;
    @Mock
    private AutoCreatedLeafQueue lQueue;
    @Mock
    private RMNodeLabelsManager labelMgr;
    @Mock
    private QueueMetrics metrics;

    @Before
    public void setup() {
        this.usersManager = new UsersManager(this.metrics, (AbstractLeafQueue)this.lQueue, this.labelMgr, (ResourceCalculator)new DefaultResourceCalculator());
        Mockito.when((Object)this.lQueue.getMinimumAllocation()).thenReturn((Object)MINIMUM_ALLOCATION);
        Mockito.when((Object)this.lQueue.getEffectiveMaxCapacityDown(ArgumentMatchers.anyString(), (Resource)ArgumentMatchers.any(Resource.class))).thenReturn((Object)MAX_RESOURCE_LIMIT);
        Mockito.when((Object)this.labelMgr.getResourceByLabel(ArgumentMatchers.anyString(), (Resource)ArgumentMatchers.any(Resource.class))).thenReturn((Object)CLUSTER_RESOURCE);
        this.usersManager.setUsageRatio("", 0.5f);
        this.usersManager.setUserLimit(100.0f);
        this.usersManager.setUserLimitFactor(1.0f);
    }

    @Test
    public void testComputeUserLimitWithZeroCapacityQueue() {
        Mockito.when((Object)this.lQueue.getEffectiveCapacity(ArgumentMatchers.anyString())).thenReturn((Object)Resources.none());
        this.checkLimit(MAX_RESOURCE_LIMIT);
    }

    @Test
    public void testComputeUserLimitWithNonZeroCapacityQueue() {
        Mockito.when((Object)this.lQueue.getEffectiveCapacity(ArgumentMatchers.anyString())).thenReturn((Object)NON_ZERO_CAPACITY);
        this.checkLimit(NON_ZERO_CAPACITY);
    }

    private void checkLimit(Resource expectedLimit) {
        Resource limit = this.usersManager.computeUserLimit(TEST_USER, CLUSTER_RESOURCE, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, true);
        Assert.assertEquals((String)"User limit", (Object)expectedLimit, (Object)limit);
    }
}

