/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFSRMStateStore
extends RMStateStoreTestBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestFSRMStateStore.class);
    private TestFSRMStateStoreTester fsTester;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testFSRMStateStore() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            this.fsTester = new TestFSRMStateStoreTester(cluster, false);
            FSDataOutputStream fsOut = null;
            FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
            String appAttemptIdStr3 = "appattempt_1352994193343_0001_000003";
            ApplicationAttemptId attemptId3 = ApplicationAttemptId.fromString((String)appAttemptIdStr3);
            Path appDir = this.fsTester.store.getAppDir(attemptId3.getApplicationId().toString());
            Path tempAppAttemptFile = new Path(appDir, attemptId3.toString() + ".tmp");
            fsOut = fileSystemRMStateStore.fs.create(tempAppAttemptFile, false);
            fsOut.write("Some random data ".getBytes());
            fsOut.close();
            this.testRMAppStateStore(this.fsTester);
            Assert.assertFalse((boolean)this.fsTester.workingDirPathURI.getFileSystem((Configuration)conf).exists(tempAppAttemptFile));
            this.testRMDTSecretManagerStateStore(this.fsTester);
            this.testCheckVersion(this.fsTester);
            this.testEpoch(this.fsTester);
            this.testAppDeletion(this.fsTester);
            this.testDeleteStore(this.fsTester);
            this.testRemoveApplication(this.fsTester);
            this.testRemoveAttempt(this.fsTester);
            this.testAMRMTokenSecretManagerStateStore(this.fsTester);
            this.testReservationStateStore(this.fsTester);
            this.testProxyCA(this.fsTester);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testHDFSRMStateStore() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        UserGroupInformation yarnAdmin = UserGroupInformation.createUserForTesting((String)"yarn", (String[])new String[]{"admin"});
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.getFileSystem().mkdir(new Path("/yarn"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        cluster.getFileSystem().setOwner(new Path("/yarn"), "yarn", "admin");
        final UserGroupInformation hdfsAdmin = UserGroupInformation.getCurrentUser();
        final RMStateStoreTestBase.StoreStateVerifier verifier = new RMStateStoreTestBase.StoreStateVerifier(){

            @Override
            void afterStoreApp(final RMStateStore store, final ApplicationId appId) {
                try {
                    Thread.sleep(5000L);
                    hdfsAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            TestFSRMStateStore.this.verifyFilesUnreadablebyHDFS(cluster, ((FileSystemRMStateStore)store).getAppDir(appId));
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            void afterStoreAppAttempt(final RMStateStore store, final ApplicationAttemptId appAttId) {
                try {
                    Thread.sleep(5000L);
                    hdfsAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            TestFSRMStateStore.this.verifyFilesUnreadablebyHDFS(cluster, ((FileSystemRMStateStore)store).getAppAttemptDir(appAttId));
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            yarnAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestFSRMStateStore.this.fsTester = new TestFSRMStateStoreTester(cluster, true);
                    TestFSRMStateStore.this.testRMAppStateStore(TestFSRMStateStore.this.fsTester, verifier);
                    return null;
                }
            });
        }
        finally {
            cluster.shutdown();
        }
    }

    private void verifyFilesUnreadablebyHDFS(MiniDFSCluster cluster, Path root) throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.add(root);
        while (!paths.isEmpty()) {
            FileStatus[] ls;
            Path p = (Path)paths.poll();
            FileStatus stat = fs.getFileStatus(p);
            if (!stat.isDirectory()) {
                try {
                    LOG.warn("\n\n ##Testing path [" + p + "]\n\n");
                    fs.open(p);
                    Assert.fail((String)("Super user should not be able to read [" + UserGroupInformation.getCurrentUser() + "] [" + p.getName() + "]"));
                }
                catch (AccessControlException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("superuser is not allowed to perform this operation"));
                }
                catch (Exception e) {
                    Assert.fail((String)"Should get an AccessControlException here");
                }
            }
            if (!stat.isDirectory()) continue;
            for (FileStatus f : ls = fs.listStatus(p)) {
                paths.add(f.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCheckMajorVersionChange() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            this.fsTester = new TestFSRMStateStoreTester(cluster, false){
                Version VERSION_INFO;
                {
                    this.VERSION_INFO = Version.newInstance((int)Integer.MAX_VALUE, (int)0);
                }

                @Override
                public Version getCurrentVersion() throws Exception {
                    return this.VERSION_INFO;
                }

                @Override
                public RMStateStore getRMStateStore() throws Exception {
                    YarnConfiguration conf = new YarnConfiguration();
                    conf.set("yarn.resourcemanager.fs.state-store.uri", this.workingDirPathURI.toString());
                    this.store = new TestFSRMStateStoreTester.TestFileSystemRMStore((Configuration)conf){
                        Version storedVersion;
                        {
                            this.storedVersion = null;
                        }

                        @Override
                        public Version getCurrentVersion() {
                            return VERSION_INFO;
                        }

                        protected synchronized Version loadVersion() throws Exception {
                            return this.storedVersion;
                        }

                        protected synchronized void storeVersion() throws Exception {
                            this.storedVersion = VERSION_INFO;
                        }
                    };
                    return this.store;
                }
            };
            RMStateStore store = this.fsTester.getRMStateStore();
            Version defaultVersion = this.fsTester.getCurrentVersion();
            store.checkVersion();
            Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Override
    protected void modifyAppState() throws Exception {
        String appAttemptIdStr1 = "appattempt_1352994193343_0001_000001";
        ApplicationAttemptId attemptId1 = ApplicationAttemptId.fromString((String)appAttemptIdStr1);
        Path appDir = this.fsTester.store.getAppDir(attemptId1.getApplicationId().toString());
        Path appAttemptFile1 = new Path(appDir, attemptId1.toString() + ".new");
        FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
        fileSystemRMStateStore.renameFile(appAttemptFile1, new Path(appAttemptFile1.getParent(), appAttemptFile1.getName() + ".new"));
    }

    @Override
    protected void modifyRMDelegationTokenState() throws Exception {
        Path nodeCreatePath = this.fsTester.store.getNodePath(this.fsTester.store.rmDTSecretManagerRoot, "RMDelegationToken_0");
        FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
        fileSystemRMStateStore.renameFile(nodeCreatePath, new Path(nodeCreatePath.getParent(), nodeCreatePath.getName() + ".new"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testFSRMStateStoreClientRetry() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            TestFSRMStateStoreTester fsTester = new TestFSRMStateStoreTester(cluster, false);
            final RMStateStore store = fsTester.getRMStateStore();
            store.setRMDispatcher((Dispatcher)new RMStateStoreTestBase.TestDispatcher());
            final AtomicBoolean assertionFailedInThread = new AtomicBoolean(false);
            cluster.shutdownNameNodes();
            Thread clientThread = new Thread(){

                @Override
                public void run() {
                    try {
                        store.storeApplicationStateInternal(ApplicationId.newInstance((long)100L, (int)1), ApplicationStateData.newInstance((long)111L, (long)111L, (String)"user", null, (RMAppState)RMAppState.ACCEPTED, (String)"diagnostics", (long)222L, (long)333L, null));
                    }
                    catch (Exception e) {
                        assertionFailedInThread.set(true);
                        e.printStackTrace();
                    }
                }
            };
            Thread.sleep(2000L);
            clientThread.start();
            cluster.restartNameNode(new String[0]);
            clientThread.join();
            Assert.assertFalse((boolean)assertionFailedInThread.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    class TestFSRMStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        Path workingDirPathURI;
        TestFileSystemRMStore store;
        MiniDFSCluster cluster;
        boolean adminCheckEnable;

        public TestFSRMStateStoreTester(MiniDFSCluster cluster, boolean adminCheckEnable) throws Exception {
            Path workingDirPath = new Path("/yarn/Test");
            this.adminCheckEnable = adminCheckEnable;
            this.cluster = cluster;
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.mkdirs(workingDirPath);
            Path clusterURI = new Path(cluster.getURI());
            this.workingDirPathURI = new Path(clusterURI, workingDirPath);
            fs.close();
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("yarn.resourcemanager.fs.state-store.uri", this.workingDirPathURI.toString());
            conf.setInt("yarn.resourcemanager.fs.state-store.num-retries", 8);
            conf.setLong("yarn.resourcemanager.fs.state-store.retry-interval-ms", 900L);
            conf.setLong("yarn.resourcemanager.epoch", 10L);
            conf.setLong("yarn.resourcemanager.epoch.range", TestFSRMStateStore.this.getEpochRange());
            if (this.adminCheckEnable) {
                conf.setBoolean("yarn.intermediate-data-encryption.enable", true);
            }
            this.store = new TestFileSystemRMStore((Configuration)conf);
            Assertions.assertThat((int)this.store.getNumRetries()).isEqualTo(8);
            Assertions.assertThat((long)this.store.getRetryInterval()).isEqualTo(900L);
            Assert.assertTrue((this.store.fs.getConf() == this.store.fsConf ? 1 : 0) != 0);
            FileSystem previousFs = this.store.fs;
            this.store.startInternal();
            Assert.assertTrue((this.store.fs != previousFs ? 1 : 0) != 0);
            Assert.assertTrue((this.store.fs.getConf() == this.store.fsConf ? 1 : 0) != 0);
            return this.store;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            FileStatus[] files = fs.listStatus(this.workingDirPathURI);
            return files.length == 1;
        }

        @Override
        public void writeVersion(Version version) throws Exception {
            this.store.updateFile(this.store.getVersionNode(), ((VersionPBImpl)version).getProto().toByteArray(), false);
        }

        @Override
        public Version getCurrentVersion() throws Exception {
            return this.store.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws IOException {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path nodePath = this.store.getAppDir(app.getApplicationId().toString());
            return fs.exists(nodePath);
        }

        @Override
        public boolean attemptExists(RMAppAttempt attempt) throws IOException {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            ApplicationAttemptId attemptId = attempt.getAppAttemptId();
            Path nodePath = this.store.getAttemptDir(attemptId.getApplicationId().toString(), attemptId.toString());
            return fs.exists(nodePath);
        }

        class TestFileSystemRMStore
        extends FileSystemRMStateStore {
            TestFileSystemRMStore(Configuration conf) throws Exception {
                this.init(conf);
                Assert.assertNull((Object)this.fs);
                Assert.assertTrue((boolean)TestFSRMStateStoreTester.this.workingDirPathURI.equals((Object)this.fsWorkingPath));
                this.dispatcher.disableExitOnDispatchException();
                this.start();
                Assert.assertNotNull((Object)this.fs);
            }

            public Path getVersionNode() {
                return new Path(new Path(TestFSRMStateStoreTester.this.workingDirPathURI, "FSRMStateRoot"), "RMVersionNode");
            }

            public Version getCurrentVersion() {
                return CURRENT_VERSION_INFO;
            }

            public Path getAppDir(String appId) {
                Path rootDir = new Path(TestFSRMStateStoreTester.this.workingDirPathURI, "FSRMStateRoot");
                Path appRootDir = new Path(rootDir, "RMAppRoot");
                Path appDir = new Path(appRootDir, appId);
                return appDir;
            }

            public Path getAttemptDir(String appId, String attemptId) {
                Path appDir = this.getAppDir(appId);
                Path attemptDir = new Path(appDir, attemptId);
                return attemptDir;
            }
        }
    }
}

