/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsMappingProvider;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMDelegatedNodeLabelsUpdater
extends NodeLabelTestBase {
    private YarnConfiguration conf;
    private static Map<NodeId, Set<NodeLabel>> nodeLabelsMap = Maps.newHashMap();

    @Before
    public void setup() {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.node-labels.enabled", true);
        this.conf.set("yarn.node-labels.configuration-type", "delegated-centralized");
        this.conf.setClass("yarn.resourcemanager.node-labels.provider", DummyRMNodeLabelsMappingProvider.class, RMNodeLabelsMappingProvider.class);
    }

    @Test
    public void testRMNodeLabelsMappingProviderConfiguration() {
        this.conf.unset("yarn.resourcemanager.node-labels.provider");
        try {
            MockRM rm = new MockRM((Configuration)this.conf);
            rm.init((Configuration)this.conf);
            rm.start();
            Assert.fail((String)"Expected an exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("RMNodeLabelsMappingProvider should be configured"));
        }
    }

    @Test
    public void testWithNodeLabelUpdateEnabled() throws Exception {
        this.conf.setLong("yarn.resourcemanager.node-labels.provider.fetch-interval-ms", 1000L);
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.init((Configuration)this.conf);
        rm.getRMContext().getRMDelegatedNodeLabelsUpdater().nodeLabelsUpdateInterval = 3000L;
        rm.start();
        RMNodeLabelsManager mgr = rm.getRMContext().getNodeLabelManager();
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        NodeId nodeId = this.toNodeId("h1:1234");
        Assert.assertEquals((long)0L, (long)mgr.getLabelsOnNode(nodeId).size());
        this.updateNodeLabels(nodeId, "x");
        this.registerNode(rm, nodeId);
        Thread.sleep(4000L);
        TestRMDelegatedNodeLabelsUpdater.assertCollectionEquals((Collection)ImmutableSet.of((Object)"x"), (Collection)mgr.getLabelsOnNode(nodeId));
        this.updateNodeLabels(nodeId, "y");
        Thread.sleep(4000L);
        TestRMDelegatedNodeLabelsUpdater.assertCollectionEquals((Collection)ImmutableSet.of((Object)"y"), (Collection)mgr.getLabelsOnNode(nodeId));
        rm.stop();
    }

    @Test
    public void testWithNodeLabelUpdateDisabled() throws Exception {
        this.conf.setLong("yarn.resourcemanager.node-labels.provider.fetch-interval-ms", -1L);
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.init((Configuration)this.conf);
        rm.getRMContext().getRMDelegatedNodeLabelsUpdater().nodeLabelsUpdateInterval = 3000L;
        rm.start();
        RMNodeLabelsManager mgr = rm.getRMContext().getNodeLabelManager();
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x"));
        NodeId nodeId = this.toNodeId("h1:1234");
        this.updateNodeLabels(nodeId, "x");
        this.registerNode(rm, nodeId);
        Thread.sleep(4000L);
        TestRMDelegatedNodeLabelsUpdater.assertCollectionEquals((Collection)ImmutableSet.of((Object)"x"), (Collection)mgr.getLabelsOnNode(nodeId));
        rm.stop();
    }

    private void registerNode(ResourceManager rm, NodeId nodeId) throws YarnException, IOException {
        ResourceTrackerService resourceTrackerService = rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        Resource capability = Resources.createResource((int)1024);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        resourceTrackerService.registerNodeManager(req);
    }

    private void updateNodeLabels(NodeId nodeId, String ... nodeLabelsStr) {
        nodeLabelsMap.put(nodeId, TestRMDelegatedNodeLabelsUpdater.toNodeLabelSet((String[])nodeLabelsStr));
    }

    public static class DummyRMNodeLabelsMappingProvider
    extends RMNodeLabelsMappingProvider {
        public DummyRMNodeLabelsMappingProvider() {
            super("DummyRMNodeLabelsMappingProvider");
        }

        public Map<NodeId, Set<NodeLabel>> getNodeLabels(Set<NodeId> nodes) {
            HashMap nodeLabels = Maps.newHashMap();
            for (NodeId node : nodes) {
                nodeLabels.put(node, nodeLabelsMap.get(node));
            }
            return nodeLabels;
        }
    }
}

