/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.AppManagerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAppManagerWithFairScheduler
extends AppManagerTestBase {
    private static final String TEST_FOLDER = "test-queues";
    private static YarnConfiguration conf = new YarnConfiguration();
    private PlacementManager placementMgr;
    private AppManagerTestBase.TestRMAppManager rmAppManager;
    private RMContext rmContext;
    private static String allocFileName = GenericTestUtils.getTestDir((String)"test-queues").getAbsolutePath();

    @Before
    public void setup() throws IOException {
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("test").build()).writeToFile(allocFileName);
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("yarn.scheduler.fair.allocation.file", allocFileName);
        this.placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        MockRM mockRM = new MockRM((Configuration)conf);
        this.rmContext = mockRM.getRMContext();
        this.rmContext.setQueuePlacementManager(this.placementMgr);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)this.rmContext.getScheduler());
        this.rmAppManager = new AppManagerTestBase.TestRMAppManager(this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)this.rmContext.getScheduler(), masterService, new ApplicationACLsManager((Configuration)conf), (Configuration)conf);
    }

    @After
    public void teardown() {
        File allocFile = GenericTestUtils.getTestDir((String)TEST_FOLDER);
        allocFile.delete();
    }

    @Test
    public void testQueueSubmitWithHighQueueContainerSize() throws YarnException, IOException {
        int maxAlloc = 1024;
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").subQueue(new AllocationFileQueue.Builder("limited").maxContainerAllocation(maxAlloc + " mb 1 vcores").build()).subQueue(new AllocationFileQueue.Builder("unlimited").build()).build()).writeToFile(allocFileName);
        this.rmContext.getScheduler().reinitialize((Configuration)conf, this.rmContext);
        ApplicationId appId = MockApps.newAppID((int)1);
        Resource res = Resources.createResource((int)(maxAlloc + 1));
        ApplicationSubmissionContext asContext = this.createAppSubmitCtx(appId, res);
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("limited"));
        try {
            this.rmAppManager.submitApplication(asContext, "test");
            Assert.fail((String)"Test should fail on too high allocation!");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION, (Object)e.getInvalidResourceType());
        }
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("root.unlimited"));
        this.rmAppManager.submitApplication(asContext, "test");
    }

    @Test
    public void testQueueSubmitWithPermissionLimits() throws YarnException, IOException {
        conf.set("yarn.acl.enable", "true");
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").aclSubmitApps(" ").aclAdministerApps(" ").subQueue(new AllocationFileQueue.Builder("noaccess").build()).subQueue(new AllocationFileQueue.Builder("submitonly").aclSubmitApps("test ").aclAdministerApps(" ").build()).subQueue(new AllocationFileQueue.Builder("adminonly").aclSubmitApps(" ").aclAdministerApps("test ").build()).build()).writeToFile(allocFileName);
        this.rmContext.getScheduler().reinitialize((Configuration)conf, this.rmContext);
        ApplicationId appId = MockApps.newAppID((int)1);
        Resource res = Resources.createResource((int)1024, (int)1);
        ApplicationSubmissionContext asContext = this.createAppSubmitCtx(appId, res);
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("noaccess"));
        try {
            this.rmAppManager.submitApplication(asContext, "test");
            Assert.fail((String)"Test should have failed with access denied");
        }
        catch (YarnException e) {
            TestCase.assertTrue((String)"Access exception not found", (boolean)(e.getCause() instanceof AccessControlException));
        }
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("submitonly"));
        this.rmAppManager.submitApplication(asContext, "test");
        appId = MockApps.newAppID((int)2);
        asContext = this.createAppSubmitCtx(appId, res);
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("adminonly"));
        this.rmAppManager.submitApplication(asContext, "test");
    }

    @Test
    public void testQueueSubmitWithRootPermission() throws YarnException, IOException {
        conf.set("yarn.acl.enable", "true");
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").subQueue(new AllocationFileQueue.Builder("noaccess").aclSubmitApps(" ").aclAdministerApps(" ").build()).build()).writeToFile(allocFileName);
        this.rmContext.getScheduler().reinitialize((Configuration)conf, this.rmContext);
        ApplicationId appId = MockApps.newAppID((int)1);
        Resource res = Resources.createResource((int)1024, (int)1);
        ApplicationSubmissionContext asContext = this.createAppSubmitCtx(appId, res);
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)new ApplicationPlacementContext("noaccess"));
        this.rmAppManager.submitApplication(asContext, "test");
    }

    @Test
    public void testQueueSubmitWithAutoCreateQueue() throws YarnException, IOException {
        conf.set("yarn.acl.enable", "true");
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").aclSubmitApps(" ").aclAdministerApps(" ").subQueue(new AllocationFileQueue.Builder("noaccess").parent(true).build()).subQueue(new AllocationFileQueue.Builder("submitonly").parent(true).aclSubmitApps("test ").build()).build()).writeToFile(allocFileName);
        this.rmContext.getScheduler().reinitialize((Configuration)conf, this.rmContext);
        ApplicationId appId = MockApps.newAppID((int)1);
        Resource res = Resources.createResource((int)1024, (int)1);
        ApplicationSubmissionContext asContext = this.createAppSubmitCtx(appId, res);
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("root.noaccess.child"));
        try {
            this.rmAppManager.submitApplication(asContext, "test");
            Assert.fail((String)"Test should have failed with access denied");
        }
        catch (YarnException e) {
            TestCase.assertTrue((String)"Access exception not found", (boolean)(e.getCause() instanceof AccessControlException));
        }
        Mockito.when((Object)this.placementMgr.placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)new ApplicationPlacementContext("root.submitonly.child"));
        this.rmAppManager.submitApplication(asContext, "test");
    }

    private ApplicationSubmissionContext createAppSubmitCtx(ApplicationId appId, Resource res) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        asContext.setApplicationId(appId);
        ResourceRequest resReg = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)res, (int)1);
        asContext.setAMContainerResourceRequests(Collections.singletonList(resReg));
        asContext.setAMContainerSpec((ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class));
        asContext.setQueue("default");
        return asContext;
    }
}

