/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionInfo;

@XmlRootElement(name="nodeLabelInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeLabelInfo {
    private String name;
    private boolean exclusivity;
    private PartitionInfo partitionInfo;

    public NodeLabelInfo() {
    }

    public NodeLabelInfo(String name) {
        this.name = name;
        this.exclusivity = true;
    }

    public NodeLabelInfo(String name, boolean exclusivity) {
        this.name = name;
        this.exclusivity = exclusivity;
    }

    public NodeLabelInfo(NodeLabel label) {
        this.name = label.getName();
        this.exclusivity = label.isExclusive();
    }

    public NodeLabelInfo(NodeLabel label, PartitionInfo partitionInfo) {
        this(label);
        this.partitionInfo = partitionInfo;
    }

    public String getName() {
        return this.name;
    }

    public boolean getExclusivity() {
        return this.exclusivity;
    }

    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeLabelInfo other = (NodeLabelInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getExclusivity() == other.getExclusivity();
    }

    public int hashCode() {
        return (this.getName().hashCode() << 16) + (this.getExclusivity() ? 1 : 0);
    }
}

