/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AutoQueueTemplatePropertiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerHealthInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacityVectorInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.helper.CapacitySchedulerInfoHelper;

@XmlRootElement(name="capacityScheduler")
@XmlType(name="capacityScheduler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerInfo
extends SchedulerInfo {
    protected float capacity;
    protected float usedCapacity;
    protected float maxCapacity;
    protected float weight;
    protected float normalizedWeight;
    protected QueueCapacityVectorInfo queueCapacityVectorInfo;
    protected String queueName;
    private String queuePath;
    protected int maxParallelApps;
    private boolean isAbsoluteResource;
    protected CapacitySchedulerQueueInfoList queues;
    protected QueueCapacitiesInfo capacities;
    protected CapacitySchedulerHealthInfo health;
    protected ResourceInfo maximumAllocation;
    protected QueueAclsInfo queueAcls;
    protected int queuePriority;
    protected String orderingPolicyInfo;
    protected String mode;
    protected String queueType;
    protected String creationMethod;
    protected String autoCreationEligibility;
    protected String defaultNodeLabelExpression;
    protected AutoQueueTemplatePropertiesInfo autoQueueTemplateProperties;
    protected AutoQueueTemplatePropertiesInfo autoQueueParentTemplateProperties;
    protected AutoQueueTemplatePropertiesInfo autoQueueLeafTemplateProperties;
    @XmlTransient
    static final float EPSILON = 1.0E-8f;

    public CapacitySchedulerInfo() {
    }

    public CapacitySchedulerInfo(CSQueue parent, CapacityScheduler cs) {
        this.queueName = parent.getQueueName();
        this.queuePath = parent.getQueuePath();
        this.usedCapacity = parent.getUsedCapacity() * 100.0f;
        this.capacity = parent.getCapacity() * 100.0f;
        this.queueCapacityVectorInfo = new QueueCapacityVectorInfo(parent.getConfiguredCapacityVector(""));
        float max = parent.getMaximumCapacity();
        if (max < 1.0E-8f || max > 1.0f) {
            max = 1.0f;
        }
        this.maxCapacity = max * 100.0f;
        this.weight = parent.getQueueCapacities().getWeight();
        this.normalizedWeight = parent.getQueueCapacities().getNormalizedWeight();
        this.maxParallelApps = parent.getMaxParallelApps();
        this.capacities = new QueueCapacitiesInfo(parent, false);
        this.queues = this.getQueues(cs, parent);
        this.health = new CapacitySchedulerHealthInfo(cs);
        this.maximumAllocation = new ResourceInfo(parent.getMaximumAllocation());
        this.isAbsoluteResource = parent.getCapacityConfigType() == AbstractCSQueue.CapacityConfigType.ABSOLUTE_RESOURCE;
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        this.queueAcls = new QueueAclsInfo();
        this.queueAcls.addAll(CapacitySchedulerQueueInfo.getSortedQueueAclInfoList(parent, new QueuePath(this.queuePath), conf));
        this.queuePriority = parent.getPriority().getPriority();
        if (parent instanceof AbstractParentQueue) {
            AbstractParentQueue queue = (AbstractParentQueue)parent;
            this.orderingPolicyInfo = queue.getQueueOrderingPolicy().getConfigName();
            this.autoQueueTemplateProperties = CapacitySchedulerInfoHelper.getAutoCreatedTemplate(queue.getAutoCreatedQueueTemplate().getTemplateProperties());
            this.autoQueueParentTemplateProperties = CapacitySchedulerInfoHelper.getAutoCreatedTemplate(queue.getAutoCreatedQueueTemplate().getParentOnlyProperties());
            this.autoQueueLeafTemplateProperties = CapacitySchedulerInfoHelper.getAutoCreatedTemplate(queue.getAutoCreatedQueueTemplate().getLeafOnlyProperties());
        }
        this.mode = CapacitySchedulerInfoHelper.getMode(parent);
        this.queueType = CapacitySchedulerInfoHelper.getQueueType(parent);
        this.creationMethod = CapacitySchedulerInfoHelper.getCreationMethod(parent);
        this.autoCreationEligibility = CapacitySchedulerInfoHelper.getAutoCreationEligibility(parent);
        this.defaultNodeLabelExpression = parent.getDefaultNodeLabelExpression();
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public QueueCapacitiesInfo getCapacities() {
        return this.capacities;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public ResourceInfo getMaximumAllocation() {
        return this.maximumAllocation;
    }

    public QueueAclsInfo getQueueAcls() {
        return this.queueAcls;
    }

    public int getPriority() {
        return this.queuePriority;
    }

    public String getOrderingPolicyInfo() {
        return this.orderingPolicyInfo;
    }

    public CapacitySchedulerQueueInfoList getQueues() {
        return this.queues;
    }

    protected CapacitySchedulerQueueInfoList getQueues(CapacityScheduler cs, CSQueue parent) {
        CapacitySchedulerQueueInfoList queuesInfo = new CapacitySchedulerQueueInfoList();
        ArrayList childQueues = new ArrayList();
        ArrayList<CSQueue> childLeafQueues = new ArrayList<CSQueue>();
        ArrayList<CSQueue> childNonLeafQueues = new ArrayList<CSQueue>();
        for (CSQueue queue : parent.getChildQueues()) {
            if (queue instanceof AbstractLeafQueue) {
                childLeafQueues.add(queue);
                continue;
            }
            childNonLeafQueues.add(queue);
        }
        childQueues.addAll(childLeafQueues);
        childQueues.addAll(childNonLeafQueues);
        for (CSQueue queue : childQueues) {
            CapacitySchedulerQueueInfo info;
            if (queue instanceof AbstractLeafQueue) {
                info = new CapacitySchedulerLeafQueueInfo(cs, (AbstractLeafQueue)queue);
            } else {
                info = new CapacitySchedulerQueueInfo(cs, queue);
                info.queues = this.getQueues(cs, queue);
            }
            queuesInfo.addToQueueInfoList(info);
        }
        return queuesInfo;
    }

    public String getMode() {
        return this.mode;
    }

    public String getQueueType() {
        return this.queueType;
    }
}

