/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.BulkActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerHealthInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ContainerLaunchContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FifoSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LocalResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NewApplication;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInformationsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.StatisticsItemInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.UserMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.UsersInfo;
import org.apache.hadoop.yarn.webapp.RemoteExceptionData;

@Singleton
@Provider
public class JAXBContextResolver
implements ContextResolver<JAXBContext> {
    private static final Log LOG = LogFactory.getLog((String)JAXBContextResolver.class.getName());
    private final Map<Class, JAXBContext> typesContextMap;

    public JAXBContextResolver() throws Exception {
        this(new Configuration());
    }

    @Inject
    public JAXBContextResolver(Configuration conf) throws Exception {
        Class[] cTypes = new Class[]{AppInfo.class, AppAttemptInfo.class, AppAttemptsInfo.class, ClusterInfo.class, CapacitySchedulerQueueInfo.class, FifoSchedulerInfo.class, SchedulerTypeInfo.class, NodeInfo.class, UserMetricsInfo.class, CapacitySchedulerInfo.class, ClusterMetricsInfo.class, SchedulerInfo.class, AppsInfo.class, NodesInfo.class, RemoteExceptionData.class, CapacitySchedulerQueueInfoList.class, ResourceInfo.class, UsersInfo.class, UserInfo.class, ApplicationStatisticsInfo.class, StatisticsItemInfo.class, CapacitySchedulerHealthInfo.class, FairSchedulerQueueInfoList.class, AppTimeoutsInfo.class, AppTimeoutInfo.class, ResourceInformationsInfo.class, ActivitiesInfo.class, AppActivitiesInfo.class, QueueAclsInfo.class, QueueAclInfo.class, BulkActivitiesInfo.class};
        Class[] rootUnwrappedTypes = new Class[]{NewApplication.class, ApplicationSubmissionContextInfo.class, ContainerLaunchContextInfo.class, LocalResourceInfo.class, DelegationToken.class, AppQueue.class, AppPriority.class};
        ArrayList finalcTypesList = new ArrayList();
        ArrayList finalRootUnwrappedTypesList = new ArrayList();
        Collections.addAll(finalcTypesList, cTypes);
        Collections.addAll(finalRootUnwrappedTypesList, rootUnwrappedTypes);
        Object[] daoClasses = null;
        Object[] unwrappedDaoClasses = null;
        boolean loadCustom = true;
        try {
            daoClasses = conf.getClasses("yarn.http.rmwebapp.custom.dao.classes", new Class[0]);
            unwrappedDaoClasses = conf.getClasses("yarn.http.rmwebapp.custom.unwrapped.dao.classes", new Class[0]);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to load custom dao class: " + e));
            loadCustom = false;
        }
        if (loadCustom) {
            if (daoClasses != null) {
                Collections.addAll(finalcTypesList, daoClasses);
                LOG.debug((Object)("Added custom dao classes: " + Arrays.toString(daoClasses)));
            }
            if (unwrappedDaoClasses != null) {
                Collections.addAll(finalRootUnwrappedTypesList, unwrappedDaoClasses);
                LOG.debug((Object)("Added custom Unwrapped dao classes: " + Arrays.toString(unwrappedDaoClasses)));
            }
        }
        Class[] finalcTypes = finalcTypesList.toArray(new Class[finalcTypesList.size()]);
        Class[] finalRootUnwrappedTypes = finalRootUnwrappedTypesList.toArray(new Class[finalRootUnwrappedTypesList.size()]);
        this.typesContextMap = new HashMap<Class, JAXBContext>();
        JSONJAXBContext context = new JSONJAXBContext(JSONConfiguration.natural().rootUnwrapping(false).build(), finalcTypes);
        JSONJAXBContext unWrappedRootContext = new JSONJAXBContext(JSONConfiguration.natural().rootUnwrapping(true).build(), finalRootUnwrappedTypes);
        for (Class type : finalcTypes) {
            this.typesContextMap.put(type, (JAXBContext)context);
        }
        for (Class type : finalRootUnwrappedTypes) {
            this.typesContextMap.put(type, (JAXBContext)unWrappedRootContext);
        }
    }

    public JAXBContext getContext(Class<?> objectType) {
        return this.typesContextMap.get(objectType);
    }
}

