/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeLookupPolicy;

public class ResourceUsageMultiNodeLookupPolicy<N extends SchedulerNode>
implements MultiNodeLookupPolicy<N> {
    protected Map<String, Set<N>> nodesPerPartition = new ConcurrentHashMap<String, Set<N>>();
    protected Comparator<N> comparator = new Comparator<N>(){

        @Override
        public int compare(N o1, N o2) {
            int allocatedDiff = ((SchedulerNode)o1).getAllocatedResource().compareTo(((SchedulerNode)o2).getAllocatedResource());
            if (allocatedDiff == 0) {
                return ((SchedulerNode)o1).getNodeID().compareTo(((SchedulerNode)o2).getNodeID());
            }
            return allocatedDiff;
        }
    };

    @Override
    public Iterator<N> getPreferredNodeIterator(Collection<N> nodes, String partition, SchedulerApplicationAttempt appAttempt) {
        return this.getNodesPerPartition(partition).iterator();
    }

    @Override
    public void addAndRefreshNodesSet(Collection<N> nodes, String partition) {
        ConcurrentSkipListSet<N> nodeList = new ConcurrentSkipListSet<N>(this.comparator);
        nodeList.addAll(nodes);
        this.nodesPerPartition.put(partition, Collections.unmodifiableSet(nodeList));
    }

    @Override
    public Set<N> getNodesPerPartition(String partition) {
        return this.nodesPerPartition.getOrDefault(partition, Collections.emptySet());
    }
}

