/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ReservationQueueConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.AllocationFileParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.QueueProperties;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AllocationConfiguration
extends ReservationSchedulerConfiguration {
    private static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    private static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private final Map<String, Resource> minQueueResources;
    @VisibleForTesting
    final Map<String, ConfigurableResource> maxQueueResources;
    private final Map<String, ConfigurableResource> maxChildQueueResources;
    private final Map<String, Float> queueWeights;
    @VisibleForTesting
    final Map<String, Integer> queueMaxApps;
    @VisibleForTesting
    final Map<String, Integer> userMaxApps;
    private final int userMaxAppsDefault;
    private final int queueMaxAppsDefault;
    private final ConfigurableResource queueMaxResourcesDefault;
    final Map<String, Float> queueMaxAMShares;
    private final float queueMaxAMShareDefault;
    private final Map<String, Map<AccessType, AccessControlList>> queueAcls;
    private final Map<String, Map<ReservationACL, AccessControlList>> resAcls;
    private final Map<String, Long> minSharePreemptionTimeouts;
    private final Map<String, Long> fairSharePreemptionTimeouts;
    private final Map<String, Float> fairSharePreemptionThresholds;
    private final Set<String> reservableQueues;
    private final Map<String, SchedulingPolicy> schedulingPolicies;
    private final SchedulingPolicy defaultSchedulingPolicy;
    private final Map<String, Resource> queueMaxContainerAllocationMap;
    @VisibleForTesting
    Map<FSQueueType, Set<String>> configuredQueues;
    private ReservationQueueConfiguration globalReservationQueueConfig;
    private final Set<String> nonPreemptableQueues;

    public AllocationConfiguration(QueueProperties queueProperties, AllocationFileParser allocationFileParser, ReservationQueueConfiguration globalReservationQueueConfig) throws AllocationConfigurationException {
        this.minQueueResources = queueProperties.getMinQueueResources();
        this.maxQueueResources = queueProperties.getMaxQueueResources();
        this.maxChildQueueResources = queueProperties.getMaxChildQueueResources();
        this.queueMaxApps = queueProperties.getQueueMaxApps();
        this.userMaxApps = allocationFileParser.getUserMaxApps();
        this.queueMaxAMShares = queueProperties.getQueueMaxAMShares();
        this.queueWeights = queueProperties.getQueueWeights();
        this.userMaxAppsDefault = allocationFileParser.getUserMaxAppsDefault();
        this.queueMaxResourcesDefault = allocationFileParser.getQueueMaxResourcesDefault();
        this.queueMaxAppsDefault = allocationFileParser.getQueueMaxAppsDefault();
        this.queueMaxAMShareDefault = allocationFileParser.getQueueMaxAMShareDefault();
        this.defaultSchedulingPolicy = allocationFileParser.getDefaultSchedulingPolicy();
        this.schedulingPolicies = queueProperties.getQueuePolicies();
        this.minSharePreemptionTimeouts = queueProperties.getMinSharePreemptionTimeouts();
        this.fairSharePreemptionTimeouts = queueProperties.getFairSharePreemptionTimeouts();
        this.fairSharePreemptionThresholds = queueProperties.getFairSharePreemptionThresholds();
        this.queueAcls = queueProperties.getQueueAcls();
        this.resAcls = queueProperties.getReservationAcls();
        this.reservableQueues = queueProperties.getReservableQueues();
        this.globalReservationQueueConfig = globalReservationQueueConfig;
        this.configuredQueues = queueProperties.getConfiguredQueues();
        this.nonPreemptableQueues = queueProperties.getNonPreemptableQueues();
        this.queueMaxContainerAllocationMap = queueProperties.getMaxContainerAllocation();
    }

    public AllocationConfiguration(FairScheduler scheduler) {
        this.minQueueResources = new HashMap<String, Resource>();
        this.maxChildQueueResources = new HashMap<String, ConfigurableResource>();
        this.maxQueueResources = new HashMap<String, ConfigurableResource>();
        this.queueWeights = new HashMap<String, Float>();
        this.queueMaxApps = new HashMap<String, Integer>();
        this.userMaxApps = new HashMap<String, Integer>();
        this.queueMaxAMShares = new HashMap<String, Float>();
        this.userMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxResourcesDefault = new ConfigurableResource(Resources.unbounded());
        this.queueMaxAMShareDefault = 0.5f;
        this.queueAcls = new HashMap<String, Map<AccessType, AccessControlList>>();
        this.resAcls = new HashMap<String, Map<ReservationACL, AccessControlList>>();
        this.minSharePreemptionTimeouts = new HashMap<String, Long>();
        this.fairSharePreemptionTimeouts = new HashMap<String, Long>();
        this.fairSharePreemptionThresholds = new HashMap<String, Float>();
        this.schedulingPolicies = new HashMap<String, SchedulingPolicy>();
        this.defaultSchedulingPolicy = SchedulingPolicy.DEFAULT_POLICY;
        this.reservableQueues = new HashSet<String>();
        this.configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType queueType : FSQueueType.values()) {
            this.configuredQueues.put(queueType, new HashSet());
        }
        QueuePlacementPolicy.fromConfiguration(scheduler);
        this.nonPreemptableQueues = new HashSet<String>();
        this.queueMaxContainerAllocationMap = new HashMap<String, Resource>();
    }

    public Map<String, Map<AccessType, AccessControlList>> getQueueAcls() {
        return Collections.unmodifiableMap(this.queueAcls);
    }

    @Override
    public Map<ReservationACL, AccessControlList> getReservationAcls(QueuePath queue) {
        return this.resAcls.get(queue.getFullPath());
    }

    public long getMinSharePreemptionTimeout(String queueName) {
        Long minSharePreemptionTimeout = this.minSharePreemptionTimeouts.get(queueName);
        return minSharePreemptionTimeout == null ? -1L : minSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout(String queueName) {
        Long fairSharePreemptionTimeout = this.fairSharePreemptionTimeouts.get(queueName);
        return fairSharePreemptionTimeout == null ? -1L : fairSharePreemptionTimeout;
    }

    public float getFairSharePreemptionThreshold(String queueName) {
        Float fairSharePreemptionThreshold = this.fairSharePreemptionThresholds.get(queueName);
        return fairSharePreemptionThreshold == null ? -1.0f : fairSharePreemptionThreshold.floatValue();
    }

    public boolean isPreemptable(String queueName) {
        return !this.nonPreemptableQueues.contains(queueName);
    }

    private float getQueueWeight(String queue) {
        Float weight = this.queueWeights.get(queue);
        return weight == null ? 1.0f : weight.floatValue();
    }

    public int getUserMaxApps(String user) {
        Integer maxApps = this.userMaxApps.get(user);
        return maxApps == null ? this.userMaxAppsDefault : maxApps;
    }

    public Map<String, Integer> getUserMaxApps() {
        return this.userMaxApps;
    }

    @VisibleForTesting
    int getQueueMaxApps(String queue) {
        Integer maxApps = this.queueMaxApps.get(queue);
        return maxApps == null ? this.queueMaxAppsDefault : maxApps;
    }

    public int getQueueMaxAppsDefault() {
        return this.queueMaxAppsDefault;
    }

    public int getUserMaxAppsDefault() {
        return this.userMaxAppsDefault;
    }

    @VisibleForTesting
    float getQueueMaxAMShare(String queue) {
        Float maxAMShare = this.queueMaxAMShares.get(queue);
        return maxAMShare == null ? this.queueMaxAMShareDefault : maxAMShare.floatValue();
    }

    public float getQueueMaxAMShareDefault() {
        return this.queueMaxAMShareDefault;
    }

    @VisibleForTesting
    Resource getMinResources(String queue) {
        Resource minQueueResource = this.minQueueResources.get(queue);
        return minQueueResource == null ? Resources.none() : minQueueResource;
    }

    @VisibleForTesting
    ConfigurableResource getMaxResources(String queue) {
        ConfigurableResource maxQueueResource = this.maxQueueResources.get(queue);
        if (maxQueueResource == null) {
            maxQueueResource = this.queueMaxResourcesDefault;
        }
        return maxQueueResource;
    }

    @VisibleForTesting
    Resource getQueueMaxContainerAllocation(String queue) {
        Resource resource = this.queueMaxContainerAllocationMap.get(queue);
        return resource == null ? Resources.unbounded() : resource;
    }

    @VisibleForTesting
    ConfigurableResource getMaxChildResources(String queue) {
        return this.maxChildQueueResources.get(queue);
    }

    @VisibleForTesting
    SchedulingPolicy getSchedulingPolicy(String queueName) {
        SchedulingPolicy policy = this.schedulingPolicies.get(queueName);
        return policy == null ? this.defaultSchedulingPolicy : policy;
    }

    public SchedulingPolicy getDefaultSchedulingPolicy() {
        return this.defaultSchedulingPolicy;
    }

    public Map<FSQueueType, Set<String>> getConfiguredQueues() {
        return this.configuredQueues;
    }

    @Override
    public boolean isReservable(QueuePath queue) {
        return this.reservableQueues.contains(queue.getFullPath());
    }

    @Override
    public long getReservationWindow(QueuePath queue) {
        return this.globalReservationQueueConfig.getReservationWindowMsec();
    }

    @Override
    public float getAverageCapacity(QueuePath queue) {
        return this.globalReservationQueueConfig.getAvgOverTimeMultiplier() * 100.0f;
    }

    @Override
    public float getInstantaneousMaxCapacity(QueuePath queue) {
        return this.globalReservationQueueConfig.getMaxOverTimeMultiplier() * 100.0f;
    }

    @Override
    public String getReservationAdmissionPolicy(QueuePath queue) {
        return this.globalReservationQueueConfig.getReservationAdmissionPolicy();
    }

    @Override
    public String getReservationAgent(QueuePath queue) {
        return this.globalReservationQueueConfig.getReservationAgent();
    }

    @Override
    public boolean getShowReservationAsQueues(QueuePath queue) {
        return this.globalReservationQueueConfig.shouldShowReservationAsQueues();
    }

    @Override
    public String getReplanner(QueuePath queue) {
        return this.globalReservationQueueConfig.getPlanner();
    }

    @Override
    public boolean getMoveOnExpiry(QueuePath queue) {
        return this.globalReservationQueueConfig.shouldMoveOnExpiry();
    }

    @Override
    public long getEnforcementWindow(QueuePath queue) {
        return this.globalReservationQueueConfig.getEnforcementWindowMsec();
    }

    @VisibleForTesting
    public void setReservationWindow(long window) {
        this.globalReservationQueueConfig.setReservationWindow(window);
    }

    @VisibleForTesting
    public void setAverageCapacity(int avgCapacity) {
        this.globalReservationQueueConfig.setAverageCapacity(avgCapacity);
    }

    public void initFSQueue(FSQueue queue) {
        String name = queue.getName();
        queue.setWeights(this.getQueueWeight(name));
        queue.setMinShare(this.getMinResources(name));
        queue.setMaxShare(this.getMaxResources(name));
        queue.setMaxRunningApps(this.getQueueMaxApps(name));
        queue.setMaxAMShare(this.getQueueMaxAMShare(name));
        queue.setMaxChildQueueResource(this.getMaxChildResources(name));
        queue.setMaxContainerAllocation(this.getQueueMaxContainerAllocation(name));
        queue.getMetrics().setMinShare(queue.getMinShare());
        queue.getMetrics().setMaxShare(queue.getMaxShare());
        queue.getMetrics().setMaxApps(queue.getMaxRunningApps());
        queue.getMetrics().setSchedulingPolicy(this.getSchedulingPolicy(name).getName());
    }
}

