/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongBinaryOperator;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalAllocationTagsManager
extends AllocationTagsManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAllocationTagsManager.class);
    private final AllocationTagsManager tagsManager;
    private Map<ApplicationId, Map<NodeId, Map<String, AtomicInteger>>> appTempMappings = new HashMap<ApplicationId, Map<NodeId, Map<String, AtomicInteger>>>();

    LocalAllocationTagsManager(AllocationTagsManager allocationTagsManager) {
        super(null);
        this.tagsManager = allocationTagsManager;
    }

    void addTempTags(NodeId nodeId, ApplicationId applicationId, Set<String> allocationTags) {
        Map appTempMapping = this.appTempMappings.computeIfAbsent(applicationId, k -> new HashMap());
        Map containerTempMapping = appTempMapping.computeIfAbsent(nodeId, k -> new HashMap());
        for (String tag : allocationTags) {
            containerTempMapping.computeIfAbsent(tag, k -> new AtomicInteger(0)).incrementAndGet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added TEMP container with tags=[" + StringUtils.join(allocationTags, (String)",") + "]");
        }
        this.tagsManager.addTags(nodeId, applicationId, allocationTags);
    }

    void removeTempTags(NodeId nodeId, ApplicationId applicationId, Set<String> allocationTags) {
        Map<String, AtomicInteger> containerTempMap;
        Map<NodeId, Map<String, AtomicInteger>> appTempMapping = this.appTempMappings.get(applicationId);
        if (appTempMapping != null && (containerTempMap = appTempMapping.get(nodeId)) != null) {
            for (String tag : allocationTags) {
                AtomicInteger count = containerTempMap.get(tag);
                if (count == null || count.decrementAndGet() > 0) continue;
                containerTempMap.remove(tag);
            }
        }
        if (allocationTags != null) {
            this.removeTags(nodeId, applicationId, allocationTags);
        }
    }

    public void cleanTempContainers(ApplicationId applicationId) {
        if (!this.appTempMappings.get(applicationId).isEmpty()) {
            this.appTempMappings.get(applicationId).entrySet().stream().forEach(nodeE -> ((Map)nodeE.getValue()).entrySet().stream().forEach(tagE -> {
                for (int i = 0; i < ((AtomicInteger)tagE.getValue()).get(); ++i) {
                    this.removeTags((NodeId)nodeE.getKey(), applicationId, Collections.singleton(tagE.getKey()));
                }
            }));
            this.appTempMappings.remove(applicationId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed TEMP containers of app=" + applicationId);
            }
        }
    }

    @Override
    public void addContainer(NodeId nodeId, ContainerId containerId, Set<String> allocationTags) {
        this.tagsManager.addContainer(nodeId, containerId, allocationTags);
    }

    @Override
    public void removeContainer(NodeId nodeId, ContainerId containerId, Set<String> allocationTags) {
        this.tagsManager.removeContainer(nodeId, containerId, allocationTags);
    }

    @Override
    public void removeTags(NodeId nodeId, ApplicationId applicationId, Set<String> allocationTags) {
        this.tagsManager.removeTags(nodeId, applicationId, allocationTags);
    }

    @Override
    public long getNodeCardinality(NodeId nodeId, ApplicationId applicationId, String tag) throws InvalidAllocationTagsQueryException {
        return this.tagsManager.getNodeCardinality(nodeId, applicationId, tag);
    }

    @Override
    public long getNodeCardinalityByOp(NodeId nodeId, AllocationTags tags, LongBinaryOperator op) throws InvalidAllocationTagsQueryException {
        return this.tagsManager.getNodeCardinalityByOp(nodeId, tags, op);
    }

    @Override
    public long getRackCardinality(String rack, ApplicationId applicationId, String tag) throws InvalidAllocationTagsQueryException {
        return this.tagsManager.getRackCardinality(rack, applicationId, tag);
    }

    @Override
    public long getRackCardinalityByOp(String rack, AllocationTags tags, LongBinaryOperator op) throws InvalidAllocationTagsQueryException {
        return this.tagsManager.getRackCardinalityByOp(rack, tags, op);
    }

    @Override
    public boolean allocationTagExistsOnNode(NodeId nodeId, ApplicationId applicationId, String tag) throws InvalidAllocationTagsQueryException {
        return this.tagsManager.allocationTagExistsOnNode(nodeId, applicationId, tag);
    }
}

