/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLConfigurationParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueTemplate;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ConfigurationProperties;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.WorkflowPriorityMappingsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.QueueCapacityConfigParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.MappingRuleCreator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeLookupPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodePolicySpec;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicyForPendingApps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CapacitySchedulerConfiguration
extends ReservationSchedulerConfiguration {
    private static final Log LOG = LogFactory.getLog(CapacitySchedulerConfiguration.class);
    private static final String CS_CONFIGURATION_FILE = "capacity-scheduler.xml";
    @InterfaceAudience.Private
    public static final String PREFIX = "yarn.scheduler.capacity.";
    @InterfaceAudience.Private
    public static final String DOT = ".";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATIONS_SUFFIX = "maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_SYSTEM_APPLICATIONS = "yarn.scheduler.capacity.maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_AM_RESOURCE_SUFFIX = "maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT = "yarn.scheduler.capacity.maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String QUEUES = "queues";
    @InterfaceAudience.Private
    public static final String CAPACITY = "capacity";
    @InterfaceAudience.Private
    public static final String MAXIMUM_CAPACITY = "maximum-capacity";
    @InterfaceAudience.Private
    public static final String AUTOSCALER_MINIMUM_CAPACITY = "autoscaler.minimum-capacity";
    @InterfaceAudience.Private
    public static final String AUTOSCALER_MAXIMUM_CAPACITY = "autoscaler.maximum-capacity";
    @InterfaceAudience.Private
    public static final String USER_LIMIT = "minimum-user-limit-percent";
    @InterfaceAudience.Private
    public static final String USER_LIMIT_FACTOR = "user-limit-factor";
    @InterfaceAudience.Private
    public static final String USER_WEIGHT = "weight";
    @InterfaceAudience.Private
    public static final String USER_SETTINGS = "user-settings";
    @InterfaceAudience.Private
    public static final String USER_WEIGHT_REGEX = "\\S+\\.weight";
    @InterfaceAudience.Private
    public static final Pattern USER_WEIGHT_PATTERN = Pattern.compile("\\S+\\.weight");
    @InterfaceAudience.Private
    public static final float DEFAULT_USER_WEIGHT = 1.0f;
    @InterfaceAudience.Private
    public static final String STATE = "state";
    @InterfaceAudience.Private
    public static final String ACCESSIBLE_NODE_LABELS = "accessible-node-labels";
    @InterfaceAudience.Private
    public static final String DEFAULT_NODE_LABEL_EXPRESSION = "default-node-label-expression";
    public static final String RESERVE_CONT_LOOK_ALL_NODES = "yarn.scheduler.capacity.reservations-continue-look-all-nodes";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_RESERVE_CONT_LOOK_ALL_NODES = true;
    public static final String SKIP_ALLOCATE_ON_NODES_WITH_RESERVED_CONTAINERS = "yarn.scheduler.capacity.skip-allocate-on-nodes-with-reserved-containers";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_SKIP_ALLOCATE_ON_NODES_WITH_RESERVED_CONTAINERS = false;
    @InterfaceAudience.Private
    public static final String MAXIMUM_ALLOCATION = "maximum-allocation";
    @InterfaceAudience.Private
    public static final String MAXIMUM_ALLOCATION_MB = "maximum-allocation-mb";
    @InterfaceAudience.Private
    public static final String MAXIMUM_ALLOCATION_VCORES = "maximum-allocation-vcores";
    public static final String ORDERING_POLICY = "ordering-policy";
    public static final String FIFO_APP_ORDERING_POLICY = "fifo";
    public static final String FAIR_APP_ORDERING_POLICY = "fair";
    public static final String FIFO_FOR_PENDING_APPS = "fifo-for-pending-apps";
    public static final String DEFAULT_APP_ORDERING_POLICY = "fifo";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAXIMUM_SYSTEM_APPLICATIIONS = 10000;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_APPLICATIONMASTERS_RESOURCE_PERCENT = 0.1f;
    @InterfaceAudience.Private
    public static final float UNDEFINED = -1.0f;
    @InterfaceAudience.Private
    public static final float MINIMUM_CAPACITY_VALUE = 0.0f;
    @InterfaceAudience.Private
    public static final float MAXIMUM_CAPACITY_VALUE = 100.0f;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_CAPACITY_VALUE = -1.0f;
    @InterfaceAudience.Private
    public static final int DEFAULT_USER_LIMIT = 100;
    @InterfaceAudience.Private
    public static final float DEFAULT_USER_LIMIT_FACTOR = 1.0f;
    @InterfaceAudience.Private
    public static final String ALL_ACL = "*";
    @InterfaceAudience.Private
    public static final String NONE_ACL = " ";
    @InterfaceAudience.Private
    public static final String ENABLE_USER_METRICS = "yarn.scheduler.capacity.user-metrics.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_USER_METRICS = false;
    @InterfaceAudience.Private
    public static final String RESOURCE_CALCULATOR_CLASS = "yarn.scheduler.capacity.resource-calculator";
    @InterfaceAudience.Private
    public static final Class<? extends ResourceCalculator> DEFAULT_RESOURCE_CALCULATOR_CLASS = DefaultResourceCalculator.class;
    @InterfaceAudience.Private
    public static final String ROOT = "root";
    @InterfaceAudience.Private
    public static final QueuePath ROOT_PATH = new QueuePath("root");
    @InterfaceAudience.Private
    public static final String NODE_LOCALITY_DELAY = "yarn.scheduler.capacity.node-locality-delay";
    @InterfaceAudience.Private
    public static final int DEFAULT_NODE_LOCALITY_DELAY = 40;
    @InterfaceAudience.Private
    public static final String RACK_LOCALITY_ADDITIONAL_DELAY = "yarn.scheduler.capacity.rack-locality-additional-delay";
    @InterfaceAudience.Private
    public static final int DEFAULT_RACK_LOCALITY_ADDITIONAL_DELAY = -1;
    @InterfaceAudience.Private
    public static final String RACK_LOCALITY_FULL_RESET = "yarn.scheduler.capacity.rack-locality-full-reset";
    @InterfaceAudience.Private
    public static final int DEFAULT_OFFSWITCH_PER_HEARTBEAT_LIMIT = 1;
    @InterfaceAudience.Private
    public static final String OFFSWITCH_PER_HEARTBEAT_LIMIT = "yarn.scheduler.capacity.per-node-heartbeat.maximum-offswitch-assignments";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_RACK_LOCALITY_FULL_RESET = true;
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_PREFIX = "yarn.scheduler.capacity.schedule-asynchronously";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_ENABLE = "yarn.scheduler.capacity.schedule-asynchronously.enable";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_MAXIMUM_THREAD = "yarn.scheduler.capacity.schedule-asynchronously.maximum-threads";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_MAXIMUM_PENDING_BACKLOGS = "yarn.scheduler.capacity.schedule-asynchronously.maximum-pending-backlogs";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_INTERVAL = "yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms";
    @InterfaceAudience.Private
    public static final long DEFAULT_SCHEDULE_ASYNCHRONOUSLY_INTERVAL = 5L;
    @InterfaceAudience.Private
    public static final String APP_FAIL_FAST = "yarn.scheduler.capacity.application.fail-fast";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_APP_FAIL_FAST = false;
    @InterfaceAudience.Private
    public static final Integer DEFAULT_SCHEDULE_ASYNCHRONOUSLY_MAXIMUM_PENDING_BACKLOGS = 100;
    @InterfaceAudience.Private
    public static final boolean DEFAULT_SCHEDULE_ASYNCHRONOUSLY_ENABLE = false;
    @InterfaceAudience.Private
    public static final String QUEUE_MAPPING = "yarn.scheduler.capacity.queue-mappings";
    @InterfaceAudience.Private
    public static final String QUEUE_MAPPING_NAME = "yarn.scheduler.queue-placement-rules.app-name";
    @InterfaceAudience.Private
    public static final String ENABLE_QUEUE_MAPPING_OVERRIDE = "yarn.scheduler.capacity.queue-mappings-override.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_QUEUE_MAPPING_OVERRIDE = false;
    @InterfaceAudience.Private
    public static final String WORKFLOW_PRIORITY_MAPPINGS = "yarn.scheduler.capacity.workflow-priority-mappings";
    @InterfaceAudience.Private
    public static final String ENABLE_WORKFLOW_PRIORITY_MAPPINGS_OVERRIDE = "yarn.scheduler.capacity.workflow-priority-mappings-override.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_WORKFLOW_PRIORITY_MAPPINGS_OVERRIDE = false;
    @InterfaceAudience.Private
    public static final String QUEUE_PREEMPTION_DISABLED = "disable_preemption";
    @InterfaceAudience.Private
    public static final String DEFAULT_APPLICATION_PRIORITY = "default-application-priority";
    @InterfaceAudience.Private
    public static final Integer DEFAULT_CONFIGURATION_APPLICATION_PRIORITY = 0;
    @InterfaceAudience.Private
    public static final String AVERAGE_CAPACITY = "average-capacity";
    @InterfaceAudience.Private
    public static final String IS_RESERVABLE = "reservable";
    @InterfaceAudience.Private
    public static final String RESERVATION_WINDOW = "reservation-window";
    @InterfaceAudience.Private
    public static final String INSTANTANEOUS_MAX_CAPACITY = "instantaneous-max-capacity";
    @InterfaceAudience.Private
    public static final String RESERVATION_ADMISSION_POLICY = "reservation-policy";
    @InterfaceAudience.Private
    public static final String RESERVATION_AGENT_NAME = "reservation-agent";
    @InterfaceAudience.Private
    public static final String RESERVATION_SHOW_RESERVATION_AS_QUEUE = "show-reservations-as-queues";
    @InterfaceAudience.Private
    public static final String RESERVATION_PLANNER_NAME = "reservation-planner";
    @InterfaceAudience.Private
    public static final String RESERVATION_MOVE_ON_EXPIRY = "reservation-move-on-expiry";
    @InterfaceAudience.Private
    public static final String RESERVATION_ENFORCEMENT_WINDOW = "reservation-enforcement-window";
    @InterfaceAudience.Private
    public static final String LAZY_PREEMPTION_ENABLED = "yarn.scheduler.capacity.lazy-preemption-enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_LAZY_PREEMPTION_ENABLED = false;
    @InterfaceAudience.Private
    public static final String ASSIGN_MULTIPLE_ENABLED = "yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ASSIGN_MULTIPLE_ENABLED = true;
    @InterfaceAudience.Private
    public static final String MAX_ASSIGN_PER_HEARTBEAT = "yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAX_ASSIGN_PER_HEARTBEAT = 100;
    @InterfaceAudience.Private
    public static final String MINIMUM_RESOURCE = "min-resource";
    @InterfaceAudience.Private
    public static final String MAXIMUM_RESOURCE = "max-resource";
    public static final String DEFAULT_RESOURCE_TYPES = "memory,vcores";
    public static final String PATTERN_FOR_ABSOLUTE_RESOURCE = "^\\[[\\w\\.,\\-_=\\ /]+\\]$";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("^\\[[\\w\\.,\\-_=\\ /]+\\]$");
    private static final String WEIGHT_SUFFIX = "w";
    public static final String MAX_PARALLEL_APPLICATIONS = "max-parallel-apps";
    public static final int DEFAULT_MAX_PARALLEL_APPLICATIONS = Integer.MAX_VALUE;
    public static final String ALLOW_ZERO_CAPACITY_SUM = "allow-zero-capacity-sum";
    public static final boolean DEFAULT_ALLOW_ZERO_CAPACITY_SUM = false;
    public static final String MAPPING_RULE_FORMAT = "yarn.scheduler.capacity.mapping-rule-format";
    public static final String MAPPING_RULE_JSON = "yarn.scheduler.capacity.mapping-rule-json";
    public static final String MAPPING_RULE_JSON_FILE = "yarn.scheduler.capacity.mapping-rule-json-file";
    public static final String MAPPING_RULE_FORMAT_LEGACY = "legacy";
    public static final String MAPPING_RULE_FORMAT_JSON = "json";
    public static final String MAPPING_RULE_FORMAT_DEFAULT = "legacy";
    private static final QueueCapacityConfigParser queueCapacityConfigParser = new QueueCapacityConfigParser();
    private static final String LEGACY_QUEUE_MODE_ENABLED = "yarn.scheduler.capacity.legacy-queue-mode.enabled";
    public static final boolean DEFAULT_LEGACY_QUEUE_MODE = true;
    private ConfigurationProperties configurationProperties;
    AppPriorityACLConfigurationParser priorityACLConfig = new AppPriorityACLConfigurationParser();
    private static final String PREEMPTION_CONFIG_PREFIX = "yarn.resourcemanager.monitor.capacity.preemption.";
    private static final String INTRA_QUEUE_PREEMPTION_CONFIG_PREFIX = "intra-queue-preemption.";
    public static final String PREEMPTION_OBSERVE_ONLY = "yarn.resourcemanager.monitor.capacity.preemption.observe_only";
    public static final boolean DEFAULT_PREEMPTION_OBSERVE_ONLY = false;
    public static final String PREEMPTION_MONITORING_INTERVAL = "yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval";
    public static final long DEFAULT_PREEMPTION_MONITORING_INTERVAL = 3000L;
    public static final String PREEMPTION_WAIT_TIME_BEFORE_KILL = "yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill";
    public static final long DEFAULT_PREEMPTION_WAIT_TIME_BEFORE_KILL = 15000L;
    public static final String TOTAL_PREEMPTION_PER_ROUND = "yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round";
    public static final float DEFAULT_TOTAL_PREEMPTION_PER_ROUND = 0.1f;
    public static final String PREEMPTION_MAX_IGNORED_OVER_CAPACITY = "yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity";
    public static final double DEFAULT_PREEMPTION_MAX_IGNORED_OVER_CAPACITY = 0.1;
    public static final String PREEMPTION_NATURAL_TERMINATION_FACTOR = "yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor";
    public static final double DEFAULT_PREEMPTION_NATURAL_TERMINATION_FACTOR = 0.2;
    public static final String ADDITIONAL_RESOURCE_BALANCE_BASED_ON_RESERVED_CONTAINERS = "yarn.resourcemanager.monitor.capacity.preemption.additional_res_balance_based_on_reserved_containers";
    public static final boolean DEFAULT_ADDITIONAL_RESOURCE_BALANCE_BASED_ON_RESERVED_CONTAINERS = false;
    public static final String PREEMPTION_SELECT_CANDIDATES_FOR_RESERVED_CONTAINERS = "yarn.resourcemanager.monitor.capacity.preemption.select_based_on_reserved_containers";
    public static final boolean DEFAULT_PREEMPTION_SELECT_CANDIDATES_FOR_RESERVED_CONTAINERS = false;
    public static final String INTRAQUEUE_PREEMPTION_ENABLED = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled";
    public static final boolean DEFAULT_INTRAQUEUE_PREEMPTION_ENABLED = false;
    public static final String INTRAQUEUE_PREEMPTION_MINIMUM_THRESHOLD = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.minimum-threshold";
    public static final float DEFAULT_INTRAQUEUE_PREEMPTION_MINIMUM_THRESHOLD = 0.5f;
    public static final String INTRAQUEUE_PREEMPTION_MAX_ALLOWABLE_LIMIT = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit";
    public static final float DEFAULT_INTRAQUEUE_PREEMPTION_MAX_ALLOWABLE_LIMIT = 0.2f;
    public static final String INTRAQUEUE_PREEMPTION_ORDER_POLICY = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy";
    public static final String DEFAULT_INTRAQUEUE_PREEMPTION_ORDER_POLICY = "userlimit_first";
    public static final String INTRAQUEUE_PREEMPTION_MIN_FAIR_DEMAND_ENABLED = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.min-fair-demand-enabled";
    public static final boolean DEFAULT_INTRAQUEUE_PREEMPTION_MIN_FAIR_DEMAND_ENABLED = false;
    public static final String PREEMPTION_TO_BALANCE_QUEUES_BEYOND_GUARANTEED = "yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled";
    public static final boolean DEFAULT_PREEMPTION_TO_BALANCE_QUEUES_BEYOND_GUARANTEED = false;
    public static final String MAX_WAIT_BEFORE_KILL_FOR_QUEUE_BALANCE_PREEMPTION = "yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.max-wait-before-kill";
    public static final long DEFAULT_MAX_WAIT_BEFORE_KILL_FOR_QUEUE_BALANCE_PREEMPTION = 300000L;
    @InterfaceAudience.Private
    public static final String QUEUE_GLOBAL_MAX_APPLICATION = "yarn.scheduler.capacity.global-queue-max-application";
    public static final String QUEUE_UTILIZATION_ORDERING_POLICY = "utilization";
    public static final String QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY = "priority-utilization";
    public static final String DEFAULT_QUEUE_ORDERING_POLICY = "utilization";
    private static final String UNDER_UTILIZED_PREEMPTION_ENABLED = "underutilized-preemption.enabled";
    private static final String UNDER_UTILIZED_PREEMPTION_DELAY = "underutilized-preemption.reserved-container-delay-ms";
    private static final String UNDER_UTILIZED_PREEMPTION_MOVE_RESERVATION = "underutilized-preemption.allow-move-reservation";
    public static final String MAXIMUM_LIFETIME_SUFFIX = "maximum-application-lifetime";
    public static final String DEFAULT_LIFETIME_SUFFIX = "default-application-lifetime";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_AUTO_CREATE_CHILD_QUEUE_ENABLED = false;
    @InterfaceAudience.Private
    private static final String AUTO_CREATE_CHILD_QUEUE_PREFIX = "auto-create-child-queue.";
    @InterfaceAudience.Private
    public static final String AUTO_CREATE_CHILD_QUEUE_ENABLED = "auto-create-child-queue.enabled";
    @InterfaceAudience.Private
    protected static final String AUTO_QUEUE_CREATION_V2_PREFIX = "auto-queue-creation-v2.";
    @InterfaceAudience.Private
    public static final String AUTO_QUEUE_CREATION_V2_ENABLED = "auto-queue-creation-v2.enabled";
    @InterfaceAudience.Private
    public static final String AUTO_QUEUE_CREATION_V2_MAX_QUEUES = "auto-queue-creation-v2.max-queues";
    @InterfaceAudience.Private
    public static final int DEFAULT_AUTO_QUEUE_CREATION_V2_MAX_QUEUES = 1000;
    @InterfaceAudience.Private
    public static final String MAXIMUM_QUEUE_DEPTH = "auto-queue-creation-v2.maximum-queue-depth";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAXIMUM_QUEUE_DEPTH = 2;
    @InterfaceAudience.Private
    public static final boolean DEFAULT_AUTO_QUEUE_CREATION_ENABLED = false;
    @InterfaceAudience.Private
    public static final String AUTO_CREATED_LEAF_QUEUE_TEMPLATE_PREFIX = "leaf-queue-template";
    @InterfaceAudience.Private
    public static final String AUTO_CREATE_QUEUE_MAX_QUEUES = "auto-create-child-queue.max-queues";
    @InterfaceAudience.Private
    public static final int DEFAULT_AUTO_CREATE_QUEUE_MAX_QUEUES = 1000;
    @InterfaceAudience.Private
    public static final String FAIL_AUTO_CREATION_ON_EXCEEDING_CAPACITY = "auto-create-child-queue.fail-on-exceeding-parent-capacity";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_FAIL_AUTO_CREATION_ON_EXCEEDING_CAPACITY = false;
    @InterfaceAudience.Private
    public static final String AUTO_CREATED_QUEUE_MANAGEMENT_POLICY = "auto-create-child-queue.management-policy";
    @InterfaceAudience.Private
    public static final String DEFAULT_AUTO_CREATED_QUEUE_MANAGEMENT_POLICY = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.GuaranteedOrZeroCapacityOverTimePolicy";
    @InterfaceAudience.Private
    private static final String QUEUE_MANAGEMENT_CONFIG_PREFIX = "yarn.resourcemanager.monitor.capacity.queue-management.";
    @InterfaceAudience.Private
    public static final String QUEUE_MANAGEMENT_MONITORING_INTERVAL = "yarn.resourcemanager.monitor.capacity.queue-management.monitoring-interval";
    @InterfaceAudience.Private
    public static final long DEFAULT_QUEUE_MANAGEMENT_MONITORING_INTERVAL = 1500L;
    @InterfaceAudience.Private
    public static final boolean DEFAULT_AUTO_CREATE_CHILD_QUEUE_AUTO_REMOVAL_ENABLE = true;
    @InterfaceAudience.Private
    public static final String AUTO_CREATE_CHILD_QUEUE_AUTO_REMOVAL_ENABLE = "auto-queue-creation-v2.queue-auto-removal.enable";
    @InterfaceAudience.Private
    public static final long DEFAULT_AUTO_CREATE_CHILD_QUEUE_EXPIRED_TIME = 300L;
    @InterfaceAudience.Private
    public static final String AUTO_CREATE_CHILD_QUEUE_EXPIRED_TIME = "yarn.scheduler.capacity.auto-queue-creation-v2.queue-expiration-time";
    @InterfaceAudience.Private
    public static final String QUEUE_AUTO_REFRESH_MONITORING_INTERVAL = "yarn.scheduler.capacity.queue.auto.refresh.monitoring-interval";
    @InterfaceAudience.Private
    public static final long DEFAULT_QUEUE_AUTO_REFRESH_MONITORING_INTERVAL = 5000L;
    @InterfaceAudience.Private
    public static final String MULTI_NODE_SORTING_POLICIES = "yarn.scheduler.capacity.multi-node-sorting.policy.names";
    @InterfaceAudience.Private
    public static final String MULTI_NODE_SORTING_POLICY_NAME = "yarn.scheduler.capacity.multi-node-sorting.policy";
    public static final String DEFAULT_NODE_SORTING_POLICY = "default";
    public static final String DEFAULT_NODE_SORTING_POLICY_CLASSNAME = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.ResourceUsageMultiNodeLookupPolicy";
    public static final long DEFAULT_MULTI_NODE_SORTING_INTERVAL = 1000L;
    @InterfaceAudience.Private
    public static final String MULTI_NODE_PLACEMENT_ENABLED = "yarn.scheduler.capacity.multi-node-placement-enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_MULTI_NODE_PLACEMENT_ENABLED = false;

    public static QueueCapacityConfigParser getQueueCapacityConfigParser() {
        return queueCapacityConfigParser;
    }

    public int getMaximumAutoCreatedQueueDepth(QueuePath queuePath) {
        return this.getInt(QueuePrefixes.getQueuePrefix(queuePath) + MAXIMUM_QUEUE_DEPTH, this.getInt("yarn.scheduler.capacity.auto-queue-creation-v2.maximum-queue-depth", 2));
    }

    public void setMaximumAutoCreatedQueueDepth(QueuePath queue, int value) {
        this.setInt(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_QUEUE_DEPTH, value);
    }

    public void setMaximumAutoCreatedQueueDepth(int value) {
        this.setInt("yarn.scheduler.capacity.auto-queue-creation-v2.maximum-queue-depth", value);
    }

    public CapacitySchedulerConfiguration() {
        this(new Configuration());
    }

    public CapacitySchedulerConfiguration(Configuration configuration) {
        this(configuration, true);
    }

    public CapacitySchedulerConfiguration(Configuration configuration, boolean useLocalConfigurationProvider) {
        super(configuration);
        if (useLocalConfigurationProvider) {
            this.addResource(CS_CONFIGURATION_FILE);
        }
    }

    static String getUserPrefix(String user) {
        return "yarn.scheduler.capacity.user." + user + DOT;
    }

    public void setMaximumSystemApplications(int numMaxApps) {
        this.setInt(MAXIMUM_SYSTEM_APPLICATIONS, numMaxApps);
    }

    public int getMaximumSystemApplications() {
        int maxApplications = this.getInt(MAXIMUM_SYSTEM_APPLICATIONS, 10000);
        return maxApplications;
    }

    public void setMaximumApplicationMasterResourcePercent(float percent) {
        this.setFloat(MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT, percent);
    }

    public float getMaximumApplicationMasterResourcePercent() {
        return this.getFloat(MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT, 0.1f);
    }

    public int getMaximumApplicationsPerQueue(QueuePath queue) {
        int maxApplicationsPerQueue = this.getInt(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_APPLICATIONS_SUFFIX, -1);
        return maxApplicationsPerQueue;
    }

    @VisibleForTesting
    public void setMaximumApplicationsPerQueue(QueuePath queue, int numMaxApps) {
        this.setInt(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_APPLICATIONS_SUFFIX, numMaxApps);
    }

    public float getMaximumApplicationMasterResourcePerQueuePercent(QueuePath queue) {
        return this.getFloat(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_AM_RESOURCE_SUFFIX, this.getMaximumApplicationMasterResourcePercent());
    }

    public void setMaximumApplicationMasterResourcePerQueuePercent(QueuePath queue, float percent) {
        this.setFloat(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_AM_RESOURCE_SUFFIX, percent);
    }

    private void throwExceptionForUnexpectedWeight(float weight, QueuePath queue, String label) {
        if ((double)weight < -1.0E-6 && (double)Math.abs(weight + 1.0f) > 1.0E-6 || weight > 10000.0f) {
            throw new IllegalArgumentException("Illegal weight=" + weight + " for queue=" + queue.getFullPath() + "label=" + label + ". Acceptable values: [0, 10000], -1 is same as not set");
        }
    }

    public float getNonLabeledQueueWeight(QueuePath queue) {
        String configuredValue = this.get(QueuePrefixes.getQueuePrefix(queue) + CAPACITY);
        float weight = this.extractFloatValueFromWeightConfig(configuredValue);
        this.throwExceptionForUnexpectedWeight(weight, queue, "");
        return weight;
    }

    public void setNonLabeledQueueWeight(QueuePath queue, float weight) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + CAPACITY, weight + WEIGHT_SUFFIX);
    }

    public void setLabeledQueueWeight(QueuePath queue, String label, float weight) {
        this.set(QueuePrefixes.getNodeLabelPrefix(queue, label) + CAPACITY, weight + WEIGHT_SUFFIX);
    }

    public float getLabeledQueueWeight(QueuePath queue, String label) {
        String configuredValue = this.get(QueuePrefixes.getNodeLabelPrefix(queue, label) + CAPACITY);
        float weight = this.extractFloatValueFromWeightConfig(configuredValue);
        this.throwExceptionForUnexpectedWeight(weight, queue, label);
        return weight;
    }

    public float getNonLabeledQueueCapacity(QueuePath queue) {
        float capacity;
        String configuredCapacity = this.get(QueuePrefixes.getQueuePrefix(queue) + CAPACITY);
        boolean absoluteResourceConfigured = configuredCapacity != null && RESOURCE_PATTERN.matcher(configuredCapacity).find();
        boolean isCapacityVectorFormat = queueCapacityConfigParser.isCapacityVectorFormat(configuredCapacity);
        if (absoluteResourceConfigured || this.configuredWeightAsCapacity(configuredCapacity) || isCapacityVectorFormat) {
            return queue.isRoot() ? 100.0f : 0.0f;
        }
        float f = queue.isRoot() ? 100.0f : (capacity = configuredCapacity == null ? 0.0f : Float.parseFloat(configuredCapacity));
        if (capacity < 0.0f || capacity > 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + capacity + " for queue " + queue.getFullPath());
        }
        LOG.debug((Object)("CSConf - getCapacity: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", capacity=" + capacity));
        return capacity;
    }

    public void setCapacity(QueuePath queue, float capacity) {
        if (queue.isRoot()) {
            throw new IllegalArgumentException("Cannot set capacity, root queue has a fixed capacity of 100.0f");
        }
        this.setFloat(QueuePrefixes.getQueuePrefix(queue) + CAPACITY, capacity);
        LOG.debug((Object)("CSConf - setCapacity: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", capacity=" + capacity));
    }

    @VisibleForTesting
    public void setCapacity(QueuePath queue, String absoluteResourceCapacity) {
        if (queue.isRoot()) {
            throw new IllegalArgumentException("Cannot set capacity, root queue has a fixed capacity");
        }
        this.set(QueuePrefixes.getQueuePrefix(queue) + CAPACITY, absoluteResourceCapacity);
        LOG.debug((Object)("CSConf - setCapacity: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", capacity=" + absoluteResourceCapacity));
    }

    public String getRootAutoscalerMinimumCapacity() {
        return this.get(QueuePrefixes.getQueuePrefix(ROOT_PATH) + AUTOSCALER_MINIMUM_CAPACITY, "");
    }

    public String getRootAutoscalerMaximumCapacity() {
        return this.get(QueuePrefixes.getQueuePrefix(ROOT_PATH) + AUTOSCALER_MAXIMUM_CAPACITY, "");
    }

    public void setRootAutoscalerMinimumCapacity(String minCapacity) {
        this.set(QueuePrefixes.getQueuePrefix(ROOT_PATH) + AUTOSCALER_MINIMUM_CAPACITY, minCapacity);
    }

    public void setRootAutoscalerMaximumCapacity(String maxCapacity) {
        this.set(QueuePrefixes.getQueuePrefix(ROOT_PATH) + AUTOSCALER_MAXIMUM_CAPACITY, maxCapacity);
    }

    public float getNonLabeledQueueMaximumCapacity(QueuePath queue) {
        boolean matcher;
        String configuredCapacity = this.get(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_CAPACITY);
        boolean bl = matcher = configuredCapacity != null && RESOURCE_PATTERN.matcher(configuredCapacity).find() || queueCapacityConfigParser.isCapacityVectorFormat(configuredCapacity);
        if (matcher) {
            return 100.0f;
        }
        float maxCapacity = configuredCapacity == null ? 100.0f : Float.parseFloat(configuredCapacity);
        maxCapacity = maxCapacity == -1.0f ? 100.0f : maxCapacity;
        return maxCapacity;
    }

    public void setMaximumCapacity(QueuePath queue, float maxCapacity) {
        if (maxCapacity > 100.0f) {
            throw new IllegalArgumentException("Illegal maximum-capacity of " + maxCapacity + " for queue " + queue.getFullPath());
        }
        this.setFloat(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_CAPACITY, maxCapacity);
        LOG.debug((Object)("CSConf - setMaxCapacity: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", maxCapacity=" + maxCapacity));
    }

    public void setCapacityByLabel(QueuePath queue, String label, float capacity) {
        this.setFloat(QueuePrefixes.getNodeLabelPrefix(queue, label) + CAPACITY, capacity);
    }

    @VisibleForTesting
    public void setCapacityByLabel(QueuePath queue, String label, String absoluteResourceCapacity) {
        this.set(QueuePrefixes.getNodeLabelPrefix(queue, label) + CAPACITY, absoluteResourceCapacity);
    }

    public void setMaximumCapacityByLabel(QueuePath queue, String label, float capacity) {
        this.setFloat(QueuePrefixes.getNodeLabelPrefix(queue, label) + MAXIMUM_CAPACITY, capacity);
    }

    public void setMaximumCapacityByLabel(QueuePath queue, String label, String absoluteResourceCapacity) {
        this.set(QueuePrefixes.getNodeLabelPrefix(queue, label) + MAXIMUM_CAPACITY, absoluteResourceCapacity);
    }

    public float getUserLimit(QueuePath queue) {
        float userLimit = this.getFloat(QueuePrefixes.getQueuePrefix(queue) + USER_LIMIT, 100.0f);
        return userLimit;
    }

    public <S extends SchedulableEntity> OrderingPolicy<S> getAppOrderingPolicy(QueuePath queue) {
        OrderingPolicy orderingPolicy;
        String policyType = this.get(QueuePrefixes.getQueuePrefix(queue) + ORDERING_POLICY, "fifo");
        if (policyType.trim().equals("fifo")) {
            policyType = FifoOrderingPolicy.class.getName();
        }
        if (policyType.trim().equals(FAIR_APP_ORDERING_POLICY)) {
            policyType = FairOrderingPolicy.class.getName();
        }
        if (policyType.trim().equals(FIFO_FOR_PENDING_APPS)) {
            policyType = FifoOrderingPolicyForPendingApps.class.getName();
        }
        try {
            orderingPolicy = (OrderingPolicy)Class.forName(policyType).newInstance();
        }
        catch (Exception e) {
            String message = "Unable to construct ordering policy for: " + policyType + ", " + e.getMessage();
            throw new RuntimeException(message, e);
        }
        HashMap<String, String> config = new HashMap<String, String>();
        String confPrefix = QueuePrefixes.getQueuePrefix(queue) + ORDERING_POLICY + DOT;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry kv = (Map.Entry)iterator.next();
            if (!((String)kv.getKey()).startsWith(confPrefix)) continue;
            config.put(((String)kv.getKey()).substring(confPrefix.length()), (String)kv.getValue());
        }
        orderingPolicy.configure(config);
        return orderingPolicy;
    }

    public void setUserLimit(QueuePath queue, float userLimit) {
        this.setFloat(QueuePrefixes.getQueuePrefix(queue) + USER_LIMIT, userLimit);
        LOG.debug((Object)("here setUserLimit: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", userLimit=" + this.getUserLimit(queue)));
    }

    public float getUserLimitFactor(QueuePath queue) {
        float userLimitFactor = this.getFloat(QueuePrefixes.getQueuePrefix(queue) + USER_LIMIT_FACTOR, 1.0f);
        return userLimitFactor;
    }

    public void setUserLimitFactor(QueuePath queuePath, float userLimitFactor) {
        this.setFloat(QueuePrefixes.getQueuePrefix(queuePath) + USER_LIMIT_FACTOR, userLimitFactor);
    }

    public QueueState getConfiguredState(QueuePath queue) {
        String state = this.get(QueuePrefixes.getQueuePrefix(queue) + STATE);
        if (state == null) {
            return null;
        }
        return QueueState.valueOf((String)StringUtils.toUpperCase((String)state));
    }

    public QueueState getState(QueuePath queue) {
        QueueState state = this.getConfiguredState(queue);
        return state == null ? QueueState.RUNNING : state;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setState(QueuePath queue, QueueState state) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + STATE, state.name());
    }

    public void setAccessibleNodeLabels(QueuePath queue, Set<String> labels) {
        if (labels == null) {
            return;
        }
        String str = StringUtils.join((CharSequence)",", labels);
        this.set(QueuePrefixes.getQueuePrefix(queue) + ACCESSIBLE_NODE_LABELS, str);
    }

    public Set<String> getAccessibleNodeLabels(QueuePath queue) {
        String accessibleLabelStr = this.get(QueuePrefixes.getQueuePrefix(queue) + ACCESSIBLE_NODE_LABELS);
        if (accessibleLabelStr == null) {
            if (!queue.isRoot()) {
                return null;
            }
        } else if (queue.isRoot()) {
            LOG.warn((Object)"Accessible node labels for root queue will be ignored, it will be automatically set to \"*\".");
        }
        if (queue.isRoot()) {
            return ImmutableSet.of((Object)ALL_ACL);
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : accessibleLabelStr.split(",")) {
            if (str.trim().isEmpty()) continue;
            set.add(str.trim());
        }
        if (set.contains(ALL_ACL)) {
            set.clear();
            set.add(ALL_ACL);
        }
        return Collections.unmodifiableSet(set);
    }

    public void setCapacityVector(QueuePath queuePath, String label, String capacityVector) {
        String capacityPropertyName = QueuePrefixes.getNodeLabelPrefix(queuePath, label) + CAPACITY;
        this.set(capacityPropertyName, capacityVector);
    }

    public void setMaximumCapacityVector(QueuePath queuePath, String label, String capacityVector) {
        String capacityPropertyName = QueuePrefixes.getNodeLabelPrefix(queuePath, label) + MAXIMUM_CAPACITY;
        this.set(capacityPropertyName, capacityVector);
    }

    private boolean configuredWeightAsCapacity(String configureValue) {
        if (configureValue == null) {
            return false;
        }
        return configureValue.endsWith(WEIGHT_SUFFIX);
    }

    private float extractFloatValueFromWeightConfig(String configureValue) {
        if (!this.configuredWeightAsCapacity(configureValue)) {
            return -1.0f;
        }
        return Float.valueOf(configureValue.substring(0, configureValue.indexOf(WEIGHT_SUFFIX))).floatValue();
    }

    private float internalGetLabeledQueueCapacity(QueuePath queue, String label, String suffix, float defaultValue) {
        float capacity;
        boolean absoluteResourceConfigured;
        String capacityPropertyName = QueuePrefixes.getNodeLabelPrefix(queue, label) + suffix;
        String configuredCapacity = this.get(capacityPropertyName);
        boolean bl = absoluteResourceConfigured = configuredCapacity != null && RESOURCE_PATTERN.matcher(configuredCapacity).find();
        if (absoluteResourceConfigured || this.configuredWeightAsCapacity(configuredCapacity) || queueCapacityConfigParser.isCapacityVectorFormat(configuredCapacity)) {
            return queue.isRoot() ? 100.0f : defaultValue;
        }
        float f = capacity = queue.isRoot() ? 100.0f : this.getFloat(capacityPropertyName, defaultValue);
        if (capacity < 0.0f || capacity > 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + capacity + " for node-label=" + label + " in queue=" + queue + ", valid capacity should in range of [0, 100].");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CSConf - getCapacityOfLabel: prefix=" + QueuePrefixes.getNodeLabelPrefix(queue, label) + ", capacity=" + capacity));
        }
        return capacity;
    }

    public float getLabeledQueueCapacity(QueuePath queue, String label) {
        return this.internalGetLabeledQueueCapacity(queue, label, CAPACITY, 0.0f);
    }

    public float getLabeledQueueMaximumCapacity(QueuePath queue, String label) {
        return this.internalGetLabeledQueueCapacity(queue, label, MAXIMUM_CAPACITY, 100.0f);
    }

    public String getDefaultNodeLabelExpression(QueuePath queue) {
        String defaultLabelExpression = this.get(QueuePrefixes.getQueuePrefix(queue) + DEFAULT_NODE_LABEL_EXPRESSION);
        if (defaultLabelExpression == null) {
            return null;
        }
        return defaultLabelExpression.trim();
    }

    public void setDefaultNodeLabelExpression(QueuePath queue, String exp) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + DEFAULT_NODE_LABEL_EXPRESSION, exp);
    }

    public float getMaximumAMResourcePercentPerPartition(QueuePath queue, String label) {
        return this.getFloat(QueuePrefixes.getNodeLabelPrefix(queue, label) + MAXIMUM_AM_RESOURCE_SUFFIX, this.getMaximumApplicationMasterResourcePerQueuePercent(queue));
    }

    public void setMaximumAMResourcePercentPerPartition(QueuePath queue, String label, float percent) {
        this.setFloat(QueuePrefixes.getNodeLabelPrefix(queue, label) + MAXIMUM_AM_RESOURCE_SUFFIX, percent);
    }

    public boolean getReservationContinueLook() {
        return this.getBoolean(RESERVE_CONT_LOOK_ALL_NODES, true);
    }

    public boolean getSkipAllocateOnNodesWithReservedContainer() {
        return this.getBoolean(SKIP_ALLOCATE_ON_NODES_WITH_RESERVED_CONTAINERS, false);
    }

    private static String getAclKey(QueueACL acl) {
        return "acl_" + StringUtils.toLowerCase((String)acl.toString());
    }

    public AccessControlList getAcl(QueuePath queue, QueueACL acl) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        String defaultAcl = queue.isRoot() ? ALL_ACL : NONE_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), defaultAcl);
        return new AccessControlList(aclString);
    }

    public void setAcl(QueuePath queue, QueueACL acl, String aclString) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    private static String getAclKey(ReservationACL acl) {
        return "acl_" + StringUtils.toLowerCase((String)acl.toString());
    }

    private static String getAclKey(AccessType acl) {
        return "acl_" + StringUtils.toLowerCase((String)acl.toString());
    }

    public Map<AccessType, AccessControlList> getACLsForLegacyAutoCreatedLeafQueue(QueuePath parentQueuePath) {
        String prefix = QueuePrefixes.getQueuePrefix(QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(parentQueuePath));
        HashMap<String, String> properties = new HashMap<String, String>();
        for (QueueACL acl : QueueACL.values()) {
            String key = CapacitySchedulerConfiguration.getAclKey(acl);
            String value = this.get(prefix + key);
            if (value == null) continue;
            properties.put(key, this.get(prefix + key));
        }
        return CapacitySchedulerConfiguration.getACLsFromProperties(properties);
    }

    public static Map<AccessType, AccessControlList> getACLsForFlexibleAutoCreatedParentQueue(AutoCreatedQueueTemplate aqc) {
        return CapacitySchedulerConfiguration.getACLsFromProperties(aqc.getParentOnlyProperties(), aqc.getTemplateProperties());
    }

    public static Map<AccessType, AccessControlList> getACLsForFlexibleAutoCreatedLeafQueue(AutoCreatedQueueTemplate aqc) {
        return CapacitySchedulerConfiguration.getACLsFromProperties(aqc.getLeafOnlyProperties(), aqc.getTemplateProperties());
    }

    private static Map<AccessType, AccessControlList> getACLsFromProperties(Map<String, String> properties) {
        return CapacitySchedulerConfiguration.getACLsFromProperties(properties, new HashMap<String, String>());
    }

    private static Map<AccessType, AccessControlList> getACLsFromProperties(Map<String, String> properties, Map<String, String> fallbackProperties) {
        HashMap<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
        for (QueueACL acl : QueueACL.values()) {
            String aclStr = properties.get(CapacitySchedulerConfiguration.getAclKey(acl));
            if (aclStr == null && (aclStr = fallbackProperties.get(CapacitySchedulerConfiguration.getAclKey(acl))) == null) {
                aclStr = NONE_ACL;
            }
            acls.put(SchedulerUtils.toAccessType(acl), new AccessControlList(aclStr));
        }
        return acls;
    }

    @Override
    public Map<ReservationACL, AccessControlList> getReservationAcls(QueuePath queue) {
        HashMap<ReservationACL, AccessControlList> resAcls = new HashMap<ReservationACL, AccessControlList>();
        for (ReservationACL acl : ReservationACL.values()) {
            resAcls.put(acl, this.getReservationAcl(queue, acl));
        }
        return resAcls;
    }

    private AccessControlList getReservationAcl(QueuePath queue, ReservationACL acl) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        String defaultAcl = ALL_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), defaultAcl);
        return new AccessControlList(aclString);
    }

    private void setAcl(QueuePath queue, ReservationACL acl, String aclString) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    private void setAcl(QueuePath queue, AccessType acl, String aclString) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    public Map<AccessType, AccessControlList> getAcls(QueuePath queue) {
        HashMap<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
        for (QueueACL acl : QueueACL.values()) {
            acls.put(SchedulerUtils.toAccessType(acl), this.getAcl(queue, acl));
        }
        return acls;
    }

    public void setAcls(QueuePath queue, Map<QueueACL, AccessControlList> acls) {
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            this.setAcl(queue, e.getKey(), e.getValue().getAclString());
        }
    }

    @VisibleForTesting
    public void setReservationAcls(QueuePath queue, Map<ReservationACL, AccessControlList> acls) {
        for (Map.Entry<ReservationACL, AccessControlList> e : acls.entrySet()) {
            this.setAcl(queue, e.getKey(), e.getValue().getAclString());
        }
    }

    @VisibleForTesting
    public void setPriorityAcls(QueuePath queue, Priority priority, Priority defaultPriority, String[] acls) {
        StringBuilder aclString = new StringBuilder();
        StringBuilder userAndGroup = new StringBuilder();
        for (int i = 0; i < acls.length; ++i) {
            userAndGroup.append((Object)((Object)AppPriorityACLConfigurationParser.AppPriorityACLKeyType.values()[i]) + "=" + acls[i].trim()).append(NONE_ACL);
        }
        aclString.append("[" + userAndGroup.toString().trim() + " max_priority=" + priority.getPriority() + " default_priority=" + defaultPriority.getPriority() + "]");
        this.setAcl(queue, AccessType.APPLICATION_MAX_PRIORITY, aclString.toString());
    }

    public List<AppPriorityACLGroup> getPriorityAcls(QueuePath queue, Priority clusterMaxPriority) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        String defaultAcl = ALL_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(AccessType.APPLICATION_MAX_PRIORITY), defaultAcl);
        return this.priorityACLConfig.getPriorityAcl(clusterMaxPriority, aclString);
    }

    public List<String> getQueues(QueuePath queue) {
        LOG.debug((Object)("CSConf - getQueues called for: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue)));
        String[] queues = this.getStrings(QueuePrefixes.getQueuePrefix(queue) + QUEUES);
        ArrayList<String> trimmedQueueNames = new ArrayList<String>();
        if (null != queues) {
            for (String s : queues) {
                trimmedQueueNames.add(s.trim());
            }
        }
        LOG.debug((Object)("CSConf - getQueues: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", queues=" + (queues == null ? "" : StringUtils.arrayToString((String[])queues))));
        return trimmedQueueNames;
    }

    public void setQueues(QueuePath queue, String[] subQueues) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + QUEUES, StringUtils.arrayToString((String[])subQueues));
        LOG.debug((Object)("CSConf - setQueues: qPrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", queues=" + StringUtils.arrayToString((String[])subQueues)));
    }

    public Resource getMinimumAllocation() {
        int minimumMemory = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int minimumCores = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        return Resources.createResource((int)minimumMemory, (int)minimumCores);
    }

    @InterfaceAudience.Private
    public Priority getQueuePriority(QueuePath queue) {
        String queuePolicyPrefix = QueuePrefixes.getQueuePrefix(queue);
        Priority pri = Priority.newInstance((int)this.getInt(queuePolicyPrefix + "priority", 0));
        return pri;
    }

    @InterfaceAudience.Private
    public void setQueuePriority(QueuePath queue, int priority) {
        String queuePolicyPrefix = QueuePrefixes.getQueuePrefix(queue);
        this.setInt(queuePolicyPrefix + "priority", priority);
    }

    public Resource getQueueMaximumAllocation(QueuePath queue) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        String rawQueueMaxAllocation = this.get(queuePrefix + MAXIMUM_ALLOCATION, null);
        if (Strings.isNullOrEmpty((String)rawQueueMaxAllocation)) {
            return Resources.none();
        }
        return ResourceUtils.createResourceFromString((String)rawQueueMaxAllocation, (List)ResourceUtils.getResourcesTypeInfo());
    }

    public void setQueueMaximumAllocation(QueuePath queue, String maximumAllocation) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        this.set(queuePrefix + MAXIMUM_ALLOCATION, maximumAllocation);
    }

    public ConfigurationProperties getConfigurationProperties() {
        if (this.configurationProperties == null) {
            this.reinitializeConfigurationProperties();
        }
        return this.configurationProperties;
    }

    public void reinitializeConfigurationProperties() {
        Properties props = this.getProps();
        this.configurationProperties = new ConfigurationProperties(props);
    }

    public void setQueueMaximumAllocationMb(QueuePath queue, int value) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        this.setInt(queuePrefix + MAXIMUM_ALLOCATION_MB, value);
    }

    public void setQueueMaximumAllocationVcores(QueuePath queue, int value) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        this.setInt(queuePrefix + MAXIMUM_ALLOCATION_VCORES, value);
    }

    public long getQueueMaximumAllocationMb(QueuePath queue) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        return this.getInt(queuePrefix + MAXIMUM_ALLOCATION_MB, -1);
    }

    public int getQueueMaximumAllocationVcores(QueuePath queue) {
        String queuePrefix = QueuePrefixes.getQueuePrefix(queue);
        return this.getInt(queuePrefix + MAXIMUM_ALLOCATION_VCORES, -1);
    }

    public boolean getEnableUserMetrics() {
        return this.getBoolean(ENABLE_USER_METRICS, false);
    }

    public int getOffSwitchPerHeartbeatLimit() {
        int limit = this.getInt(OFFSWITCH_PER_HEARTBEAT_LIMIT, 1);
        if (limit < 1) {
            LOG.warn((Object)("yarn.scheduler.capacity.per-node-heartbeat.maximum-offswitch-assignments(" + limit + ") < 1. Using 1."));
            limit = 1;
        }
        return limit;
    }

    public void setOffSwitchPerHeartbeatLimit(int limit) {
        this.setInt(OFFSWITCH_PER_HEARTBEAT_LIMIT, limit);
    }

    public int getNodeLocalityDelay() {
        return this.getInt(NODE_LOCALITY_DELAY, 40);
    }

    @VisibleForTesting
    public void setNodeLocalityDelay(int nodeLocalityDelay) {
        this.setInt(NODE_LOCALITY_DELAY, nodeLocalityDelay);
    }

    public int getRackLocalityAdditionalDelay() {
        return this.getInt(RACK_LOCALITY_ADDITIONAL_DELAY, -1);
    }

    public boolean getRackLocalityFullReset() {
        return this.getBoolean(RACK_LOCALITY_FULL_RESET, true);
    }

    public ResourceCalculator getResourceCalculator() {
        return (ResourceCalculator)ReflectionUtils.newInstance((Class)this.getClass(RESOURCE_CALCULATOR_CLASS, DEFAULT_RESOURCE_CALCULATOR_CLASS, ResourceCalculator.class), (Configuration)this);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public void setResourceComparator(Class<? extends ResourceCalculator> resourceCalculatorClass) {
        this.setClass(RESOURCE_CALCULATOR_CLASS, resourceCalculatorClass, ResourceCalculator.class);
    }

    public boolean getScheduleAynschronously() {
        return this.getBoolean(SCHEDULE_ASYNCHRONOUSLY_ENABLE, false);
    }

    public void setScheduleAynschronously(boolean async) {
        this.setBoolean(SCHEDULE_ASYNCHRONOUSLY_ENABLE, async);
    }

    public boolean getOverrideWithQueueMappings() {
        return this.getBoolean(ENABLE_QUEUE_MAPPING_OVERRIDE, false);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setOverrideWithQueueMappings(boolean overrideWithQueueMappings) {
        this.setBoolean(ENABLE_QUEUE_MAPPING_OVERRIDE, overrideWithQueueMappings);
    }

    public List<QueueMapping> getQueueMappingEntity(String queueMappingSuffix) {
        String queueMappingName = this.buildQueueMappingRuleProperty(queueMappingSuffix);
        ArrayList<QueueMapping> mappings = new ArrayList<QueueMapping>();
        Collection mappingsString = this.getTrimmedStringCollection(queueMappingName);
        for (String mappingValue : mappingsString) {
            String[] mapping = StringUtils.getTrimmedStringCollection((String)mappingValue, (String)":").toArray(new String[0]);
            if (mapping.length != 2 || mapping[1].length() == 0) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            QueueMapping m = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.APPLICATION).source(mapping[0]).parsePathString(mapping[1]).build();
            mappings.add(m);
        }
        return mappings;
    }

    private String buildQueueMappingRuleProperty(String queueMappingSuffix) {
        StringBuilder queueMapping = new StringBuilder();
        queueMapping.append("yarn.scheduler.queue-placement-rules").append(DOT).append(queueMappingSuffix);
        return queueMapping.toString();
    }

    @VisibleForTesting
    public void setQueueMappingEntities(List<QueueMapping> queueMappings, String queueMappingSuffix) {
        if (queueMappings == null) {
            return;
        }
        ArrayList<String> queueMappingStrs = new ArrayList<String>();
        for (QueueMapping mapping : queueMappings) {
            queueMappingStrs.add(mapping.toTypelessString());
        }
        String mappingRuleProp = this.buildQueueMappingRuleProperty(queueMappingSuffix);
        this.setStrings(mappingRuleProp, new String[]{StringUtils.join((CharSequence)",", queueMappingStrs)});
    }

    public boolean getOverrideWithWorkflowPriorityMappings() {
        return this.getBoolean(ENABLE_WORKFLOW_PRIORITY_MAPPINGS_OVERRIDE, false);
    }

    public Collection<String> getWorkflowPriorityMappings() {
        return this.getTrimmedStringCollection(WORKFLOW_PRIORITY_MAPPINGS);
    }

    public List<QueueMapping> getQueueMappings() {
        ArrayList<QueueMapping> mappings = new ArrayList<QueueMapping>();
        Collection mappingsString = this.getTrimmedStringCollection(QUEUE_MAPPING);
        for (String mappingValue : mappingsString) {
            QueueMapping m;
            String[] mapping = StringUtils.getTrimmedStringCollection((String)mappingValue, (String)":").toArray(new String[0]);
            if (mapping.length != 3 || mapping[1].length() == 0 || mapping[2].length() == 0) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            try {
                QueueMapping.MappingType mappingType;
                if (mapping[0].equals("u")) {
                    mappingType = QueueMapping.MappingType.USER;
                } else if (mapping[0].equals("g")) {
                    mappingType = QueueMapping.MappingType.GROUP;
                } else {
                    throw new IllegalArgumentException("unknown mapping prefix " + mapping[0]);
                }
                m = QueueMapping.QueueMappingBuilder.create().type(mappingType).source(mapping[1]).parsePathString(mapping[2]).build();
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            if (m == null) continue;
            mappings.add(m);
        }
        return mappings;
    }

    public List<MappingRule> parseLegacyMappingRules() {
        String[] mapping;
        ArrayList<MappingRule> mappings = new ArrayList<MappingRule>();
        Collection mappingsString = this.getTrimmedStringCollection(QUEUE_MAPPING);
        for (String mappingValue : mappingsString) {
            mapping = StringUtils.getTrimmedStringCollection((String)mappingValue, (String)":").toArray(new String[0]);
            if (mapping.length != 3 || mapping[1].length() == 0 || mapping[2].length() == 0) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            if (mapping[0].equals("u") || mapping[0].equals("g")) {
                mappings.add(MappingRule.createLegacyRule(mapping[0], mapping[1], mapping[2]));
                continue;
            }
            throw new IllegalArgumentException("unknown mapping prefix " + mapping[0]);
        }
        mappingsString = this.getTrimmedStringCollection(QUEUE_MAPPING_NAME);
        for (String mappingValue : mappingsString) {
            mapping = StringUtils.getTrimmedStringCollection((String)mappingValue, (String)":").toArray(new String[0]);
            if (mapping.length != 2 || mapping[1].length() == 0) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            mappings.add(MappingRule.createLegacyRule(mapping[0], mapping[1]));
        }
        return mappings;
    }

    public List<MappingRule> parseJSONMappingRules() throws IOException {
        String mappingJson = this.get(MAPPING_RULE_JSON, "");
        String mappingJsonFile = this.get(MAPPING_RULE_JSON_FILE, "");
        MappingRuleCreator creator = new MappingRuleCreator();
        if (!mappingJson.equals("")) {
            LOG.info((Object)("Reading mapping rules from provided inline JSON '" + mappingJson + "'."));
            try {
                return creator.getMappingRulesFromString(mappingJson);
            }
            catch (IOException e) {
                LOG.error((Object)"Error parsing mapping rule inline JSON.");
                throw e;
            }
        }
        if (!mappingJsonFile.equals("")) {
            LOG.info((Object)("Reading mapping rules from JSON file '" + mappingJsonFile + "'."));
            try {
                return creator.getMappingRulesFromFile(mappingJsonFile.trim());
            }
            catch (IOException e) {
                LOG.error((Object)("Error reading or parsing mapping rule JSON file '" + mappingJsonFile + "'."));
                throw e;
            }
        }
        LOG.warn((Object)"Mapping rule is set to JSON, but no inline JSON nor a JSON file was provided! Starting with no mapping rules!");
        return new ArrayList<MappingRule>();
    }

    public void setMappingRuleFormat(String format) {
        this.set(MAPPING_RULE_FORMAT, format);
    }

    public void setMappingRuleJson(String json) {
        this.set(MAPPING_RULE_JSON, json);
    }

    public List<MappingRule> getMappingRules() throws IOException {
        String mappingFormat = this.get(MAPPING_RULE_FORMAT, "legacy");
        if (mappingFormat.equals("legacy")) {
            return this.parseLegacyMappingRules();
        }
        if (mappingFormat.equals(MAPPING_RULE_FORMAT_JSON)) {
            return this.parseJSONMappingRules();
        }
        throw new IllegalArgumentException("Illegal queue mapping format '" + mappingFormat + "' please use '" + "legacy" + "' or '" + MAPPING_RULE_FORMAT_JSON + "'");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setQueuePlacementRules(Collection<String> queuePlacementRules) {
        if (queuePlacementRules == null) {
            return;
        }
        String str = StringUtils.join((CharSequence)",", queuePlacementRules);
        this.setStrings("yarn.scheduler.queue-placement-rules", new String[]{str});
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setQueueMappings(List<QueueMapping> queueMappings) {
        if (queueMappings == null) {
            return;
        }
        ArrayList<String> queueMappingStrs = new ArrayList<String>();
        for (QueueMapping mapping : queueMappings) {
            queueMappingStrs.add(mapping.toString());
        }
        this.setStrings(QUEUE_MAPPING, new String[]{StringUtils.join((CharSequence)",", queueMappingStrs)});
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAppNameMappings(List<QueueMapping> queueMappings) {
        if (queueMappings == null) {
            return;
        }
        ArrayList<String> queueMappingStrs = new ArrayList<String>();
        for (QueueMapping mapping : queueMappings) {
            String rule = mapping.toString();
            String[] parts = rule.split(":");
            queueMappingStrs.add(parts[1] + ":" + parts[2]);
        }
        this.setStrings(QUEUE_MAPPING_NAME, new String[]{StringUtils.join((CharSequence)",", queueMappingStrs)});
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void setWorkflowPriorityMappings(List<WorkflowPriorityMappingsManager.WorkflowPriorityMapping> workflowPriorityMappings) {
        this.setStrings(WORKFLOW_PRIORITY_MAPPINGS, new String[]{WorkflowPriorityMappingsManager.getWorkflowPriorityMappingStr(workflowPriorityMappings)});
    }

    @Override
    public boolean isReservable(QueuePath queue) {
        boolean isReservable = this.getBoolean(QueuePrefixes.getQueuePrefix(queue) + IS_RESERVABLE, false);
        return isReservable;
    }

    public void setReservable(QueuePath queue, boolean isReservable) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queue) + IS_RESERVABLE, isReservable);
        LOG.debug((Object)("here setReservableQueue: queuePrefix=" + QueuePrefixes.getQueuePrefix(queue) + ", isReservableQueue=" + this.isReservable(queue)));
    }

    @Override
    public long getReservationWindow(QueuePath queue) {
        long reservationWindow = this.getLong(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_WINDOW, 86400000L);
        return reservationWindow;
    }

    @Override
    public float getAverageCapacity(QueuePath queue) {
        float avgCapacity = this.getFloat(QueuePrefixes.getQueuePrefix(queue) + AVERAGE_CAPACITY, 100.0f);
        return avgCapacity;
    }

    @Override
    public float getInstantaneousMaxCapacity(QueuePath queue) {
        float instMaxCapacity = this.getFloat(QueuePrefixes.getQueuePrefix(queue) + INSTANTANEOUS_MAX_CAPACITY, 100.0f);
        return instMaxCapacity;
    }

    public void setInstantaneousMaxCapacity(QueuePath queue, float instMaxCapacity) {
        this.setFloat(QueuePrefixes.getQueuePrefix(queue) + INSTANTANEOUS_MAX_CAPACITY, instMaxCapacity);
    }

    public void setReservationWindow(QueuePath queue, long reservationWindow) {
        this.setLong(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_WINDOW, reservationWindow);
    }

    public void setAverageCapacity(QueuePath queue, float avgCapacity) {
        this.setFloat(QueuePrefixes.getQueuePrefix(queue) + AVERAGE_CAPACITY, avgCapacity);
    }

    @Override
    public String getReservationAdmissionPolicy(QueuePath queue) {
        String reservationPolicy = this.get(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_ADMISSION_POLICY, "org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy");
        return reservationPolicy;
    }

    public void setReservationAdmissionPolicy(QueuePath queue, String reservationPolicy) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_ADMISSION_POLICY, reservationPolicy);
    }

    @Override
    public String getReservationAgent(QueuePath queue) {
        String reservationAgent = this.get(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_AGENT_NAME, "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy");
        return reservationAgent;
    }

    public void setReservationAgent(QueuePath queue, String reservationPolicy) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_AGENT_NAME, reservationPolicy);
    }

    @Override
    public boolean getShowReservationAsQueues(QueuePath queuePath) {
        boolean showReservationAsQueues = this.getBoolean(QueuePrefixes.getQueuePrefix(queuePath) + RESERVATION_SHOW_RESERVATION_AS_QUEUE, false);
        return showReservationAsQueues;
    }

    @Override
    public String getReplanner(QueuePath queue) {
        String replanner = this.get(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_PLANNER_NAME, "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.SimpleCapacityReplanner");
        return replanner;
    }

    @Override
    public boolean getMoveOnExpiry(QueuePath queue) {
        boolean killOnExpiry = this.getBoolean(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_MOVE_ON_EXPIRY, true);
        return killOnExpiry;
    }

    @Override
    public long getEnforcementWindow(QueuePath queue) {
        long enforcementWindow = this.getLong(QueuePrefixes.getQueuePrefix(queue) + RESERVATION_ENFORCEMENT_WINDOW, 3600000L);
        return enforcementWindow;
    }

    public void setPreemptionDisabled(QueuePath queue, boolean preemptionDisabled) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queue) + QUEUE_PREEMPTION_DISABLED, preemptionDisabled);
    }

    public boolean getPreemptionDisabled(QueuePath queue, boolean defaultVal) {
        boolean preemptionDisabled = this.getBoolean(QueuePrefixes.getQueuePrefix(queue) + QUEUE_PREEMPTION_DISABLED, defaultVal);
        return preemptionDisabled;
    }

    public boolean getIntraQueuePreemptionDisabled(QueuePath queue, boolean defaultVal) {
        return this.getBoolean(QueuePrefixes.getQueuePrefix(queue) + INTRA_QUEUE_PREEMPTION_CONFIG_PREFIX + QUEUE_PREEMPTION_DISABLED, defaultVal);
    }

    public void setPreemptionObserveOnly(boolean value) {
        this.setBoolean(PREEMPTION_OBSERVE_ONLY, value);
    }

    public boolean getPreemptionObserveOnly() {
        return this.getBoolean(PREEMPTION_OBSERVE_ONLY, false);
    }

    public Set<String> getConfiguredNodeLabels(QueuePath queuePath) {
        HashSet<String> configuredNodeLabels = new HashSet<String>();
        Map.Entry e = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            e = (Map.Entry)iter.next();
            String key = (String)e.getKey();
            if (!key.startsWith(QueuePrefixes.getQueuePrefix(queuePath) + ACCESSIBLE_NODE_LABELS + DOT)) continue;
            int labelStartIdx = key.indexOf(ACCESSIBLE_NODE_LABELS) + ACCESSIBLE_NODE_LABELS.length() + 1;
            int labelEndIndx = key.indexOf(46, labelStartIdx);
            String labelName = key.substring(labelStartIdx, labelEndIndx);
            configuredNodeLabels.add(labelName);
        }
        configuredNodeLabels.add("");
        return configuredNodeLabels;
    }

    public Map<String, Set<String>> getConfiguredNodeLabelsByQueue() {
        HashMap<String, Set<String>> labelsByQueue = new HashMap<String, Set<String>>();
        Map<String, String> schedulerEntries = this.getConfigurationProperties().getPropertiesWithPrefix(PREFIX);
        for (Map.Entry<String, String> propertyEntry : schedulerEntries.entrySet()) {
            String key = propertyEntry.getKey();
            if (!key.contains("accessible-node-labels.")) continue;
            int labelStartIdx = key.indexOf(ACCESSIBLE_NODE_LABELS) + ACCESSIBLE_NODE_LABELS.length() + 1;
            int labelEndIndx = key.indexOf(46, labelStartIdx);
            String labelName = key.substring(labelStartIdx, labelEndIndx);
            String queuePath = key.substring(0, key.indexOf(ACCESSIBLE_NODE_LABELS) - 1);
            if (!labelsByQueue.containsKey(queuePath)) {
                labelsByQueue.put(queuePath, new HashSet());
                ((Set)labelsByQueue.get(queuePath)).add("");
            }
            ((Set)labelsByQueue.get(queuePath)).add(labelName);
        }
        return labelsByQueue;
    }

    public Priority getClusterLevelApplicationMaxPriority() {
        return Priority.newInstance((int)this.getInt("yarn.cluster.max-application-priority", 0));
    }

    public Integer getDefaultApplicationPriorityConfPerQueue(QueuePath queue) {
        Integer defaultPriority = this.getInt(QueuePrefixes.getQueuePrefix(queue) + DEFAULT_APPLICATION_PRIORITY, DEFAULT_CONFIGURATION_APPLICATION_PRIORITY);
        return defaultPriority;
    }

    @VisibleForTesting
    public void setOrderingPolicy(QueuePath queue, String policy) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + ORDERING_POLICY, policy);
    }

    @VisibleForTesting
    public void setOrderingPolicyParameter(QueuePath queue, String parameterKey, String parameterValue) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + ORDERING_POLICY + DOT + parameterKey, parameterValue);
    }

    public boolean getLazyPreemptionEnabled() {
        return this.getBoolean(LAZY_PREEMPTION_ENABLED, false);
    }

    public static boolean shouldAppFailFast(Configuration conf) {
        return conf.getBoolean(APP_FAIL_FAST, false);
    }

    public void setDefaultMaxParallelApps(int value) {
        this.setInt("yarn.scheduler.capacity.max-parallel-apps", value);
    }

    public Integer getDefaultMaxParallelApps() {
        return this.getInt("yarn.scheduler.capacity.max-parallel-apps", Integer.MAX_VALUE);
    }

    public void setDefaultMaxParallelAppsPerUser(int value) {
        this.setInt("yarn.scheduler.capacity.user.max-parallel-apps", value);
    }

    public Integer getDefaultMaxParallelAppsPerUser() {
        return this.getInt("yarn.scheduler.capacity.user.max-parallel-apps", Integer.MAX_VALUE);
    }

    public void setMaxParallelAppsForUser(String user, int value) {
        this.setInt(CapacitySchedulerConfiguration.getUserPrefix(user) + MAX_PARALLEL_APPLICATIONS, value);
    }

    public Integer getMaxParallelAppsForUser(String user) {
        String maxParallelAppsForUser = this.get(CapacitySchedulerConfiguration.getUserPrefix(user) + MAX_PARALLEL_APPLICATIONS);
        return maxParallelAppsForUser != null ? Integer.valueOf(maxParallelAppsForUser) : this.getDefaultMaxParallelAppsPerUser();
    }

    public void setMaxParallelAppsForQueue(QueuePath queue, String value) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + MAX_PARALLEL_APPLICATIONS, value);
    }

    public Integer getMaxParallelAppsForQueue(QueuePath queue) {
        String maxParallelAppsForQueue = this.get(QueuePrefixes.getQueuePrefix(queue) + MAX_PARALLEL_APPLICATIONS);
        return maxParallelAppsForQueue != null ? Integer.valueOf(maxParallelAppsForQueue) : this.getDefaultMaxParallelApps();
    }

    public boolean getAllowZeroCapacitySum(QueuePath queue) {
        return this.getBoolean(QueuePrefixes.getQueuePrefix(queue) + ALLOW_ZERO_CAPACITY_SUM, false);
    }

    public void setAllowZeroCapacitySum(QueuePath queue, boolean value) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queue) + ALLOW_ZERO_CAPACITY_SUM, value);
    }

    public int getGlobalMaximumApplicationsPerQueue() {
        int maxApplicationsPerQueue = this.getInt(QUEUE_GLOBAL_MAX_APPLICATION, -1);
        return maxApplicationsPerQueue;
    }

    public void setGlobalMaximumApplicationsPerQueue(int val) {
        this.setInt(QUEUE_GLOBAL_MAX_APPLICATION, val);
    }

    @InterfaceAudience.Private
    public void setQueueOrderingPolicy(QueuePath queue, String policy) {
        this.set(QueuePrefixes.getQueuePrefix(queue) + ORDERING_POLICY, policy);
    }

    @InterfaceAudience.Private
    public QueueOrderingPolicy getQueueOrderingPolicy(QueuePath queue, String parentPolicy) {
        PriorityUtilizationQueueOrderingPolicy qop;
        String policyType;
        String defaultPolicy = parentPolicy;
        if (null == defaultPolicy) {
            defaultPolicy = "utilization";
        }
        if ((policyType = this.get(QueuePrefixes.getQueuePrefix(queue) + ORDERING_POLICY, defaultPolicy)).trim().equals("utilization")) {
            qop = new PriorityUtilizationQueueOrderingPolicy(false);
        } else if (policyType.trim().equals(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY)) {
            qop = new PriorityUtilizationQueueOrderingPolicy(true);
        } else {
            String message = "Unable to construct queue ordering policy=" + policyType + " queue=" + queue.getFullPath();
            throw new YarnRuntimeException(message);
        }
        return qop;
    }

    private String getOrderingPolicyGlobalConfigKey(String orderPolicyName, String configKey) {
        return "yarn.scheduler.capacity.ordering-policy." + orderPolicyName + DOT + configKey;
    }

    public boolean getPUOrderingPolicyUnderUtilizedPreemptionEnabled() {
        return this.getBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_ENABLED), false);
    }

    @VisibleForTesting
    public void setPUOrderingPolicyUnderUtilizedPreemptionEnabled(boolean enabled) {
        this.setBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_ENABLED), enabled);
    }

    public long getPUOrderingPolicyUnderUtilizedPreemptionDelay() {
        return this.getLong(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_DELAY), 60000L);
    }

    @VisibleForTesting
    public void setPUOrderingPolicyUnderUtilizedPreemptionDelay(long timeout) {
        this.setLong(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_DELAY), timeout);
    }

    public boolean getPUOrderingPolicyUnderUtilizedPreemptionMoveReservation() {
        return this.getBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_MOVE_RESERVATION), false);
    }

    @VisibleForTesting
    public void setPUOrderingPolicyUnderUtilizedPreemptionMoveReservation(boolean allowMoveReservation) {
        this.setBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_MOVE_RESERVATION), allowMoveReservation);
    }

    public UserWeights getAllUserWeightsForQueue(QueuePath queuePath) {
        return UserWeights.createByConfig(this, this.getConfigurationProperties(), queuePath);
    }

    public boolean getAssignMultipleEnabled() {
        return this.getBoolean(ASSIGN_MULTIPLE_ENABLED, true);
    }

    public int getMaxAssignPerHeartbeat() {
        return this.getInt(MAX_ASSIGN_PER_HEARTBEAT, 100);
    }

    public long getMaximumLifetimePerQueue(QueuePath queue) {
        long maximumLifetimePerQueue = this.getLong(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_LIFETIME_SUFFIX, -1L);
        return maximumLifetimePerQueue;
    }

    public void setMaximumLifetimePerQueue(QueuePath queue, long maximumLifetime) {
        this.setLong(QueuePrefixes.getQueuePrefix(queue) + MAXIMUM_LIFETIME_SUFFIX, maximumLifetime);
    }

    public long getDefaultLifetimePerQueue(QueuePath queue) {
        long maximumLifetimePerQueue = this.getLong(QueuePrefixes.getQueuePrefix(queue) + DEFAULT_LIFETIME_SUFFIX, -1L);
        return maximumLifetimePerQueue;
    }

    public void setDefaultLifetimePerQueue(QueuePath queue, long defaultLifetime) {
        this.setLong(QueuePrefixes.getQueuePrefix(queue) + DEFAULT_LIFETIME_SUFFIX, defaultLifetime);
    }

    @InterfaceAudience.Private
    public boolean isAutoCreateChildQueueEnabled(QueuePath queuePath) {
        boolean isAutoCreateEnabled = this.getBoolean(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_CREATE_CHILD_QUEUE_ENABLED, false);
        return isAutoCreateEnabled;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreateChildQueueEnabled(QueuePath queuePath, boolean autoCreationEnabled) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_CREATE_CHILD_QUEUE_ENABLED, autoCreationEnabled);
    }

    public void setAutoQueueCreationV2Enabled(QueuePath queuePath, boolean autoQueueCreation) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_QUEUE_CREATION_V2_ENABLED, autoQueueCreation);
    }

    public boolean isAutoQueueCreationV2Enabled(QueuePath queuePath) {
        boolean isAutoQueueCreation = this.getBoolean(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_QUEUE_CREATION_V2_ENABLED, false);
        return isAutoQueueCreation;
    }

    @InterfaceAudience.Private
    public boolean getShouldFailAutoQueueCreationWhenGuaranteedCapacityExceeded(QueuePath queuePath) {
        boolean shouldFailAutoQueueCreationOnExceedingGuaranteedCapacity = this.getBoolean(QueuePrefixes.getQueuePrefix(queuePath) + FAIL_AUTO_CREATION_ON_EXCEEDING_CAPACITY, false);
        return shouldFailAutoQueueCreationOnExceedingGuaranteedCapacity;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setShouldFailAutoQueueCreationWhenGuaranteedCapacityExceeded(QueuePath queuePath, boolean autoCreationEnabled) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queuePath) + FAIL_AUTO_CREATION_ON_EXCEEDING_CAPACITY, autoCreationEnabled);
    }

    @InterfaceAudience.Private
    public int getAutoCreatedQueuesMaxChildQueuesLimit(QueuePath queuePath) {
        return this.getInt(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_CREATE_QUEUE_MAX_QUEUES, 1000);
    }

    @InterfaceAudience.Private
    public int getAutoCreatedQueuesV2MaxChildQueuesLimit(QueuePath queuePath) {
        return this.getInt(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_QUEUE_CREATION_V2_MAX_QUEUES, 1000);
    }

    @VisibleForTesting
    public void setAutoCreatedQueuesV2MaxChildQueuesLimit(QueuePath queuePath, int maxQueues) {
        this.setInt(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_QUEUE_CREATION_V2_MAX_QUEUES, maxQueues);
    }

    @InterfaceAudience.Private
    public boolean isAutoExpiredDeletionEnabled(QueuePath queuePath) {
        boolean isAutoExpiredDeletionEnabled = this.getBoolean(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_CREATE_CHILD_QUEUE_AUTO_REMOVAL_ENABLE, true);
        return isAutoExpiredDeletionEnabled;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoExpiredDeletionEnabled(QueuePath queuePath, boolean autoRemovalEnable) {
        this.setBoolean(QueuePrefixes.getQueuePrefix(queuePath) + AUTO_CREATE_CHILD_QUEUE_AUTO_REMOVAL_ENABLE, autoRemovalEnable);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoExpiredDeletionTime(long time) {
        this.setLong(AUTO_CREATE_CHILD_QUEUE_EXPIRED_TIME, time);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public long getAutoExpiredDeletionTime() {
        return this.getLong(AUTO_CREATE_CHILD_QUEUE_EXPIRED_TIME, 300L);
    }

    @InterfaceAudience.Private
    public String getAutoCreatedQueueManagementPolicy(QueuePath queue) {
        String autoCreatedQueueManagementPolicy = this.get(QueuePrefixes.getQueuePrefix(queue) + AUTO_CREATED_QUEUE_MANAGEMENT_POLICY, DEFAULT_AUTO_CREATED_QUEUE_MANAGEMENT_POLICY);
        return autoCreatedQueueManagementPolicy;
    }

    @InterfaceAudience.Private
    protected AutoCreatedQueueManagementPolicy getAutoCreatedQueueManagementPolicyClass(QueuePath queue) {
        String queueManagementPolicyClassName = this.getAutoCreatedQueueManagementPolicy(queue);
        LOG.info((Object)("Using Auto Created Queue Management Policy: " + queueManagementPolicyClassName + " for queue: " + queue.getFullPath()));
        try {
            Class queueManagementPolicyClazz = this.getClassByName(queueManagementPolicyClassName);
            if (AutoCreatedQueueManagementPolicy.class.isAssignableFrom(queueManagementPolicyClazz)) {
                return (AutoCreatedQueueManagementPolicy)ReflectionUtils.newInstance((Class)queueManagementPolicyClazz, (Configuration)this);
            }
            throw new YarnRuntimeException("Class: " + queueManagementPolicyClassName + " not instance of " + AutoCreatedQueueManagementPolicy.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate AutoCreatedQueueManagementPolicy: " + queueManagementPolicyClassName + " for queue: " + queue.getFullPath(), (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueConfigCapacity(QueuePath queuePath, float val) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setCapacity(leafQueueConfPrefix, val);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueTemplateCapacityByLabel(QueuePath queuePath, String label, float val) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setCapacityByLabel(leafQueueConfPrefix, label, val);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueTemplateCapacityByLabel(QueuePath queuePath, String label, Resource resource) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        StringBuilder resourceString = new StringBuilder();
        resourceString.append("[" + AbsoluteResourceType.MEMORY.toString().toLowerCase() + "=" + resource.getMemorySize() + "," + AbsoluteResourceType.VCORES.toString().toLowerCase() + "=" + resource.getVirtualCores() + "]");
        this.setCapacityByLabel(leafQueueConfPrefix, label, resourceString.toString());
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueConfigMaxCapacity(QueuePath queuePath, float val) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setMaximumCapacity(leafQueueConfPrefix, val);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueTemplateMaxCapacity(QueuePath queuePath, String label, float val) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setMaximumCapacityByLabel(leafQueueConfPrefix, label, val);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueTemplateMaxCapacity(QueuePath queuePath, String label, Resource resource) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        StringBuilder resourceString = new StringBuilder();
        resourceString.append("[" + AbsoluteResourceType.MEMORY.toString().toLowerCase() + "=" + resource.getMemorySize() + "," + AbsoluteResourceType.VCORES.toString().toLowerCase() + "=" + resource.getVirtualCores() + "]");
        this.setMaximumCapacityByLabel(leafQueueConfPrefix, label, resourceString.toString());
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueConfigUserLimit(QueuePath queuePath, int val) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setUserLimit(leafQueueConfPrefix, val);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueConfigUserLimitFactor(QueuePath queuePath, float val) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setUserLimitFactor(leafQueueConfPrefix, val);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueConfigDefaultNodeLabelExpression(QueuePath queuePath, String expression) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setDefaultNodeLabelExpression(leafQueueConfPrefix, expression);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setAutoCreatedLeafQueueConfigMaximumAllocation(QueuePath queuePath, String expression) {
        QueuePath leafQueueConfPrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix(queuePath);
        this.setQueueMaximumAllocation(leafQueueConfPrefix, expression);
    }

    public static String getUnits(String resourceValue) {
        for (int i = 0; i < resourceValue.length(); ++i) {
            String units;
            if (!Character.isAlphabetic(resourceValue.charAt(i)) || !StringUtils.isAlpha((String)(units = resourceValue.substring(i)))) continue;
            return units;
        }
        return "";
    }

    public Resource getMinimumResourceRequirement(String label, QueuePath queue, Set<String> resourceTypes) {
        return this.internalGetLabeledResourceRequirementForQueue(queue, label, resourceTypes, CAPACITY);
    }

    public Resource getMaximumResourceRequirement(String label, QueuePath queue, Set<String> resourceTypes) {
        return this.internalGetLabeledResourceRequirementForQueue(queue, label, resourceTypes, MAXIMUM_CAPACITY);
    }

    @VisibleForTesting
    public void setMinimumResourceRequirement(String label, QueuePath queue, Resource resource) {
        this.updateMinMaxResourceToConf(label, queue, resource, CAPACITY);
    }

    @VisibleForTesting
    public void setMaximumResourceRequirement(String label, QueuePath queue, Resource resource) {
        this.updateMinMaxResourceToConf(label, queue, resource, MAXIMUM_CAPACITY);
    }

    public Map<String, QueueCapacityVector> parseConfiguredResourceVector(QueuePath queuePath, Set<String> labels) {
        HashMap<String, QueueCapacityVector> queueResourceVectors = new HashMap<String, QueueCapacityVector>();
        for (String label : labels) {
            String propertyName = QueuePrefixes.getNodeLabelPrefix(queuePath, label) + CAPACITY;
            String capacityString = this.get(propertyName);
            queueResourceVectors.put(label, queueCapacityConfigParser.parse(capacityString, queuePath));
        }
        return queueResourceVectors;
    }

    public Map<String, QueueCapacityVector> parseConfiguredMaximumCapacityVector(QueuePath queuePath, Set<String> labels, QueueCapacityVector defaultVector) {
        HashMap<String, QueueCapacityVector> queueResourceVectors = new HashMap<String, QueueCapacityVector>();
        for (String label : labels) {
            String propertyName = QueuePrefixes.getNodeLabelPrefix(queuePath, label) + MAXIMUM_CAPACITY;
            String capacityString = this.get(propertyName);
            QueueCapacityVector capacityVector = queueCapacityConfigParser.parse(capacityString, queuePath);
            if (capacityVector.isEmpty()) {
                capacityVector = defaultVector;
            }
            queueResourceVectors.put(label, capacityVector);
        }
        return queueResourceVectors;
    }

    private void updateMinMaxResourceToConf(String label, QueuePath queue, Resource resource, String type) {
        if (queue.isRoot()) {
            throw new IllegalArgumentException("Cannot set resource, root queue will take 100% of cluster capacity");
        }
        StringBuilder resourceString = new StringBuilder();
        resourceString.append("[" + AbsoluteResourceType.MEMORY.toString().toLowerCase() + "=" + resource.getMemorySize() + "," + AbsoluteResourceType.VCORES.toString().toLowerCase() + "=" + resource.getVirtualCores() + ResourceUtils.getCustomResourcesStrings((Resource)resource) + "]");
        String prefix = QueuePrefixes.getQueuePrefix(queue) + type;
        if (!label.isEmpty()) {
            prefix = QueuePrefixes.getQueuePrefix(queue) + ACCESSIBLE_NODE_LABELS + DOT + label + DOT + type;
        }
        this.set(prefix, resourceString.toString());
    }

    public boolean checkConfigTypeIsAbsoluteResource(String label, QueuePath queue, Set<String> resourceTypes) {
        String propertyName = QueuePrefixes.getNodeLabelPrefix(queue, label) + CAPACITY;
        String resourceString = this.get(propertyName);
        if (resourceString == null || resourceString.isEmpty()) {
            return false;
        }
        Matcher matcher = RESOURCE_PATTERN.matcher(resourceString);
        return matcher.find();
    }

    private Resource internalGetLabeledResourceRequirementForQueue(QueuePath queue, String label, Set<String> resourceTypes, String suffix) {
        String propertyName = QueuePrefixes.getNodeLabelPrefix(queue, label) + suffix;
        String resourceString = this.get(propertyName);
        if (resourceString == null || resourceString.isEmpty()) {
            return Resources.none();
        }
        Resource resource = Resource.newInstance((long)0L, (int)0);
        Matcher matcher = RESOURCE_PATTERN.matcher(resourceString);
        if (matcher.find()) {
            String subGroup = matcher.group(0);
            if (subGroup.trim().isEmpty()) {
                return Resources.none();
            }
            subGroup = subGroup.substring(1, subGroup.length() - 1);
            for (String kvPair : subGroup.trim().split(",")) {
                String[] splits = kvPair.split("=");
                if (splits == null || splits.length <= 1) continue;
                this.updateResourceValuesFromConfig(resourceTypes, resource, splits);
            }
        }
        if (resource.getMemorySize() == 0L) {
            return Resources.none();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CSConf - getAbsolueResourcePerQueue: prefix=" + QueuePrefixes.getNodeLabelPrefix(queue, label) + ", capacity=" + resource));
        }
        return resource;
    }

    private void updateResourceValuesFromConfig(Set<String> resourceTypes, Resource resource, String[] splits) {
        String resourceName = splits[0].trim();
        if (!resourceTypes.contains(resourceName) && !ResourceUtils.getResourceTypes().containsKey(resourceName)) {
            LOG.error((Object)(resourceName + " not supported."));
            return;
        }
        String units = CapacitySchedulerConfiguration.getUnits(splits[1]);
        if (!UnitsConversionUtil.KNOWN_UNITS.contains(units)) {
            return;
        }
        Long resourceValue = Long.valueOf(splits[1].substring(0, splits[1].length() - units.length()));
        if (!units.isEmpty()) {
            resourceValue = UnitsConversionUtil.convert((String)units, (String)"Mi", (long)resourceValue);
        }
        if (!resourceTypes.contains(resourceName)) {
            resource.setResourceInformation(resourceName, ResourceInformation.newInstance((String)resourceName, (String)units, (long)resourceValue));
            return;
        }
        AbsoluteResourceType resType = AbsoluteResourceType.valueOf(StringUtils.toUpperCase((String)resourceName));
        switch (resType) {
            case MEMORY: {
                resource.setMemorySize(resourceValue.longValue());
                break;
            }
            case VCORES: {
                resource.setVirtualCores(resourceValue.intValue());
                break;
            }
            default: {
                resource.setResourceInformation(resourceName, ResourceInformation.newInstance((String)resourceName, (String)units, (long)resourceValue));
            }
        }
    }

    public String getMultiNodesSortingAlgorithmPolicy(QueuePath queue) {
        String policyName = this.get(QueuePrefixes.getQueuePrefix(queue) + "multi-node-sorting.policy");
        if (policyName == null) {
            policyName = this.get(MULTI_NODE_SORTING_POLICY_NAME);
        }
        if (policyName == null || policyName.isEmpty()) {
            return null;
        }
        String policyClassName = this.get("yarn.scheduler.capacity.multi-node-sorting.policy." + policyName.trim() + DOT + "class");
        if (policyClassName == null || policyClassName.isEmpty()) {
            throw new YarnRuntimeException(policyName.trim() + " Class is not configured or not an instance of " + MultiNodeLookupPolicy.class.getCanonicalName());
        }
        return this.normalizePolicyName(policyClassName.trim());
    }

    public boolean isLegacyQueueMode() {
        return this.getBoolean(LEGACY_QUEUE_MODE_ENABLED, true);
    }

    public void setLegacyQueueModeEnabled(boolean value) {
        this.setBoolean(LEGACY_QUEUE_MODE_ENABLED, value);
    }

    public boolean getMultiNodePlacementEnabled() {
        return this.getBoolean(MULTI_NODE_PLACEMENT_ENABLED, false);
    }

    public Set<MultiNodePolicySpec> getMultiNodePlacementPolicies() {
        String[] policies = this.getTrimmedStrings(MULTI_NODE_SORTING_POLICIES);
        HashSet<MultiNodePolicySpec> set = new HashSet<MultiNodePolicySpec>();
        for (String str : policies) {
            if (str.trim().isEmpty()) continue;
            String policyClassName = this.get("yarn.scheduler.capacity.multi-node-sorting.policy." + str.trim() + DOT + "class");
            if (str.trim().equals(DEFAULT_NODE_SORTING_POLICY)) {
                policyClassName = this.get("yarn.scheduler.capacity.multi-node-sorting.policy." + str.trim() + DOT + "class", DEFAULT_NODE_SORTING_POLICY_CLASSNAME);
            }
            if (policyClassName == null) {
                throw new YarnRuntimeException(str.trim() + " Class is not configured or not an instance of " + MultiNodeLookupPolicy.class.getCanonicalName());
            }
            policyClassName = this.normalizePolicyName(policyClassName.trim());
            long policySortingInterval = this.getLong("yarn.scheduler.capacity.multi-node-sorting.policy." + str.trim() + DOT + "sorting-interval.ms", 1000L);
            if (policySortingInterval < 0L) {
                throw new YarnRuntimeException(str.trim() + " multi-node policy is configured with invalid sorting-interval:" + policySortingInterval);
            }
            set.add(new MultiNodePolicySpec(policyClassName, policySortingInterval));
        }
        return Collections.unmodifiableSet(set);
    }

    private String normalizePolicyName(String policyName) {
        try {
            Class nodeSortingPolicyClazz = this.getClassByName(policyName);
            if (MultiNodeLookupPolicy.class.isAssignableFrom(nodeSortingPolicyClazz)) {
                return policyName;
            }
            throw new YarnRuntimeException("Class: " + policyName + " not instance of " + MultiNodeLookupPolicy.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate NodesSortingPolicy: " + policyName, (Throwable)e);
        }
    }

    public static enum AbsoluteResourceType {
        MEMORY,
        VCORES;

    }
}

