/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ConfigurationProperties;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;

public class AutoCreatedQueueTemplate {
    public static final String AUTO_QUEUE_TEMPLATE_PREFIX = "auto-queue-creation-v2.template.";
    public static final String AUTO_QUEUE_LEAF_TEMPLATE_PREFIX = "auto-queue-creation-v2.leaf-template.";
    public static final String AUTO_QUEUE_PARENT_TEMPLATE_PREFIX = "auto-queue-creation-v2.parent-template.";
    public static final String WILDCARD_QUEUE = "*";
    private final Map<String, String> templateProperties = new HashMap<String, String>();
    private final Map<String, String> leafOnlyProperties = new HashMap<String, String>();
    private final Map<String, String> parentOnlyProperties = new HashMap<String, String>();

    public AutoCreatedQueueTemplate(CapacitySchedulerConfiguration configuration, QueuePath queuePath) {
        this.setTemplateConfigEntries(configuration, queuePath);
    }

    @VisibleForTesting
    public static String getAutoQueueTemplatePrefix(QueuePath queuePath) {
        return QueuePrefixes.getQueuePrefix(queuePath) + AUTO_QUEUE_TEMPLATE_PREFIX;
    }

    public Map<String, String> getTemplateProperties() {
        return this.templateProperties;
    }

    public Map<String, String> getLeafOnlyProperties() {
        return this.leafOnlyProperties;
    }

    public Map<String, String> getParentOnlyProperties() {
        return this.parentOnlyProperties;
    }

    public void setTemplateEntriesForChild(CapacitySchedulerConfiguration conf, QueuePath childQueuePath) {
        this.setTemplateEntriesForChild(conf, childQueuePath, false);
    }

    public void setTemplateEntriesForChild(CapacitySchedulerConfiguration conf, QueuePath childQueuePath, boolean isLeaf) {
        if (childQueuePath.isRoot()) {
            return;
        }
        ConfigurationProperties configurationProperties = conf.getConfigurationProperties();
        Set<String> alreadySetProps = configurationProperties.getPropertiesWithPrefix(QueuePrefixes.getQueuePrefix(childQueuePath)).keySet();
        Map<String, String> queueTypeSpecificTemplates = this.parentOnlyProperties;
        if (isLeaf) {
            queueTypeSpecificTemplates = this.leafOnlyProperties;
        }
        for (Map.Entry<String, String> entry : queueTypeSpecificTemplates.entrySet()) {
            if (alreadySetProps.contains(entry.getKey())) continue;
            conf.set(QueuePrefixes.getQueuePrefix(childQueuePath) + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.templateProperties.entrySet()) {
            if (alreadySetProps.contains(entry.getKey()) || queueTypeSpecificTemplates.containsKey(entry.getKey())) continue;
            conf.set(QueuePrefixes.getQueuePrefix(childQueuePath) + entry.getKey(), entry.getValue());
        }
    }

    private void setTemplateConfigEntries(CapacitySchedulerConfiguration configuration, QueuePath queuePath) {
        if (!queuePath.isInvalid()) {
            ConfigurationProperties configurationProperties = configuration.getConfigurationProperties();
            int maxAutoCreatedQueueDepth = configuration.getMaximumAutoCreatedQueueDepth(queuePath);
            List<QueuePath> wildcardedQueuePaths = queuePath.getWildcardedQueuePaths(maxAutoCreatedQueueDepth);
            for (QueuePath templateQueuePath : wildcardedQueuePaths) {
                Map<String, String> queueProps = configurationProperties.getPropertiesWithPrefix(QueuePrefixes.getQueuePrefix(templateQueuePath));
                for (Map.Entry<String, String> entry : queueProps.entrySet()) {
                    this.storeConfiguredTemplates(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void storeConfiguredTemplates(String templateKey, String templateValue) {
        String prefix = "";
        Map<String, String> properties = this.templateProperties;
        if (templateKey.startsWith(AUTO_QUEUE_TEMPLATE_PREFIX)) {
            prefix = AUTO_QUEUE_TEMPLATE_PREFIX;
        } else if (templateKey.startsWith(AUTO_QUEUE_LEAF_TEMPLATE_PREFIX)) {
            prefix = AUTO_QUEUE_LEAF_TEMPLATE_PREFIX;
            properties = this.leafOnlyProperties;
        } else if (templateKey.startsWith(AUTO_QUEUE_PARENT_TEMPLATE_PREFIX)) {
            prefix = AUTO_QUEUE_PARENT_TEMPLATE_PREFIX;
            properties = this.parentOnlyProperties;
        }
        if (!prefix.isEmpty()) {
            String key = templateKey.substring(prefix.length());
            properties.putIfAbsent(key, templateValue);
        }
    }
}

