/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ApplicationSchedulingConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationPlacementAllocatorFactory {
    public static AppPlacementAllocator<SchedulerNode> getAppPlacementAllocator(String appPlacementAllocatorName, AppSchedulingInfo appSchedulingInfo, SchedulerRequestKey schedulerRequestKey, RMContext rmContext, SchedulerApplicationAttempt appAttempt) {
        Class<AppPlacementAllocator<Object>> policyClass;
        try {
            policyClass = appPlacementAllocatorName == null ? ApplicationSchedulingConfig.DEFAULT_APPLICATION_PLACEMENT_TYPE_CLASS : Class.forName(appPlacementAllocatorName);
        }
        catch (ClassNotFoundException e) {
            policyClass = ApplicationSchedulingConfig.DEFAULT_APPLICATION_PLACEMENT_TYPE_CLASS;
        }
        if (!AppPlacementAllocator.class.isAssignableFrom(policyClass)) {
            policyClass = ApplicationSchedulingConfig.DEFAULT_APPLICATION_PLACEMENT_TYPE_CLASS;
        }
        AppPlacementAllocator placementAllocatorInstance = (AppPlacementAllocator)ReflectionUtils.newInstance(policyClass, null);
        placementAllocatorInstance.initialize(appSchedulingInfo, schedulerRequestKey, rmContext, appAttempt);
        return placementAllocatorInstance;
    }
}

