/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AbstractResourceUsage {
    protected ReentrantReadWriteLock.ReadLock readLock;
    protected ReentrantReadWriteLock.WriteLock writeLock;
    protected final Map<String, UsageByLabel> usages;
    private final UsageByLabel noLabelUsages;

    public AbstractResourceUsage() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.usages = new HashMap<String, UsageByLabel>();
        this.noLabelUsages = new UsageByLabel();
        this.usages.put("", this.noLabelUsages);
    }

    private static Resource normalize(Resource res) {
        if (res == null) {
            return Resources.none();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource _get(String label, ResourceType type) {
        if (label == null || label.equals("")) {
            return AbstractResourceUsage.normalize((Resource)this.noLabelUsages.resArr.get(type.idx));
        }
        this.readLock.lock();
        try {
            UsageByLabel usage = this.usages.get(label);
            if (null == usage) {
                Resource resource = Resources.none();
                return resource;
            }
            Resource resource = AbstractResourceUsage.normalize((Resource)usage.resArr.get(type.idx));
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource _getAll(ResourceType type) {
        this.readLock.lock();
        try {
            Resource allOfType = Resources.createResource((int)0);
            for (Map.Entry<String, UsageByLabel> usageEntry : this.usages.entrySet()) {
                Resources.addTo((Resource)allOfType, (Resource)((Resource)usageEntry.getValue().resArr.get(type.idx)));
            }
            Resource resource = allOfType;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private UsageByLabel getAndAddIfMissing(String label) {
        if (label == null || label.equals("")) {
            return this.noLabelUsages;
        }
        if (!this.usages.containsKey(label)) {
            UsageByLabel u = new UsageByLabel();
            this.usages.put(label, u);
            return u;
        }
        return this.usages.get(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _set(String label, ResourceType type, Resource res) {
        this.writeLock.lock();
        try {
            UsageByLabel usage = this.getAndAddIfMissing(label);
            usage.resArr.set(type.idx, res);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _inc(String label, ResourceType type, Resource res) {
        this.writeLock.lock();
        try {
            UsageByLabel usage = this.getAndAddIfMissing(label);
            usage.resArr.set(type.idx, Resources.add((Resource)((Resource)usage.resArr.get(type.idx)), (Resource)res));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _dec(String label, ResourceType type, Resource res) {
        this.writeLock.lock();
        try {
            UsageByLabel usage = this.getAndAddIfMissing(label);
            usage.resArr.set(type.idx, Resources.subtract((Resource)((Resource)usage.resArr.get(type.idx)), (Resource)res));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.usages.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> getExistingNodeLabels() {
        this.readLock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.usages.keySet());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static class UsageByLabel {
        private final AtomicReferenceArray<Resource> resArr = new AtomicReferenceArray(ResourceType.values().length);

        public UsageByLabel() {
            for (int i = 0; i < this.resArr.length(); ++i) {
                this.resArr.set(i, Resource.newInstance((int)0, (int)0));
            }
        }

        public Resource getUsed() {
            return this.resArr.get(ResourceType.USED.idx);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{used=" + this.resArr.get(ResourceType.USED.idx) + ", ");
            sb.append("pending=" + this.resArr.get(ResourceType.PENDING.idx) + ", ");
            sb.append("am_used=" + this.resArr.get(ResourceType.AMUSED.idx) + ", ");
            sb.append("reserved=" + this.resArr.get(ResourceType.RESERVED.idx) + ", ");
            sb.append("min_eff=" + this.resArr.get(ResourceType.EFF_MIN_RESOURCE.idx) + ", ");
            sb.append("max_eff=" + this.resArr.get(ResourceType.EFF_MAX_RESOURCE.idx) + "}");
            return sb.toString();
        }
    }

    public static enum ResourceType {
        USED(0),
        PENDING(1),
        AMUSED(2),
        RESERVED(3),
        CACHED_USED(4),
        CACHED_PENDING(5),
        AMLIMIT(6),
        MIN_RESOURCE(7),
        MAX_RESOURCE(8),
        EFF_MIN_RESOURCE(9),
        EFF_MAX_RESOURCE(10),
        USERAMLIMIT(11);

        private int idx;

        private ResourceType(int value) {
            this.idx = value;
        }
    }
}

