/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class PlacementFactory {
    private static final Log LOG = LogFactory.getLog(PlacementFactory.class);

    private PlacementFactory() {
    }

    public static PlacementRule getPlacementRule(String ruleStr, Configuration conf) throws ClassNotFoundException {
        Class<PlacementRule> ruleClass = Class.forName(ruleStr).asSubclass(PlacementRule.class);
        LOG.info((Object)("Using PlacementRule implementation - " + ruleClass));
        return (PlacementRule)ReflectionUtils.newInstance(ruleClass, (Configuration)conf);
    }

    public static PlacementRule getPlacementRule(Class<? extends PlacementRule> ruleClass, Object initArg) {
        LOG.info((Object)("Creating PlacementRule implementation: " + ruleClass));
        PlacementRule rule = (PlacementRule)ReflectionUtils.newInstance(ruleClass, null);
        rule.setConfig(initArg);
        return rule;
    }
}

