/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.AbstractPreemptionEntity;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class TempUserPerPartition
extends AbstractPreemptionEntity {
    private final UsersManager.User user;
    private Resource userLimit;
    private boolean donePreemptionQuotaForULDelta = false;
    private Map<ApplicationId, TempAppPerPartition> apps;

    TempUserPerPartition(UsersManager.User user, String queueName, Resource usedPerPartition, Resource amUsedPerPartition, Resource reserved, Resource pendingPerPartition) {
        super(queueName, usedPerPartition, amUsedPerPartition, reserved, pendingPerPartition);
        this.user = user;
        this.apps = new HashMap<ApplicationId, TempAppPerPartition>();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" NAME: " + this.getUserName()).append(" CUR: ").append(this.getUsed()).append(" PEN: ").append(this.pending).append(" RESERVED: ").append(this.reserved).append(" AM_USED: ").append(this.amUsed).append(" USER_LIMIT: ").append(this.getUserLimit()).append(" IDEAL_ASSIGNED: ").append(this.idealAssigned).append(" USED_WO_AMUSED: ").append(this.getUsedDeductAM()).append(" IDEAL_PREEMPT: ").append(this.toBePreempted).append(" ACTUAL_PREEMPT: ").append(this.getActuallyToBePreempted());
        if (this.getFairShare() != null) {
            sb.append(" FAIR-SHARE: ").append(this.getFairShare());
        }
        return sb.append("\n").toString();
    }

    public String getUserName() {
        return this.user.getUserName();
    }

    public Resource getUserLimit() {
        return this.userLimit;
    }

    public void setUserLimit(Resource userLimitResource) {
        this.userLimit = userLimitResource;
    }

    public boolean isUserLimitReached(ResourceCalculator rc, Resource clusterResource) {
        return Resources.greaterThan((ResourceCalculator)rc, (Resource)clusterResource, (Resource)this.getUsedDeductAM(), (Resource)this.userLimit);
    }

    public boolean isPreemptionQuotaForULDeltaDone() {
        return this.donePreemptionQuotaForULDelta;
    }

    public void updatePreemptionQuotaForULDeltaAsDone(boolean done) {
        this.donePreemptionQuotaForULDelta = done;
    }

    public void addApp(ApplicationId applicationId, TempAppPerPartition tempAppPerPartition) {
        this.apps.put(applicationId, tempAppPerPartition);
    }

    public TempAppPerPartition getApp(ApplicationId applicationId) {
        if (!this.apps.containsKey(applicationId)) {
            return null;
        }
        return this.apps.get(applicationId);
    }

    public Collection<TempAppPerPartition> getApps() {
        return this.apps.values();
    }
}

