/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsCpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class CGroupsV2CpuResourceHandlerImpl
extends AbstractCGroupsCpuResourceHandler {
    private static final CGroupsHandler.CGroupController CPU = CGroupsHandler.CGroupController.CPU;
    @VisibleForTesting
    static final int CPU_DEFAULT_WEIGHT = 100;
    static final int CPU_DEFAULT_WEIGHT_OPPORTUNISTIC = 1;
    static final int CPU_MAX_WEIGHT = 10000;
    static final String NO_LIMIT = "max";

    CGroupsV2CpuResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    protected void updateCgroupMaxCpuLimit(String cgroupId, String max, String period) throws ResourceHandlerException {
        String currentCpuMax = this.cGroupsHandler.getCGroupParam(CPU, cgroupId, NO_LIMIT);
        if (currentCpuMax == null) {
            currentCpuMax = "";
        }
        String[] currentCpuMaxArray = currentCpuMax.split(" ");
        String maxToSet = max != null ? max : currentCpuMaxArray[0];
        maxToSet = maxToSet.equals("-1") ? NO_LIMIT : maxToSet;
        String periodToSet = period != null ? period : currentCpuMaxArray[1];
        this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, NO_LIMIT, maxToSet + " " + periodToSet);
    }

    @Override
    protected int getOpportunisticCpuWeight() {
        return 1;
    }

    @Override
    protected int getCpuWeightByContainerVcores(int containerVCores) {
        return Math.min(containerVCores * 100, 10000);
    }

    @Override
    protected void updateCgroupCpuWeight(String cgroupId, int weight) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "weight", String.valueOf(weight));
    }

    @Override
    public boolean cpuLimitExists(String cgroupPath) throws ResourceHandlerException {
        String globalCpuMaxLimit = this.cGroupsHandler.getCGroupParam(CPU, "", NO_LIMIT);
        if (globalCpuMaxLimit == null) {
            return false;
        }
        String[] cpuMaxLimitArray = globalCpuMaxLimit.split(" ");
        return !cpuMaxLimitArray[0].equals(NO_LIMIT);
    }
}

