/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

public class CGroupsMountConfig {
    private final boolean enableMount;
    private final String mountPath;
    private final String v2MountPath;

    public CGroupsMountConfig(Configuration conf) {
        this.enableMount = conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.mount", false);
        this.mountPath = conf.get("yarn.nodemanager.linux-container-executor.cgroups.mount-path", null);
        this.v2MountPath = conf.get("yarn.nodemanager.linux-container-executor.cgroups.v2.mount-path", this.mountPath);
    }

    public boolean ensureMountPathIsDefined() throws ResourceHandlerException {
        if (this.mountPath == null) {
            throw new ResourceHandlerException(String.format("Cgroups mount path not specified in %s.", "yarn.nodemanager.linux-container-executor.cgroups.mount-path"));
        }
        return true;
    }

    public boolean isMountPathDefined() {
        return this.mountPath != null;
    }

    public boolean isMountEnabled() {
        return this.enableMount;
    }

    public boolean mountDisabledButMountPathDefined() {
        return !this.enableMount && this.mountPath != null;
    }

    public boolean mountEnabledAndMountPathDefined() {
        return this.enableMount && this.mountPath != null;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public String getV2MountPath() {
        return this.v2MountPath;
    }

    public String toString() {
        return "CGroupsMountConfig{enableMount=" + this.enableMount + ", mountPath='" + this.mountPath + ", v2MountPath='" + this.v2MountPath + '\'' + '}';
    }
}

