/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class CGroupsHandlerImpl
extends AbstractCGroupsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupsHandlerImpl.class);
    private static final String CGROUP_FSTYPE = "cgroup";

    CGroupsHandlerImpl(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor, String mtab) throws ResourceHandlerException {
        super(conf, privilegedOperationExecutor, mtab);
    }

    CGroupsHandlerImpl(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor) throws ResourceHandlerException {
        this(conf, privilegedOperationExecutor, "/proc/mounts");
    }

    @Override
    public Set<String> getValidCGroups() {
        return CGroupsHandler.CGroupController.getValidV1CGroups();
    }

    @Override
    protected List<CGroupsHandler.CGroupController> getCGroupControllers() {
        return Arrays.stream(CGroupsHandler.CGroupController.values()).filter(CGroupsHandler.CGroupController::isInV1).collect(Collectors.toList());
    }

    @Override
    protected Map<String, Set<String>> parsePreConfiguredMountPath() throws IOException {
        return ResourceHandlerModule.parseConfiguredCGroupPath(this.cGroupsMountConfig.getMountPath());
    }

    @Override
    protected Set<String> handleMtabEntry(String path, String type, String options) {
        Set<String> validCgroups = this.getValidCGroups();
        if (type.equals(CGROUP_FSTYPE)) {
            HashSet<String> controllerSet = new HashSet<String>(Arrays.asList(options.split(",")));
            controllerSet.retainAll(validCgroups);
            return controllerSet;
        }
        return null;
    }

    @Override
    protected void mountCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        String existingMountPath = this.getControllerPath(controller);
        String requestedMountPath = new File(this.cGroupsMountConfig.getMountPath(), controller.getName()).getAbsolutePath();
        if (!requestedMountPath.equals(existingMountPath)) {
            this.rwLock.writeLock().lock();
            try {
                String mountOptions = existingMountPath != null ? Joiner.on((char)',').join((Iterable)this.parsedMtab.get(existingMountPath)) : controller.getName();
                String cGroupKV = mountOptions + "=" + requestedMountPath;
                PrivilegedOperation.OperationType opType = PrivilegedOperation.OperationType.MOUNT_CGROUPS;
                PrivilegedOperation op = new PrivilegedOperation(opType);
                op.appendArgs(this.cGroupPrefix, cGroupKV);
                LOG.info("Mounting controller " + controller.getName() + " at " + requestedMountPath);
                this.privilegedOperationExecutor.executePrivilegedOperation(op, false);
                this.controllerPaths.put(controller, requestedMountPath);
            }
            catch (PrivilegedOperationException e) {
                LOG.error("Failed to mount controller: " + controller.getName());
                throw new ResourceHandlerException("Failed to mount controller: " + controller.getName());
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        } else {
            LOG.info("CGroup controller already mounted at: " + existingMountPath);
        }
    }

    @Override
    protected void updateEnabledControllersInHierarchy(File yarnHierarchy, CGroupsHandler.CGroupController controller) {
    }
}

