/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface CGroupsHandler {
    public static final String CGROUP_PARAM_MEMORY_HARD_LIMIT_BYTES = "limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_SWAP_HARD_LIMIT_BYTES = "memsw.limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_SOFT_LIMIT_BYTES = "soft_limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_OOM_CONTROL = "oom_control";
    public static final String CGROUP_PARAM_MEMORY_SWAPPINESS = "swappiness";
    public static final String CGROUP_PARAM_MEMORY_USAGE_BYTES = "usage_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_MEMSW_USAGE_BYTES = "memsw.usage_in_bytes";
    public static final String CGROUP_NO_LIMIT = "-1";
    public static final String UNDER_OOM = "under_oom 1";
    public static final String CGROUP_CPU_PERIOD_US = "cfs_period_us";
    public static final String CGROUP_CPU_QUOTA_US = "cfs_quota_us";
    public static final String CGROUP_CPU_SHARES = "shares";
    public static final String CGROUP_CONTROLLERS_FILE = "cgroup.controllers";
    public static final String CGROUP_SUBTREE_CONTROL_FILE = "cgroup.subtree_control";
    public static final String CGROUP_CPU_MAX = "max";
    public static final String CGROUP_MEMORY_MAX = "max";
    public static final String CGROUP_MEMORY_LOW = "low";
    public static final String CGROUP_PROCS_FILE = "cgroup.procs";
    public static final String CGROUP_PARAM_CLASSID = "classid";
    public static final String CGROUP_PARAM_WEIGHT = "weight";

    public void initializeCGroupController(CGroupController var1) throws ResourceHandlerException;

    public String createCGroup(CGroupController var1, String var2) throws ResourceHandlerException;

    public void deleteCGroup(CGroupController var1, String var2) throws ResourceHandlerException;

    public String getControllerPath(CGroupController var1);

    public Set<String> getValidCGroups();

    public String getRelativePathForCGroup(String var1);

    public String getPathForCGroup(CGroupController var1, String var2);

    public String getPathForCGroupTasks(CGroupController var1, String var2);

    public String getPathForCGroupParam(CGroupController var1, String var2, String var3);

    public void updateCGroupParam(CGroupController var1, String var2, String var3, String var4) throws ResourceHandlerException;

    public String getCGroupParam(CGroupController var1, String var2, String var3) throws ResourceHandlerException;

    public String getCGroupMountPath();

    public String getCGroupV2MountPath();

    public static enum CGroupController {
        NET_CLS("net_cls", true, false),
        BLKIO("blkio", true, false),
        CPUACCT("cpuacct", true, false),
        FREEZER("freezer", true, false),
        DEVICES("devices", true, false),
        IO("io", false, true),
        CPU("cpu", true, true),
        CPUSET("cpuset", true, true),
        MEMORY("memory", true, true);

        private final String name;
        private final boolean inV1;
        private final boolean inV2;

        private CGroupController(String name, boolean inV1, boolean inV2) {
            this.name = name;
            this.inV1 = inV1;
            this.inV2 = inV2;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInV1() {
            return this.inV1;
        }

        public boolean isInV2() {
            return this.inV2;
        }

        public static Set<String> getValidV1CGroups() {
            HashSet<String> validCgroups = new HashSet<String>();
            for (CGroupController controller : CGroupController.values()) {
                if (!controller.isInV1()) continue;
                validCgroups.add(controller.getName());
            }
            return validCgroups;
        }

        public static Set<String> getValidV2CGroups() {
            HashSet<String> validCgroups = new HashSet<String>();
            for (CGroupController controller : CGroupController.values()) {
                if (!controller.isInV2()) continue;
                validCgroups.add(controller.getName());
            }
            return validCgroups;
        }
    }
}

