/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsMountConfig;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCGroupsHandler
implements CGroupsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCGroupsHandler.class);
    protected static final String MTAB_FILE = "/proc/mounts";
    private final long deleteCGroupTimeout;
    private final long deleteCGroupDelay;
    private final Clock clock;
    protected final String mtabFile;
    protected final CGroupsMountConfig cGroupsMountConfig;
    protected final ReadWriteLock rwLock;
    protected Map<CGroupsHandler.CGroupController, String> controllerPaths;
    protected Map<String, Set<String>> parsedMtab;
    protected final PrivilegedOperationExecutor privilegedOperationExecutor;
    protected final String cGroupPrefix;
    private static final Pattern MTAB_FILE_FORMAT = Pattern.compile("^[^\\s]+\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s[^\\s]+\\s[^\\s]+$");

    AbstractCGroupsHandler(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor, String mtab) throws ResourceHandlerException {
        this.cGroupPrefix = conf.get("yarn.nodemanager.linux-container-executor.cgroups.hierarchy", "/hadoop-yarn").replaceAll("^/+", "").replaceAll("/+$", "");
        this.cGroupsMountConfig = new CGroupsMountConfig(conf);
        this.deleteCGroupTimeout = conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-timeout-ms", 1000L) + conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L) + 1000L;
        this.deleteCGroupDelay = conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-delay-ms", 20L);
        this.controllerPaths = new HashMap<CGroupsHandler.CGroupController, String>();
        this.parsedMtab = new HashMap<String, Set<String>>();
        this.rwLock = new ReentrantReadWriteLock();
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        this.clock = SystemClock.getInstance();
        this.mtabFile = mtab;
        this.init();
    }

    protected void init() throws ResourceHandlerException {
        this.initializeControllerPaths();
    }

    @Override
    public String getControllerPath(CGroupsHandler.CGroupController controller) {
        this.rwLock.readLock().lock();
        try {
            String string = this.controllerPaths.get((Object)controller);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeControllerPaths() throws ResourceHandlerException {
        Map<CGroupsHandler.CGroupController, String> cPaths;
        Map<String, Set<String>> newMtab = null;
        try {
            if (this.cGroupsMountConfig.mountDisabledButMountPathDefined()) {
                newMtab = this.parsePreConfiguredMountPath();
            }
            if (newMtab == null) {
                newMtab = this.parseMtab(this.mtabFile);
            }
            cPaths = this.initializeControllerPathsFromMtab(newMtab);
        }
        catch (IOException e) {
            LOG.warn("Failed to initialize controller paths! Exception: ", (Throwable)e);
            throw new ResourceHandlerException("Failed to initialize controller paths!");
        }
        this.rwLock.writeLock().lock();
        try {
            this.controllerPaths = cPaths;
            this.parsedMtab = newMtab;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    protected abstract Map<String, Set<String>> parsePreConfiguredMountPath() throws IOException;

    protected Map<CGroupsHandler.CGroupController, String> initializeControllerPathsFromMtab(Map<String, Set<String>> mtab) {
        HashMap<CGroupsHandler.CGroupController, String> ret = new HashMap<CGroupsHandler.CGroupController, String>();
        for (CGroupsHandler.CGroupController controller : this.getCGroupControllers()) {
            String subsystemName = controller.getName();
            String controllerPath = this.findControllerInMtab(subsystemName, mtab);
            if (controllerPath == null) continue;
            ret.put(controller, controllerPath);
        }
        return ret;
    }

    protected abstract List<CGroupsHandler.CGroupController> getCGroupControllers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Set<String>> parseMtab(String mtab) throws IOException {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        BufferedReader in = null;
        try {
            FileInputStream fis = new FileInputStream(mtab);
            in = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            String str = in.readLine();
            while (str != null) {
                String options;
                String type;
                String path;
                Set<String> controllerSet;
                Matcher m = MTAB_FILE_FORMAT.matcher(str);
                boolean mat = m.find();
                if (mat && (controllerSet = this.handleMtabEntry(path = m.group(1), type = m.group(2), options = m.group(3))) != null) {
                    ret.put(path, controllerSet);
                }
                str = in.readLine();
            }
        }
        catch (IOException e) {
            try {
                if (Shell.LINUX) {
                    throw new IOException("Error while reading " + mtab, e);
                }
                LOG.warn("Error while reading " + mtab, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        return ret;
    }

    protected abstract Set<String> handleMtabEntry(String var1, String var2, String var3) throws IOException;

    protected String findControllerInMtab(String controller, Map<String, Set<String>> entries) {
        for (Map.Entry<String, Set<String>> e : entries.entrySet()) {
            if (!e.getValue().contains(controller)) continue;
            if (new File(e.getKey()).canRead()) {
                return e.getKey();
            }
            LOG.warn(String.format("Skipping inaccessible cgroup mount point %s", e.getKey()));
        }
        return null;
    }

    protected abstract void mountCGroupController(CGroupsHandler.CGroupController var1) throws ResourceHandlerException;

    @Override
    public String getRelativePathForCGroup(String cGroupId) {
        return this.cGroupPrefix + "/" + cGroupId;
    }

    @Override
    public String getPathForCGroup(CGroupsHandler.CGroupController controller, String cGroupId) {
        return this.getControllerPath(controller) + "/" + this.cGroupPrefix + "/" + cGroupId;
    }

    @Override
    public String getPathForCGroupTasks(CGroupsHandler.CGroupController controller, String cGroupId) {
        return this.getPathForCGroup(controller, cGroupId) + "/" + "cgroup.procs";
    }

    @Override
    public String getPathForCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param) {
        return this.getPathForCGroup(controller, cGroupId) + "/" + controller.getName() + "." + param;
    }

    @Override
    public void initializeCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        if (this.cGroupsMountConfig.isMountEnabled() && this.cGroupsMountConfig.ensureMountPathIsDefined()) {
            this.mountCGroupController(controller);
        }
        this.initializePreMountedCGroupController(controller);
    }

    private void initializePreMountedCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        String controllerPath = this.getControllerPath(controller);
        if (controllerPath == null) {
            throw new ResourceHandlerException(String.format("Controller %s not mounted. You either need to mount it with %s or mount cgroups before launching Yarn", controller.getName(), "yarn.nodemanager.linux-container-executor.cgroups.mount"));
        }
        File rootHierarchy = new File(controllerPath);
        File yarnHierarchy = new File(rootHierarchy, this.cGroupPrefix);
        String subsystemName = controller.getName();
        LOG.info("Initializing mounted controller " + controller.getName() + " at " + yarnHierarchy);
        if (!rootHierarchy.exists()) {
            throw new ResourceHandlerException(this.getErrorWithDetails("Cgroups mount point does not exist or not accessible", subsystemName, rootHierarchy.getAbsolutePath()));
        }
        if (!yarnHierarchy.exists()) {
            LOG.info("Yarn control group does not exist. Creating " + yarnHierarchy.getAbsolutePath());
            try {
                if (!yarnHierarchy.mkdir()) {
                    throw new ResourceHandlerException(this.getErrorWithDetails("Unexpected: Cannot create yarn cgroup hierarchy", subsystemName, yarnHierarchy.getAbsolutePath()));
                }
                this.updateEnabledControllersInHierarchy(rootHierarchy, controller);
            }
            catch (SecurityException e) {
                throw new ResourceHandlerException(this.getErrorWithDetails("No permissions to create yarn cgroup hierarchy", subsystemName, yarnHierarchy.getAbsolutePath()), e);
            }
        } else if (!FileUtil.canWrite((File)yarnHierarchy)) {
            throw new ResourceHandlerException(this.getErrorWithDetails("Yarn control group not writable", subsystemName, yarnHierarchy.getAbsolutePath()));
        }
        this.updateEnabledControllersInHierarchy(yarnHierarchy, controller);
    }

    protected abstract void updateEnabledControllersInHierarchy(File var1, CGroupsHandler.CGroupController var2) throws ResourceHandlerException;

    protected String getErrorWithDetails(String errorMessage, String subsystemName, String yarnCgroupPath) {
        return String.format("%s Subsystem:%s Mount points:%s User:%s Path:%s ", errorMessage, subsystemName, this.mtabFile, System.getProperty("user.name"), yarnCgroupPath);
    }

    @Override
    public String createCGroup(CGroupsHandler.CGroupController controller, String cGroupId) throws ResourceHandlerException {
        String path = this.getPathForCGroup(controller, cGroupId);
        File cgroup = new File(path);
        LOG.debug("createCgroup: {}", (Object)path);
        if (!cgroup.exists() && !cgroup.mkdir()) {
            throw new ResourceHandlerException("Failed to create cgroup at " + path);
        }
        return path;
    }

    private void logLineFromProcsFile(File cgf) {
        if (LOG.isDebugEnabled()) {
            try (BufferedReader inl = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(cgf + "/" + "cgroup.procs", new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                String str = inl.readLine();
                if (str != null) {
                    LOG.debug("First line in cgroup tasks file: {} {}", (Object)cgf, (Object)str);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
            }
        }
    }

    private boolean checkAndDeleteCgroup(File cgf) throws InterruptedException {
        boolean deleted = false;
        if (cgf.exists()) {
            try (FileInputStream in = new FileInputStream(cgf + "/" + "cgroup.procs");){
                if (in.read() == -1) {
                    Thread.sleep(this.deleteCGroupDelay);
                    deleted = cgf.delete();
                    if (!deleted) {
                        LOG.warn("Failed attempt to delete cgroup: " + cgf);
                    }
                } else {
                    this.logLineFromProcsFile(cgf);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
            }
        } else {
            LOG.info("Parent Cgroups directory {} does not exist. Skipping deletion", (Object)cgf.getPath());
            deleted = true;
        }
        return deleted;
    }

    @Override
    public void deleteCGroup(CGroupsHandler.CGroupController controller, String cGroupId) throws ResourceHandlerException {
        boolean deleted = false;
        String cGroupPath = this.getPathForCGroup(controller, cGroupId);
        LOG.debug("deleteCGroup: {}", (Object)cGroupPath);
        long start = this.clock.getTime();
        do {
            try {
                deleted = this.checkAndDeleteCgroup(new File(cGroupPath));
                if (deleted) continue;
                Thread.sleep(this.deleteCGroupDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!deleted && this.clock.getTime() - start < this.deleteCGroupTimeout);
        if (!deleted) {
            LOG.warn(String.format("Unable to delete  %s, tried to delete for %d ms", cGroupPath, this.deleteCGroupTimeout));
        }
    }

    @Override
    public void updateCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param, String value) throws ResourceHandlerException {
        block8: {
            PrintWriter pw;
            String cGroupParamPath;
            block9: {
                cGroupParamPath = this.getPathForCGroupParam(controller, cGroupId, param);
                pw = null;
                LOG.debug("updateCGroupParam for path: {} with value {}", (Object)cGroupParamPath, (Object)value);
                try {
                    File file = new File(cGroupParamPath);
                    OutputStreamWriter w = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
                    pw = new PrintWriter(w);
                    pw.write(value);
                    if (pw == null) break block8;
                    boolean hasError = pw.checkError();
                    pw.close();
                    if (!hasError) break block9;
                }
                catch (IOException e) {
                    try {
                        throw new ResourceHandlerException(String.format("Unable to write to %s with value: %s", cGroupParamPath, value), e);
                    }
                    catch (Throwable throwable) {
                        if (pw != null) {
                            boolean hasError = pw.checkError();
                            pw.close();
                            if (hasError) {
                                throw new ResourceHandlerException(String.format("PrintWriter unable to write to %s with value: %s", cGroupParamPath, value));
                            }
                            if (pw.checkError()) {
                                throw new ResourceHandlerException(String.format("Error while closing cgroup file %s", cGroupParamPath));
                            }
                        }
                        throw throwable;
                    }
                }
                throw new ResourceHandlerException(String.format("PrintWriter unable to write to %s with value: %s", cGroupParamPath, value));
            }
            if (pw.checkError()) {
                throw new ResourceHandlerException(String.format("Error while closing cgroup file %s", cGroupParamPath));
            }
        }
    }

    @Override
    public String getCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param) throws ResourceHandlerException {
        String cGroupParamPath = param.equals("cgroup.procs") ? this.getPathForCGroup(controller, cGroupId) + "/" + param : this.getPathForCGroupParam(controller, cGroupId, param);
        try {
            byte[] contents = Files.readAllBytes(Paths.get(cGroupParamPath, new String[0]));
            return new String(contents, StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new ResourceHandlerException("Unable to read from " + cGroupParamPath);
        }
    }

    @Override
    public String getCGroupMountPath() {
        return this.cGroupsMountConfig.getMountPath();
    }

    @Override
    public String getCGroupV2MountPath() {
        return this.cGroupsMountConfig.getV2MountPath();
    }

    public String toString() {
        return CGroupsHandlerImpl.class.getName() + "{mtabFile='" + this.mtabFile + '\'' + ", cGroupPrefix='" + this.cGroupPrefix + '\'' + ", cGroupsMountConfig=" + this.cGroupsMountConfig + ", deleteCGroupTimeout=" + this.deleteCGroupTimeout + ", deleteCGroupDelay=" + this.deleteCGroupDelay + '}';
    }
}

