/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public abstract class AbstractCGroupsCpuResourceHandler
implements CpuResourceHandler {
    static final Logger LOG = LoggerFactory.getLogger(AbstractCGroupsCpuResourceHandler.class);
    protected CGroupsHandler cGroupsHandler;
    private boolean strictResourceUsageMode = false;
    private float yarnProcessors;
    private int nodeVCores;
    private static final CGroupsHandler.CGroupController CPU = CGroupsHandler.CGroupController.CPU;
    @VisibleForTesting
    static final int MAX_QUOTA_US = 1000000;
    @VisibleForTesting
    static final int MIN_PERIOD_US = 1000;

    AbstractCGroupsCpuResourceHandler(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration conf) throws ResourceHandlerException {
        return this.bootstrap(ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf), conf);
    }

    @VisibleForTesting
    List<PrivilegedOperation> bootstrap(ResourceCalculatorPlugin plugin, Configuration conf) throws ResourceHandlerException {
        this.strictResourceUsageMode = conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.strict-resource-usage", false);
        this.cGroupsHandler.initializeCGroupController(CPU);
        this.nodeVCores = NodeManagerHardwareUtils.getVCores(plugin, conf);
        this.yarnProcessors = NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
        int systemProcessors = NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
        boolean existingCpuLimits = this.cpuLimitExists(this.cGroupsHandler.getPathForCGroup(CPU, ""));
        if (systemProcessors != (int)this.yarnProcessors) {
            LOG.info("YARN containers restricted to " + this.yarnProcessors + " cores");
            int[] limits = AbstractCGroupsCpuResourceHandler.getOverallLimits(this.yarnProcessors);
            this.updateCgroupMaxCpuLimit("", String.valueOf(limits[1]), String.valueOf(limits[0]));
        } else if (existingCpuLimits) {
            LOG.info("Removing CPU constraints for YARN containers.");
            this.updateCgroupMaxCpuLimit("", String.valueOf(-1), null);
        }
        return null;
    }

    protected abstract void updateCgroupMaxCpuLimit(String var1, String var2, String var3) throws ResourceHandlerException;

    protected abstract boolean cpuLimitExists(String var1) throws ResourceHandlerException;

    @InterfaceAudience.Private
    @VisibleForTesting
    public static int[] getOverallLimits(float yarnProcessors) {
        int[] ret = new int[2];
        if (yarnProcessors < 0.01f) {
            throw new IllegalArgumentException("Number of processors can't be <= 0.");
        }
        int quotaUS = 1000000;
        int periodUS = (int)(1000000.0f / yarnProcessors);
        if (yarnProcessors < 1.0f && (quotaUS = (int)((float)(periodUS = 1000000) * yarnProcessors)) < 1000) {
            LOG.warn("The quota calculated for the cgroup was too low. The minimum value is 1000, calculated value is " + quotaUS + ". Setting quota to minimum value.");
            quotaUS = 1000;
        }
        if (periodUS < 1000) {
            LOG.warn("The period calculated for the cgroup was too low. The minimum value is 1000, calculated value is " + periodUS + ". Using all available CPU.");
            periodUS = 1000000;
            quotaUS = -1;
        }
        ret[0] = periodUS;
        ret[1] = quotaUS;
        return ret;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        this.cGroupsHandler.createCGroup(CPU, cgroupId);
        this.updateContainer(container);
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CPU, cgroupId)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        Resource containerResource = container.getResource();
        String cgroupId = container.getContainerId().toString();
        File cgroup = new File(this.cGroupsHandler.getPathForCGroup(CPU, cgroupId));
        if (cgroup.exists()) {
            try {
                int containerVCores = containerResource.getVirtualCores();
                ContainerTokenIdentifier id = container.getContainerTokenIdentifier();
                if (id != null && id.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                    this.updateCgroupCpuWeight(cgroupId, this.getOpportunisticCpuWeight());
                } else {
                    this.updateCgroupCpuWeight(cgroupId, this.getCpuWeightByContainerVcores(containerVCores));
                }
                if (this.strictResourceUsageMode && this.nodeVCores != containerVCores) {
                    float containerCPU = (float)containerVCores * this.yarnProcessors / (float)this.nodeVCores;
                    int[] limits = AbstractCGroupsCpuResourceHandler.getOverallLimits(containerCPU);
                    this.updateCgroupMaxCpuLimit(cgroupId, String.valueOf(limits[1]), String.valueOf(limits[0]));
                }
            }
            catch (ResourceHandlerException re) {
                this.cGroupsHandler.deleteCGroup(CPU, cgroupId);
                LOG.warn("Could not update cgroup for container", (Throwable)((Object)re));
                throw re;
            }
        }
        return null;
    }

    protected abstract int getOpportunisticCpuWeight();

    protected abstract int getCpuWeightByContainerVcores(int var1);

    protected abstract void updateCgroupCpuWeight(String var1, int var2) throws ResourceHandlerException;

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.cGroupsHandler.deleteCGroup(CPU, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return AbstractCGroupsCpuResourceHandler.class.getName();
    }
}

