/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DockerClient {
    private static final Logger LOG = LoggerFactory.getLogger(DockerClient.class);
    private static final String TMP_FILE_PREFIX = "docker.";
    private static final String TMP_FILE_SUFFIX = ".cmd";
    private static final String TMP_ENV_FILE_SUFFIX = ".env";

    private String writeEnvFile(DockerRunCommand cmd, String filePrefix, File cmdDir) throws IOException {
        File dockerEnvFile = File.createTempFile(TMP_FILE_PREFIX + filePrefix, TMP_ENV_FILE_SUFFIX, cmdDir);
        try (OutputStreamWriter envWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(dockerEnvFile), StandardCharsets.UTF_8);){
            PrintWriter envPrintWriter = new PrintWriter(envWriter);
            try {
                for (Map.Entry<String, String> entry : cmd.getEnv().entrySet()) {
                    envPrintWriter.println(entry.getKey() + "=" + entry.getValue());
                }
                String string = dockerEnvFile.getAbsolutePath();
                envPrintWriter.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    envPrintWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String writeCommandToTempFile(DockerCommand cmd, ContainerId containerId, Context nmContext) throws ContainerExecutionException {
        String filePrefix = containerId.toString();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        File cmdDir = null;
        if (nmContext == null || nmContext.getLocalDirsHandler() == null) {
            throw new ContainerExecutionException("Unable to write temporary docker command");
        }
        try {
            String cmdDirPath = nmContext.getLocalDirsHandler().getLocalPathForWrite("nmPrivate/" + appId + "/" + filePrefix + "/").toString();
            cmdDir = new File(cmdDirPath);
            if (!cmdDir.mkdirs() && !cmdDir.exists()) {
                throw new IOException("Cannot create container private directory " + cmdDir);
            }
            File dockerCommandFile = File.createTempFile(TMP_FILE_PREFIX + filePrefix, TMP_FILE_SUFFIX, cmdDir);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dockerCommandFile.toString()), StandardCharsets.UTF_8);){
                PrintWriter printWriter = new PrintWriter(writer);
                try {
                    DockerRunCommand runCommand;
                    printWriter.println("[docker-command-execution]");
                    for (Map.Entry<String, List<String>> entry : cmd.getDockerCommandWithArguments().entrySet()) {
                        if (entry.getKey().contains("=")) {
                            throw new ContainerExecutionException("'=' found in entry for docker command file, key = " + entry.getKey() + "; value = " + entry.getValue());
                        }
                        String value = StringUtils.join((CharSequence)",", (Iterable)entry.getValue());
                        if (value.contains("\n")) {
                            throw new ContainerExecutionException("'\\n' found in entry for docker command file, key = " + entry.getKey() + "; value = " + value);
                        }
                        printWriter.println("  " + entry.getKey() + "=" + value);
                    }
                    if (cmd instanceof DockerRunCommand && (runCommand = (DockerRunCommand)cmd).containsEnv()) {
                        String path = this.writeEnvFile(runCommand, filePrefix, cmdDir);
                        printWriter.println("  environ=" + path);
                    }
                    String string = dockerCommandFile.toString();
                    printWriter.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to write docker command to " + cmdDir);
            throw new ContainerExecutionException(e);
        }
    }
}

