/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsMemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CGroupsMemoryResourceHandlerImpl
extends AbstractCGroupsMemoryResourceHandler {
    private static final int OPPORTUNISTIC_SWAPPINESS = 100;
    private int swappiness = 0;

    CGroupsMemoryResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration conf) throws ResourceHandlerException {
        super.bootstrap(conf);
        this.swappiness = conf.getInt("yarn.nodemanager.resource.memory.cgroups.swappiness", 0);
        if (this.swappiness < 0 || this.swappiness > 100) {
            throw new ResourceHandlerException("Illegal value '" + this.swappiness + "' for yarn.nodemanager.resource.memory.cgroups.swappiness. Value must be between 0 and 100.");
        }
        return null;
    }

    @VisibleForTesting
    int getSwappiness() {
        return this.swappiness;
    }

    @Override
    protected void updateMemoryHardLimit(String cgroupId, long containerHardLimit) throws ResourceHandlerException {
        this.getCGroupsHandler().updateCGroupParam(MEMORY, cgroupId, "limit_in_bytes", String.valueOf(containerHardLimit) + "M");
    }

    @Override
    protected void updateOpportunisticMemoryLimits(String cgroupId) throws ResourceHandlerException {
        this.getCGroupsHandler().updateCGroupParam(MEMORY, cgroupId, "soft_limit_in_bytes", String.valueOf(0) + "M");
        this.getCGroupsHandler().updateCGroupParam(MEMORY, cgroupId, "swappiness", String.valueOf(100));
    }

    @Override
    protected void updateGuaranteedMemoryLimits(String cgroupId, long containerSoftLimit) throws ResourceHandlerException {
        this.getCGroupsHandler().updateCGroupParam(MEMORY, cgroupId, "soft_limit_in_bytes", String.valueOf(containerSoftLimit) + "M");
        this.getCGroupsHandler().updateCGroupParam(MEMORY, cgroupId, "swappiness", String.valueOf(this.swappiness));
    }
}

