/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsCpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class CGroupsCpuResourceHandlerImpl
extends AbstractCGroupsCpuResourceHandler {
    private static final CGroupsHandler.CGroupController CPU = CGroupsHandler.CGroupController.CPU;
    @VisibleForTesting
    static final int CPU_DEFAULT_WEIGHT = 1024;
    static final int CPU_DEFAULT_WEIGHT_OPPORTUNISTIC = 2;

    CGroupsCpuResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    protected void updateCgroupMaxCpuLimit(String cgroupId, String quota, String period) throws ResourceHandlerException {
        if (period != null) {
            this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "cfs_period_us", period);
        }
        if (quota != null) {
            this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "cfs_quota_us", quota);
        }
    }

    @Override
    protected int getOpportunisticCpuWeight() {
        return 2;
    }

    @Override
    protected int getCpuWeightByContainerVcores(int containerVCores) {
        return containerVCores * 1024;
    }

    @Override
    protected void updateCgroupCpuWeight(String cgroupId, int weight) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "shares", String.valueOf(weight));
    }

    @Override
    public boolean cpuLimitExists(String cgroupPath) throws ResourceHandlerException {
        try {
            return CGroupsCpuResourceHandlerImpl.checkCgroupV1CPULimitExists(cgroupPath);
        }
        catch (IOException e) {
            throw new ResourceHandlerException("Failed to check CPU limit", e);
        }
    }

    @InterfaceAudience.Private
    public static boolean checkCgroupV1CPULimitExists(String path) throws IOException {
        File quotaFile = new File(path, CPU.getName() + ".cfs_quota_us");
        if (quotaFile.exists()) {
            String contents = FileUtils.readFileToString((File)quotaFile, (Charset)StandardCharsets.UTF_8);
            return Integer.parseInt(contents.trim()) != -1;
        }
        return false;
    }
}

