/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourcesExceptionUtil;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDeviceSpecificationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.NvidiaBinaryHelper;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuDeviceInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GpuDiscoverer
extends Configured {
    public static final Logger LOG = LoggerFactory.getLogger(GpuDiscoverer.class);
    @VisibleForTesting
    static final String DEFAULT_BINARY_NAME = "nvidia-smi";
    private static final Set<String> DEFAULT_BINARY_SEARCH_DIRS = ImmutableSet.of((Object)"/usr/bin", (Object)"/bin", (Object)"/usr/local/nvidia/bin");
    private static final int MAX_REPEATED_ERROR_ALLOWED = 10;
    private NvidiaBinaryHelper nvidiaBinaryHelper;
    private String pathOfGpuBinary = null;
    private Map<String, String> environment = new HashMap<String, String>();
    private int numOfErrorExecutionSinceLastSucceed = 0;
    private GpuDeviceInformation lastDiscoveredGpuInformation = null;
    private List<GpuDevice> gpuDevicesFromUser;

    private void validateConfOrThrowException() throws YarnException {
        if (this.getConf() == null) {
            throw new YarnException("Please initialize (call initialize) before use " + GpuDiscoverer.class.getSimpleName());
        }
    }

    private String getErrorMessageOfScriptExecution(String msg) {
        return this.getFailedToExecuteScriptMessage() + "! Exception message: " + msg;
    }

    private String getErrorMessageOfScriptExecutionThresholdReached() {
        return this.getFailedToExecuteScriptMessage() + " for 10 times, skipping following executions!";
    }

    private String getFailedToExecuteScriptMessage() {
        return "Failed to execute GPU device detection script (" + this.pathOfGpuBinary + ")";
    }

    private String getFailedToParseErrorMessage(String msg) {
        return "Failed to parse XML output of GPU device detection script( " + this.pathOfGpuBinary + ")" + msg;
    }

    public synchronized GpuDeviceInformation getGpuDeviceInformation() throws YarnException {
        if (this.numOfErrorExecutionSinceLastSucceed == 10) {
            String msg = this.getErrorMessageOfScriptExecutionThresholdReached();
            LOG.error(msg);
            throw new YarnException(msg);
        }
        try {
            this.lastDiscoveredGpuInformation = this.nvidiaBinaryHelper.getGpuDeviceInformation(this.pathOfGpuBinary);
        }
        catch (IOException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = this.getErrorMessageOfScriptExecution(e.getMessage());
            LOG.debug(msg);
            throw new YarnException(msg, (Throwable)e);
        }
        catch (YarnException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = this.getFailedToParseErrorMessage(e.getMessage());
            LOG.debug(msg, (Throwable)e);
            throw e;
        }
        return this.lastDiscoveredGpuInformation;
    }

    boolean isAutoDiscoveryEnabled() {
        String allowedDevicesStr = this.getConf().get("yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices", "auto");
        return allowedDevicesStr.equals("auto");
    }

    public synchronized List<GpuDevice> getGpusUsableByYarn() throws YarnException {
        this.validateConfOrThrowException();
        if (this.isAutoDiscoveryEnabled()) {
            return this.parseGpuDevicesFromAutoDiscoveredGpuInfo();
        }
        if (this.gpuDevicesFromUser == null) {
            this.gpuDevicesFromUser = this.parseGpuDevicesFromUserDefinedValues();
        }
        return this.gpuDevicesFromUser;
    }

    private List<GpuDevice> parseGpuDevicesFromAutoDiscoveredGpuInfo() throws YarnException {
        if (this.lastDiscoveredGpuInformation == null) {
            String msg = "yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices is set to auto, however automatically discovering GPU information failed, please check NodeManager log for more details, as an alternative, admin can specify yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices manually to enable GPU isolation.";
            LOG.error(msg);
            throw new YarnException(msg);
        }
        ArrayList<GpuDevice> gpuDevices = new ArrayList<GpuDevice>();
        if (this.lastDiscoveredGpuInformation.getGpus() != null) {
            int numberOfGpus = this.lastDiscoveredGpuInformation.getGpus().size();
            LOG.debug("Found {} GPU devices", (Object)numberOfGpus);
            for (int i = 0; i < numberOfGpus; ++i) {
                List<PerGpuDeviceInformation> gpuInfos = this.lastDiscoveredGpuInformation.getGpus();
                gpuDevices.add(new GpuDevice(i, gpuInfos.get(i).getMinorNumber()));
            }
        }
        return gpuDevices;
    }

    private List<GpuDevice> parseGpuDevicesFromUserDefinedValues() throws YarnException {
        String devices = this.getConf().get("yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices", "auto");
        if (devices.trim().isEmpty()) {
            throw GpuDeviceSpecificationException.createWithEmptyValueSpecified();
        }
        ArrayList gpuDevices = Lists.newArrayList();
        for (String device : devices.split(",")) {
            GpuDevice gpuDevice;
            if (device.trim().length() <= 0) continue;
            String[] splitByColon = device.trim().split(":");
            if (splitByColon.length != 2) {
                ResourcesExceptionUtil.throwIfNecessary(GpuDeviceSpecificationException.createWithWrongValueSpecified(device, devices), this.getConf());
                LOG.warn("Wrong GPU specification string {}, ignored", (Object)device);
            }
            try {
                gpuDevice = this.parseGpuDevice(splitByColon);
            }
            catch (NumberFormatException e) {
                ResourcesExceptionUtil.throwIfNecessary(GpuDeviceSpecificationException.createWithWrongValueSpecified(device, devices, e), this.getConf());
                LOG.warn("Cannot parse GPU device numbers: {}", (Object)device);
                continue;
            }
            if (!gpuDevices.contains(gpuDevice)) {
                gpuDevices.add(gpuDevice);
                continue;
            }
            ResourcesExceptionUtil.throwIfNecessary(GpuDeviceSpecificationException.createWithDuplicateValueSpecified(device, devices), this.getConf());
            LOG.warn("CPU device is duplicated: {}", (Object)device);
        }
        LOG.info("Allowed GPU devices:" + gpuDevices);
        return gpuDevices;
    }

    private GpuDevice parseGpuDevice(String[] splitByColon) {
        int index = Integer.parseInt(splitByColon[0]);
        int minorNumber = Integer.parseInt(splitByColon[1]);
        return new GpuDevice(index, minorNumber);
    }

    public synchronized void initialize(Configuration config, NvidiaBinaryHelper nvidiaHelper) throws YarnException {
        this.setConf(config);
        this.nvidiaBinaryHelper = nvidiaHelper;
        if (this.isAutoDiscoveryEnabled()) {
            this.numOfErrorExecutionSinceLastSucceed = 0;
            this.lookUpAutoDiscoveryBinary(config);
            try {
                LOG.info("Trying to discover GPU information ...");
                GpuDeviceInformation info = this.getGpuDeviceInformation();
                LOG.info("Discovered GPU information: " + info.toString());
            }
            catch (YarnException e) {
                String msg = "Failed to discover GPU information from system, exception message:" + e.getMessage() + " continue...";
                LOG.warn(msg);
            }
        }
    }

    private void lookUpAutoDiscoveryBinary(Configuration config) throws YarnException {
        File binaryPath;
        File configuredBinaryFile;
        String configuredBinaryPath = config.get("yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables", DEFAULT_BINARY_NAME);
        if (configuredBinaryPath.isEmpty()) {
            configuredBinaryPath = DEFAULT_BINARY_NAME;
        }
        if (!(configuredBinaryFile = new File(configuredBinaryPath)).exists()) {
            binaryPath = this.lookupBinaryInDefaultDirs();
        } else if (configuredBinaryFile.isDirectory()) {
            binaryPath = this.handleConfiguredBinaryPathIsDirectory(configuredBinaryFile);
        } else {
            binaryPath = configuredBinaryFile;
            String fileName = binaryPath.getName();
            if (!DEFAULT_BINARY_NAME.equals(fileName)) {
                String msg = String.format("Please check the configuration value of %s. It should point to an %s binary, which is now %s", "yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables", DEFAULT_BINARY_NAME, fileName);
                ResourcesExceptionUtil.throwIfNecessary(new YarnException(msg), config);
                LOG.warn(msg);
            }
        }
        this.pathOfGpuBinary = binaryPath.getAbsolutePath();
    }

    private File handleConfiguredBinaryPathIsDirectory(File configuredBinaryFile) throws YarnException {
        File binaryPath = new File(configuredBinaryFile, DEFAULT_BINARY_NAME);
        if (!binaryPath.exists()) {
            throw new YarnException("Failed to find GPU discovery executable, please double check yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables setting. The setting points to a directory but no file found in the directory with name:nvidia-smi");
        }
        LOG.warn("Specified path is a directory, use nvidia-smi under the directory, updated path-to-executable:" + binaryPath.getAbsolutePath());
        return binaryPath;
    }

    private File lookupBinaryInDefaultDirs() throws YarnException {
        File lookedUpBinary = this.lookupBinaryInDefaultDirsInternal();
        if (lookedUpBinary == null) {
            throw new YarnException("Failed to find GPU discovery executable, please double check yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables setting. Also tried to find the executable in the default directories: " + DEFAULT_BINARY_SEARCH_DIRS);
        }
        return lookedUpBinary;
    }

    private File lookupBinaryInDefaultDirsInternal() {
        HashSet triedBinaryPaths = Sets.newHashSet();
        for (String dir : DEFAULT_BINARY_SEARCH_DIRS) {
            File binaryPath = new File(dir, DEFAULT_BINARY_NAME);
            if (binaryPath.exists()) {
                return binaryPath;
            }
            triedBinaryPaths.add(binaryPath.getAbsolutePath());
        }
        LOG.warn("Failed to locate GPU device discovery binary, tried paths: " + triedBinaryPaths + "! Please double check the value of config yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables. Using default binary: nvidia-smi");
        return null;
    }

    @VisibleForTesting
    Map<String, String> getEnvironmentToRunCommand() {
        return this.environment;
    }

    @VisibleForTesting
    String getPathOfGpuBinary() {
        return this.pathOfGpuBinary;
    }
}

