/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.numa;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.numa.NumaResourceAllocation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.numa.NumaResourceAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumaResourceHandlerImpl
implements ResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NumaResourceHandlerImpl.class);
    private final NumaResourceAllocator numaResourceAllocator;
    private final String numaCtlCmd;

    public NumaResourceHandlerImpl(Configuration conf, Context nmContext) {
        LOG.info("NUMA resources allocation is enabled, initializing NUMA resources allocator.");
        this.numaResourceAllocator = new NumaResourceAllocator(nmContext);
        this.numaCtlCmd = conf.get("yarn.nodemanager.numa-awareness.numactl.cmd", "/usr/bin/numactl");
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        try {
            this.numaResourceAllocator.init(configuration);
        }
        catch (YarnException e) {
            throw new ResourceHandlerException(e);
        }
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> ret = null;
        NumaResourceAllocation numaAllocation = this.numaResourceAllocator.allocateNumaNodes(container);
        if (numaAllocation != null) {
            ret = new ArrayList<PrivilegedOperation>();
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.numaCtlCmd);
            args.add("--interleave=" + String.join((CharSequence)",", numaAllocation.getMemNodes()));
            args.add("--cpunodebind=" + String.join((CharSequence)",", numaAllocation.getCpuNodes()));
            ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_NUMA_PARAMS, args));
        }
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        try {
            this.numaResourceAllocator.recoverNumaResource(containerId);
        }
        catch (Throwable e) {
            throw new ResourceHandlerException("Failed to recover numa resource for " + containerId, e);
        }
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.numaResourceAllocator.releaseNumaResource(containerId);
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return NumaResourceHandlerImpl.class.getName() + "{numaResourceAllocator=" + this.numaResourceAllocator + ", numaCtlCmd='" + this.numaCtlCmd + "'}";
    }
}

