/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ConfigurationException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DelegatingLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommandExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRmCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerExecContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerLivenessContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerPrepareContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReacquisitionContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReapContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.LocalizerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.util.CgroupsLCEResourcesHandler;
import org.apache.hadoop.yarn.server.nodemanager.util.DefaultLCEResourcesHandler;
import org.apache.hadoop.yarn.server.nodemanager.util.LCEResourcesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxContainerExecutor
extends ContainerExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxContainerExecutor.class);
    private String nonsecureLocalUser;
    private Pattern nonsecureLocalUserPattern;
    private LCEResourcesHandler resourcesHandler;
    private boolean containerSchedPriorityIsSet = false;
    private int containerSchedPriorityAdjustment = 0;
    private boolean containerLimitUsers;
    private ResourceHandler resourceHandlerChain;
    private LinuxContainerRuntime linuxContainerRuntime;
    private Context nmContext;

    public LinuxContainerExecutor() {
    }

    public LinuxContainerExecutor(LinuxContainerRuntime linuxContainerRuntime) {
        this.linuxContainerRuntime = linuxContainerRuntime;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.resourcesHandler = this.getResourcesHandler(conf);
        this.containerSchedPriorityIsSet = false;
        if (conf.get("yarn.nodemanager.container-executor.os.sched.priority.adjustment") != null) {
            this.containerSchedPriorityIsSet = true;
            this.containerSchedPriorityAdjustment = conf.getInt("yarn.nodemanager.container-executor.os.sched.priority.adjustment", 0);
        }
        this.nonsecureLocalUser = conf.get("yarn.nodemanager.linux-container-executor.nonsecure-mode.local-user", "nobody");
        this.nonsecureLocalUserPattern = Pattern.compile(conf.get("yarn.nodemanager.linux-container-executor.nonsecure-mode.user-pattern", "^[_.A-Za-z0-9][-@_.A-Za-z0-9]{0,255}?[$]?$"));
        this.containerLimitUsers = conf.getBoolean("yarn.nodemanager.linux-container-executor.nonsecure-mode.limit-users", true);
        if (!this.containerLimitUsers) {
            LOG.warn("{}: impersonation without authentication enabled", (Object)"yarn.nodemanager.linux-container-executor.nonsecure-mode.limit-users");
        }
    }

    private LCEResourcesHandler getResourcesHandler(Configuration conf) {
        LCEResourcesHandler handler = (LCEResourcesHandler)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.linux-container-executor.resources-handler.class", DefaultLCEResourcesHandler.class, LCEResourcesHandler.class), (Configuration)conf);
        if (handler instanceof CgroupsLCEResourcesHandler) {
            handler = (LCEResourcesHandler)ReflectionUtils.newInstance(DefaultLCEResourcesHandler.class, (Configuration)conf);
        }
        handler.setConf(conf);
        return handler;
    }

    void verifyUsernamePattern(String user) {
        if (!UserGroupInformation.isSecurityEnabled() && !this.nonsecureLocalUserPattern.matcher(user).matches()) {
            throw new IllegalArgumentException("Invalid user name '" + user + "', it must match '" + this.nonsecureLocalUserPattern.pattern() + "'");
        }
    }

    String getRunAsUser(String user) {
        if (UserGroupInformation.isSecurityEnabled() || !this.containerLimitUsers) {
            return user;
        }
        return this.nonsecureLocalUser;
    }

    protected String getContainerExecutorExecutablePath(Configuration conf) {
        String yarnHomeEnvVar = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
        File hadoopBin = new File(yarnHomeEnvVar, "bin");
        String defaultPath = new File(hadoopBin, "container-executor").getAbsolutePath();
        return null == conf ? defaultPath : conf.get("yarn.nodemanager.linux-container-executor.path", defaultPath);
    }

    protected void addSchedPriorityCommand(List<String> command) {
        if (this.containerSchedPriorityIsSet) {
            command.addAll(Arrays.asList("nice", "-n", Integer.toString(this.containerSchedPriorityAdjustment)));
        }
    }

    protected PrivilegedOperationExecutor getPrivilegedOperationExecutor() {
        return PrivilegedOperationExecutor.getInstance(this.getConf());
    }

    @Override
    public void init(Context context) throws IOException {
        Configuration conf = super.getConf();
        this.nmContext = context;
        try {
            PrivilegedOperation checkSetupOp = new PrivilegedOperation(PrivilegedOperation.OperationType.CHECK_SETUP);
            PrivilegedOperationExecutor privilegedOperationExecutor = this.getPrivilegedOperationExecutor();
            privilegedOperationExecutor.executePrivilegedOperation(checkSetupOp, false);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.warn("Exit code from container executor initialization is : {}", (Object)exitCode, (Object)e);
            throw new IOException("Linux container executor not configured properly (error=" + exitCode + ")", (Throwable)((Object)e));
        }
        try {
            this.resourceHandlerChain = ResourceHandlerModule.getConfiguredResourceHandlerChain(conf, this.nmContext);
            LOG.debug("Resource handler chain enabled = {}", (Object)(this.resourceHandlerChain != null ? 1 : 0));
            if (this.resourceHandlerChain != null) {
                LOG.debug("Bootstrapping resource handler chain: {}", (Object)this.resourceHandlerChain);
                this.resourceHandlerChain.bootstrap(conf);
            }
        }
        catch (ResourceHandlerException e) {
            LOG.error("Failed to bootstrap configured resource subsystems! ", (Throwable)((Object)e));
            throw new IOException("Failed to bootstrap configured resource subsystems!");
        }
        try {
            if (this.linuxContainerRuntime == null) {
                DelegatingLinuxContainerRuntime runtime = new DelegatingLinuxContainerRuntime();
                runtime.initialize(conf, this.nmContext);
                this.linuxContainerRuntime = runtime;
            }
        }
        catch (ContainerExecutionException e) {
            LOG.error("Failed to initialize linux container runtime(s)!", (Throwable)((Object)e));
            throw new IOException("Failed to initialize linux container runtime(s)!");
        }
        this.resourcesHandler.init(this);
    }

    @Override
    public void start() {
        super.start();
        this.linuxContainerRuntime.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.linuxContainerRuntime.stop();
    }

    @Override
    public void startLocalizer(LocalizerStartContext ctx) throws IOException, InterruptedException {
        Path nmPrivateContainerTokensPath = ctx.getNmPrivateContainerTokens();
        InetSocketAddress nmAddr = ctx.getNmAddr();
        String user = ctx.getUser();
        String appId = ctx.getAppId();
        String locId = ctx.getLocId();
        LocalDirsHandlerService dirsHandler = ctx.getDirsHandler();
        List<String> localDirs = dirsHandler.getLocalDirs();
        List<String> logDirs = dirsHandler.getLogDirs();
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        PrivilegedOperation initializeContainerOp = new PrivilegedOperation(PrivilegedOperation.OperationType.INITIALIZE_CONTAINER);
        ArrayList<String> prefixCommands = new ArrayList<String>();
        this.addSchedPriorityCommand(prefixCommands);
        initializeContainerOp.appendArgs(runAsUser, user, Integer.toString(PrivilegedOperation.RunAsUserCommand.INITIALIZE_CONTAINER.getValue()), appId, locId, nmPrivateContainerTokensPath.toUri().getPath().toString(), StringUtils.join((char)'%', localDirs), StringUtils.join((char)'%', logDirs));
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
        initializeContainerOp.appendArgs(jvm.toString());
        initializeContainerOp.appendArgs("-classpath");
        initializeContainerOp.appendArgs(System.getProperty("java.class.path"));
        String javaLibPath = System.getProperty("java.library.path");
        if (javaLibPath != null) {
            initializeContainerOp.appendArgs("-Djava.library.path=" + javaLibPath);
        }
        initializeContainerOp.appendArgs(ContainerLocalizer.getJavaOpts(this.getConf()));
        List<String> localizerArgs = new ArrayList<String>();
        this.buildMainArgs(localizerArgs, user, appId, locId, nmAddr, nmPrivateContainerTokensPath.getName(), localDirs);
        Path containerLogDir = this.getContainerLogDir(dirsHandler, appId, locId);
        localizerArgs = this.replaceWithContainerLogDir(localizerArgs, containerLogDir);
        initializeContainerOp.appendArgs(localizerArgs);
        try {
            Configuration conf = super.getConf();
            PrivilegedOperationExecutor privilegedOperationExecutor = this.getPrivilegedOperationExecutor();
            privilegedOperationExecutor.executePrivilegedOperation(prefixCommands, initializeContainerOp, null, null, false, true);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.warn("Exit code from container {} startLocalizer is : {}", new Object[]{locId, exitCode, e});
            throw new IOException("Application " + appId + " initialization failed (exitCode=" + exitCode + ") with output: " + e.getOutput(), (Throwable)((Object)e));
        }
    }

    private List<String> replaceWithContainerLogDir(List<String> commands, Path containerLogDir) {
        ArrayList<String> newCmds = new ArrayList<String>(commands.size());
        for (String item : commands) {
            newCmds.add(item.replace("<LOG_DIR>", containerLogDir.toString()));
        }
        return newCmds;
    }

    private Path getContainerLogDir(LocalDirsHandlerService dirsHandler, String appId, String containerId) throws IOException {
        String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appId, containerId);
        return dirsHandler.getLogPathForWrite(relativeContainerLogDir, false);
    }

    @VisibleForTesting
    public void buildMainArgs(List<String> command, String user, String appId, String locId, InetSocketAddress nmAddr, String tokenFileName, List<String> localDirs) {
        ContainerLocalizer.buildMainArgs(command, user, appId, locId, nmAddr, tokenFileName, localDirs, super.getConf());
    }

    @Override
    public void prepareContainer(ContainerPrepareContext ctx) throws IOException {
        ContainerRuntimeContext.Builder builder = new ContainerRuntimeContext.Builder(ctx.getContainer());
        builder.setExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES, ctx.getLocalizedResources()).setExecutionAttribute(LinuxContainerRuntimeConstants.USER, ctx.getUser()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOCAL_DIRS, ctx.getContainerLocalDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_RUN_CMDS, ctx.getCommands()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR, ctx.getContainer().getContainerId().toString());
        try {
            this.linuxContainerRuntime.prepareContainer(builder.build());
        }
        catch (ContainerExecutionException e) {
            throw new IOException("Unable to prepare container: ", (Throwable)((Object)e));
        }
    }

    @Override
    public int launchContainer(ContainerStartContext ctx) throws IOException, ConfigurationException {
        return this.handleLaunchForLaunchType(ctx, ApplicationConstants.ContainerLaunchType.LAUNCH);
    }

    @Override
    public int relaunchContainer(ContainerStartContext ctx) throws IOException, ConfigurationException {
        return this.handleLaunchForLaunchType(ctx, ApplicationConstants.ContainerLaunchType.RELAUNCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleLaunchForLaunchType(ContainerStartContext ctx, ApplicationConstants.ContainerLaunchType type) throws IOException, ConfigurationException {
        block19: {
            List<String> numaArgs;
            String tcCommandFile;
            String resourcesOptions;
            ContainerId containerId;
            Container container;
            block18: {
                container = ctx.getContainer();
                String user = ctx.getUser();
                this.verifyUsernamePattern(user);
                containerId = container.getContainerId();
                this.resourcesHandler.preExecute(containerId, container.getResource());
                resourcesOptions = this.resourcesHandler.getResourcesOption(containerId);
                tcCommandFile = null;
                numaArgs = null;
                try {
                    List<PrivilegedOperation> ops;
                    if (this.resourceHandlerChain == null || (ops = this.resourceHandlerChain.preStart(container)) == null) break block18;
                    ArrayList<PrivilegedOperation> resourceOps = new ArrayList<PrivilegedOperation>();
                    resourceOps.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, resourcesOptions));
                    block14: for (PrivilegedOperation op : ops) {
                        switch (op.getOperationType()) {
                            case ADD_PID_TO_CGROUP: {
                                resourceOps.add(op);
                                continue block14;
                            }
                            case TC_MODIFY_STATE: {
                                tcCommandFile = op.getArguments().get(0);
                                continue block14;
                            }
                            case ADD_NUMA_PARAMS: {
                                numaArgs = op.getArguments();
                                continue block14;
                            }
                        }
                        LOG.warn("PrivilegedOperation type unsupported in launch: {}", (Object)op.getOperationType());
                    }
                    if (resourceOps.size() <= 1) break block18;
                    try {
                        PrivilegedOperation operation = PrivilegedOperationExecutor.squashCGroupOperations(resourceOps);
                        resourcesOptions = operation.getArguments().get(0);
                    }
                    catch (PrivilegedOperationException e) {
                        LOG.error("Failed to squash cgroup operations!", (Throwable)((Object)e));
                        throw new ResourceHandlerException("Failed to squash cgroup operations!");
                    }
                }
                catch (ResourceHandlerException e) {
                    LOG.error("ResourceHandlerChain.preStart() failed!", (Throwable)((Object)e));
                    throw new IOException("ResourceHandlerChain.preStart() failed!", (Throwable)((Object)e));
                }
            }
            try {
                Path pidFilePath = this.getPidFilePath(containerId);
                if (pidFilePath != null) {
                    ContainerRuntimeContext runtimeContext = this.buildContainerRuntimeContext(ctx, pidFilePath, resourcesOptions, tcCommandFile, numaArgs);
                    if (type.equals((Object)ApplicationConstants.ContainerLaunchType.RELAUNCH)) {
                        this.linuxContainerRuntime.relaunchContainer(runtimeContext);
                    } else {
                        this.linuxContainerRuntime.launchContainer(runtimeContext);
                    }
                    break block19;
                }
                LOG.info("Container was marked as inactive. Returning terminated error");
                int n = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
                return n;
            }
            catch (ContainerExecutionException e) {
                int n = this.handleExitCode(e, container, containerId);
                return n;
            }
            finally {
                this.resourcesHandler.postExecute(containerId);
                this.postComplete(containerId);
            }
        }
        return 0;
    }

    private int handleExitCode(ContainerExecutionException e, Container container, ContainerId containerId) throws ConfigurationException {
        int exitCode = e.getExitCode();
        LOG.warn("Exit code from container {} is : {}", (Object)containerId, (Object)exitCode);
        if (exitCode != ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() && exitCode != ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            String output;
            LOG.warn("Exception from container-launch with container ID: {} and exit code: {}", new Object[]{containerId, exitCode, e});
            StringBuilder builder = new StringBuilder();
            builder.append("Exception from container-launch.\n").append("Container id: " + containerId + "\n").append("Exit code: " + exitCode + "\n").append("Exception message: " + e.getMessage() + "\n");
            if (!Optional.ofNullable(e.getErrorOutput()).orElse("").isEmpty()) {
                builder.append("Shell error output: " + e.getErrorOutput() + "\n");
            }
            if ((output = e.getOutput()) != null && !output.isEmpty()) {
                builder.append("Shell output: " + output + "\n");
            }
            String diagnostics = builder.toString();
            this.logOutput(diagnostics);
            container.handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, diagnostics));
            if (exitCode == ExitCode.INVALID_CONTAINER_EXEC_PERMISSIONS.getExitCode() || exitCode == ExitCode.INVALID_CONFIG_FILE.getExitCode()) {
                throw new ConfigurationException("Linux Container Executor reached unrecoverable exception", (Throwable)((Object)e));
            }
        } else {
            container.handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, "Container killed on request. Exit code is " + exitCode));
        }
        return exitCode;
    }

    private ContainerRuntimeContext buildContainerRuntimeContext(ContainerStartContext ctx, Path pidFilePath, String resourcesOptions, String tcCommandFile, List<String> numaArgs) {
        ArrayList<String> prefixCommands = new ArrayList<String>();
        this.addSchedPriorityCommand(prefixCommands);
        this.addNumaArgsToCommand(prefixCommands, numaArgs);
        Container container = ctx.getContainer();
        ContainerRuntimeContext.Builder builder = new ContainerRuntimeContext.Builder(container);
        if (prefixCommands.size() > 0) {
            builder.setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LAUNCH_PREFIX_COMMANDS, prefixCommands);
        }
        builder.setExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES, ctx.getLocalizedResources()).setExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER, this.getRunAsUser(ctx.getUser())).setExecutionAttribute(LinuxContainerRuntimeConstants.USER, ctx.getUser()).setExecutionAttribute(LinuxContainerRuntimeConstants.APPID, ctx.getAppId()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR, container.getContainerId().toString()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR, ctx.getContainerWorkDir()).setExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH, ctx.getNmPrivateContainerScriptPath()).setExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH, ctx.getNmPrivateTokensPath()).setExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_KEYSTORE_PATH, ctx.getNmPrivateKeystorePath()).setExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TRUSTSTORE_PATH, ctx.getNmPrivateTruststorePath()).setExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH, pidFilePath).setExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS, ctx.getLocalDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS, ctx.getLogDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.FILECACHE_DIRS, ctx.getFilecacheDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.USER_LOCAL_DIRS, ctx.getUserLocalDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOCAL_DIRS, ctx.getContainerLocalDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.USER_FILECACHE_DIRS, ctx.getUserFilecacheDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.APPLICATION_LOCAL_DIRS, ctx.getApplicationLocalDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOG_DIRS, ctx.getContainerLogDirs()).setExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS, resourcesOptions);
        if (tcCommandFile != null) {
            builder.setExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE, tcCommandFile);
        }
        return builder.build();
    }

    @Override
    public String[] getIpAndHost(Container container) throws ContainerExecutionException {
        return this.linuxContainerRuntime.getIpAndHost(container);
    }

    private void addNumaArgsToCommand(List<String> prefixCommands, List<String> numaArgs) {
        if (numaArgs != null) {
            prefixCommands.addAll(numaArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reacquireContainer(ContainerReacquisitionContext ctx) throws IOException, InterruptedException {
        ContainerId containerId = ctx.getContainerId();
        try {
            if (this.resourceHandlerChain != null) {
                try {
                    this.resourceHandlerChain.reacquireContainer(containerId);
                }
                catch (ResourceHandlerException e) {
                    LOG.warn("ResourceHandlerChain.reacquireContainer failed for containerId: {} Exception: ", (Object)containerId, (Object)e);
                }
            }
            int n = super.reacquireContainer(ctx);
            return n;
        }
        finally {
            this.resourcesHandler.postExecute(containerId);
            this.postComplete(containerId);
        }
    }

    @Override
    public boolean signalContainer(ContainerSignalContext ctx) throws IOException {
        Container container = ctx.getContainer();
        String user = ctx.getUser();
        String pid = ctx.getPid();
        ContainerExecutor.Signal signal = ctx.getSignal();
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        ContainerRuntimeContext runtimeContext = new ContainerRuntimeContext.Builder(container).setExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER, runAsUser).setExecutionAttribute(LinuxContainerRuntimeConstants.USER, user).setExecutionAttribute(LinuxContainerRuntimeConstants.PID, pid).setExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL, signal).build();
        try {
            this.linuxContainerRuntime.signalContainer(runtimeContext);
        }
        catch (ContainerExecutionException e) {
            int retCode = e.getExitCode();
            if (retCode == PrivilegedOperation.ResultCode.INVALID_CONTAINER_PID.getValue()) {
                return false;
            }
            LOG.warn("Error in signalling container {} with {}; exit = {}", new Object[]{pid, signal, retCode, e});
            this.logOutput(e.getOutput());
            if (retCode == ContainerExecutionException.getDefaultExitCode()) {
                throw new InterruptedIOException("Signalling container " + pid + " with " + signal + " is interrupted; output: " + e.getOutput() + " and exitCode: " + retCode);
            }
            throw new IOException("Problem signalling container " + pid + " with " + signal + "; output: " + e.getOutput() + " and exitCode: " + retCode, (Throwable)((Object)e));
        }
        return true;
    }

    @Override
    public boolean reapContainer(ContainerReapContext ctx) throws IOException {
        Container container = ctx.getContainer();
        String user = ctx.getUser();
        String runAsUser = this.getRunAsUser(user);
        ContainerRuntimeContext runtimeContext = new ContainerRuntimeContext.Builder(container).setExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER, runAsUser).setExecutionAttribute(LinuxContainerRuntimeConstants.USER, user).build();
        try {
            this.linuxContainerRuntime.reapContainer(runtimeContext);
        }
        catch (ContainerExecutionException e) {
            int retCode = e.getExitCode();
            if (retCode != 0) {
                boolean bl = false;
                return bl;
            }
            LOG.warn("Error in reaping container {} exit = {}", new Object[]{container.getContainerId(), retCode, e});
            this.logOutput(e.getOutput());
            throw new IOException("Error in reaping container " + container.getContainerId().toString() + " exit = " + retCode, (Throwable)((Object)e));
        }
        finally {
            this.postComplete(container.getContainerId());
        }
        return true;
    }

    @Override
    public IOStreamPair execContainer(ContainerExecContext ctx) throws ContainerExecutionException {
        IOStreamPair res;
        try {
            res = this.linuxContainerRuntime.execContainer(ctx);
        }
        catch (ContainerExecutionException e) {
            int retCode = e.getExitCode();
            if (retCode != 0) {
                return new IOStreamPair(null, null);
            }
            LOG.warn("Error in executing container interactive shell {} exit = {}", new Object[]{ctx, retCode, e});
            this.logOutput(e.getOutput());
            throw new ContainerExecutionException("Error in executing container interactive shel" + ctx.getContainer().getContainerId().toString() + " exit = " + retCode);
        }
        return res;
    }

    @Override
    public void deleteAsUser(DeletionAsUserContext ctx) {
        String user = ctx.getUser();
        Path dir = ctx.getSubDir();
        List<Path> baseDirs = ctx.getBasedirs();
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        String dirString = dir == null ? "" : dir.toUri().getPath();
        PrivilegedOperation deleteAsUserOp = new PrivilegedOperation(PrivilegedOperation.OperationType.DELETE_AS_USER, (String)null);
        deleteAsUserOp.appendArgs(runAsUser, user, Integer.toString(PrivilegedOperation.RunAsUserCommand.DELETE_AS_USER.getValue()), dirString);
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        if (baseDirs == null || baseDirs.size() == 0) {
            LOG.info("Deleting absolute path : {}", (Object)dir);
            pathsToDelete.add(dirString);
        } else {
            for (Path baseDir : baseDirs) {
                Path del = dir == null ? baseDir : new Path(baseDir, dir);
                LOG.info("Deleting path : {}", (Object)del);
                pathsToDelete.add(del.toString());
                deleteAsUserOp.appendArgs(baseDir.toUri().getPath());
            }
        }
        try {
            Configuration conf = super.getConf();
            PrivilegedOperationExecutor privilegedOperationExecutor = this.getPrivilegedOperationExecutor();
            privilegedOperationExecutor.executePrivilegedOperation(deleteAsUserOp, false);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.error("DeleteAsUser for {} returned with exit code: {}", new Object[]{StringUtils.join((CharSequence)" ", pathsToDelete), exitCode, e});
        }
    }

    @Override
    protected File[] readDirAsUser(String user, Path dir) {
        ArrayList<File> files = new ArrayList<File>();
        PrivilegedOperation listAsUserOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LIST_AS_USER, (String)null);
        String runAsUser = this.getRunAsUser(user);
        String dirString = "";
        if (dir != null) {
            dirString = dir.toUri().getPath();
        }
        listAsUserOp.appendArgs(runAsUser, user, Integer.toString(PrivilegedOperation.RunAsUserCommand.LIST_AS_USER.getValue()), dirString);
        try {
            PrivilegedOperationExecutor privOpExecutor = this.getPrivilegedOperationExecutor();
            String results = privOpExecutor.executePrivilegedOperation(listAsUserOp, true);
            for (String file : results.split("\n")) {
                if (file.startsWith("main :")) continue;
                files.add(new File(new File(dirString), file));
            }
        }
        catch (PrivilegedOperationException e) {
            LOG.error("ListAsUser for {} returned with exit code: {}", new Object[]{dir, e.getExitCode(), e});
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public void symLink(String target, String symlink) {
    }

    @Override
    public boolean isContainerAlive(ContainerLivenessContext ctx) throws IOException {
        String user = ctx.getUser();
        String pid = ctx.getPid();
        Container container = ctx.getContainer();
        return this.signalContainer(new ContainerSignalContext.Builder().setContainer(container).setUser(user).setPid(pid).setSignal(ContainerExecutor.Signal.NULL).build());
    }

    public void mountCgroups(List<String> cgroupKVs, String hierarchy) throws IOException {
        try {
            PrivilegedOperation mountCGroupsOp = new PrivilegedOperation(PrivilegedOperation.OperationType.MOUNT_CGROUPS, hierarchy);
            Configuration conf = super.getConf();
            mountCGroupsOp.appendArgs(cgroupKVs);
            PrivilegedOperationExecutor privilegedOperationExecutor = this.getPrivilegedOperationExecutor();
            privilegedOperationExecutor.executePrivilegedOperation(mountCGroupsOp, false);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.warn("Exception in LinuxContainerExecutor mountCgroups ", (Throwable)((Object)e));
            throw new IOException("Problem mounting cgroups " + cgroupKVs + "; exit code = " + exitCode + " and output: " + e.getOutput(), (Throwable)((Object)e));
        }
    }

    @VisibleForTesting
    public ResourceHandler getResourceHandler() {
        return this.resourceHandlerChain;
    }

    public void removeDockerContainer(String containerId) {
        try {
            PrivilegedOperationExecutor privOpExecutor = PrivilegedOperationExecutor.getInstance(super.getConf());
            if (DockerCommandExecutor.isRemovable(DockerCommandExecutor.getContainerStatus(containerId, privOpExecutor, this.nmContext))) {
                LOG.info("Removing Docker container : {}", (Object)containerId);
                DockerRmCommand dockerRmCommand = new DockerRmCommand(containerId, ResourceHandlerModule.getCgroupsRelativeRoot());
                DockerCommandExecutor.executeDockerCommand(dockerRmCommand, containerId, null, privOpExecutor, false, this.nmContext);
            }
        }
        catch (ContainerExecutionException e) {
            LOG.warn("Unable to remove docker container: {}", (Object)containerId);
        }
    }

    @VisibleForTesting
    void postComplete(ContainerId containerId) {
        try {
            if (this.resourceHandlerChain != null) {
                LOG.debug("{} post complete", (Object)containerId);
                this.resourceHandlerChain.postComplete(containerId);
            }
        }
        catch (ResourceHandlerException e) {
            LOG.warn("ResourceHandlerChain.postComplete failed for containerId: {}. Exception: ", (Object)containerId, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateYarnSysFS(Context ctx, String user, String appId, String spec) throws IOException {
        LocalDirsHandlerService dirsHandler = this.nmContext.getLocalDirsHandler();
        Path sysFSPath = dirsHandler.getLocalPathForWrite("nmPrivate/" + appId + "/sysfs/app.json");
        File file = new File(sysFSPath.toString());
        List<String> localDirs = dirsHandler.getLocalDirs();
        if (file.exists() && !file.delete()) {
            LOG.warn("Unable to delete {}", (Object)sysFSPath);
        }
        if (file.createNewFile()) {
            try (FileOutputStream output = new FileOutputStream(file);){
                output.write(spec.getBytes(StandardCharsets.UTF_8));
            }
        }
        PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SYNC_YARN_SYSFS);
        String runAsUser = this.getRunAsUser(user);
        privOp.appendArgs(runAsUser, user, Integer.toString(PrivilegedOperation.RunAsUserCommand.SYNC_YARN_SYSFS.getValue()), appId, StringUtils.join((char)'%', localDirs));
        privOp.disableFailureLogging();
        PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(this.nmContext.getConf());
        try {
            privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    @Override
    public String getExposedPorts(Container container) throws ContainerExecutionException {
        return this.linuxContainerRuntime.getExposedPorts(container);
    }

    @Override
    public Map<String, LocalResource> getLocalResources(Container container) throws IOException {
        return this.linuxContainerRuntime.getLocalResources(container);
    }

    public static enum ExitCode {
        SUCCESS(0),
        INVALID_ARGUMENT_NUMBER(1),
        INVALID_COMMAND_PROVIDED(3),
        INVALID_NM_ROOT_DIRS(5),
        SETUID_OPER_FAILED(6),
        UNABLE_TO_EXECUTE_CONTAINER_SCRIPT(7),
        UNABLE_TO_SIGNAL_CONTAINER(8),
        INVALID_CONTAINER_PID(9),
        OUT_OF_MEMORY(18),
        INITIALIZE_USER_FAILED(20),
        PATH_TO_DELETE_IS_NULL(21),
        INVALID_CONTAINER_EXEC_PERMISSIONS(22),
        INVALID_CONFIG_FILE(24),
        SETSID_OPER_FAILED(25),
        WRITE_PIDFILE_FAILED(26),
        WRITE_CGROUP_FAILED(27),
        TRAFFIC_CONTROL_EXECUTION_FAILED(28),
        DOCKER_RUN_FAILED(29),
        ERROR_OPENING_DOCKER_FILE(30),
        ERROR_READING_DOCKER_FILE(31),
        FEATURE_DISABLED(32),
        COULD_NOT_CREATE_SCRIPT_COPY(33),
        COULD_NOT_CREATE_CREDENTIALS_FILE(34),
        COULD_NOT_CREATE_WORK_DIRECTORIES(35),
        COULD_NOT_CREATE_APP_LOG_DIRECTORIES(36),
        COULD_NOT_CREATE_TMP_DIRECTORIES(37),
        ERROR_CREATE_CONTAINER_DIRECTORIES_ARGUMENTS(38),
        CANNOT_GET_EXECUTABLE_NAME_FROM_READLINK(80),
        TOO_LONG_EXECUTOR_PATH(81),
        CANNOT_GET_EXECUTABLE_NAME_FROM_KERNEL(82),
        CANNOT_GET_EXECUTABLE_NAME_FROM_PID(83),
        WRONG_PATH_OF_EXECUTABLE(84);

        private final int code;

        private ExitCode(int exitCode) {
            this.code = exitCode;
        }

        public int getExitCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }
}

