/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.webapp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GlobalPolicyGenerator;
import org.apache.hadoop.yarn.server.globalpolicygenerator.webapp.GPGController;
import org.apache.hadoop.yarn.server.globalpolicygenerator.webapp.GPGWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class GPGWebApp
extends WebApp {
    private GlobalPolicyGenerator gpg;

    public GPGWebApp(GlobalPolicyGenerator gpg) {
        this.gpg = gpg;
    }

    public void setup() {
        this.bind(GPGWebApp.class).toInstance((Object)this);
        if (this.gpg != null) {
            this.bind(GlobalPolicyGenerator.class).toInstance((Object)this.gpg);
        }
        this.route("/", GPGController.class, "overview");
        this.route("/policies", GPGController.class, "policies");
    }

    public ResourceConfig resourceConfig() {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.apache.hadoop.yarn.server.globalpolicygenerator.webapp"});
        config.register((Object)new JerseyBinder());
        config.register(GPGWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            ((InstanceBinding)this.bind((Object)GPGWebApp.this.gpg).to(GlobalPolicyGenerator.class)).named("gpg");
            ((InstanceBinding)this.bind(GPGWebApp.this.gpg.getConfig()).to(Configuration.class)).named("conf");
        }
    }
}

