/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.webapp;

import com.google.inject.Inject;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GlobalPolicyGenerator;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class GPGOverviewBlock
extends HtmlBlock {
    private GlobalPolicyGenerator globalPolicyGenerator;

    @Inject
    GPGOverviewBlock(GlobalPolicyGenerator gpg, View.ViewContext ctx) {
        super(ctx);
        this.globalPolicyGenerator = gpg;
    }

    protected void render(HtmlBlock.Block html) {
        Configuration config = this.globalPolicyGenerator.getConfig();
        Object appCleaner = "disable";
        long appCleanerIntervalMs = config.getTimeDuration("yarn.federation.gpg.application.cleaner.interval-ms", YarnConfiguration.DEFAULT_GPG_APPCLEANER_INTERVAL_MS, TimeUnit.MILLISECONDS);
        if (appCleanerIntervalMs > 0L) {
            appCleaner = "enable, interval : " + appCleanerIntervalMs + " ms";
        }
        Object scCleaner = "disable";
        long scCleanerIntervalMs = config.getTimeDuration("yarn.federation.gpg.subcluster.cleaner.interval-ms", YarnConfiguration.DEFAULT_GPG_SUBCLUSTER_CLEANER_INTERVAL_MS, TimeUnit.MILLISECONDS);
        if (scCleanerIntervalMs > 0L) {
            scCleaner = "enable, interval : " + scCleanerIntervalMs + " ms";
        }
        Object pgGenerator = "disable";
        long policyGeneratorIntervalMillis = config.getTimeDuration("yarn.federation.gpg.policy.generator.interval", YarnConfiguration.DEFAULT_GPG_POLICY_GENERATOR_INTERVAL, TimeUnit.MILLISECONDS);
        if (policyGeneratorIntervalMillis > 0L) {
            pgGenerator = "enable, interval : " + policyGeneratorIntervalMillis + " ms";
        }
        String policy = config.get("yarn.federation.gpg.policy.generator.class", "org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator.NoOpGlobalPolicy");
        this.info("GPG Details").__("GPG started on", (Object)new Date(GlobalPolicyGenerator.getGPGStartupTime())).__("GPG application cleaner", appCleaner).__("GPG subcluster cleaner", scCleaner).__("GPG policy generator", pgGenerator).__("GPG policy generator class", (Object)policy).__("GPG Version", (Object)YarnVersionInfo.getVersion()).__("Hadoop Version", (Object)VersionInfo.getVersion());
        html.__(InfoBlock.class);
    }
}

