/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.utils.FederationRegistryClient;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGContext;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGContextImpl;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGPolicyFacade;
import org.apache.hadoop.yarn.server.globalpolicygenerator.applicationcleaner.ApplicationCleaner;
import org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator.PolicyGenerator;
import org.apache.hadoop.yarn.server.globalpolicygenerator.subclustercleaner.SubClusterCleaner;
import org.apache.hadoop.yarn.server.globalpolicygenerator.webapp.GPGWebApp;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.util.WebServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPolicyGenerator
extends CompositeService {
    public static final Logger LOG = LoggerFactory.getLogger(GlobalPolicyGenerator.class);
    private static CompositeService.CompositeServiceShutdownHook gpgShutdownHook;
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private AtomicBoolean isStopping = new AtomicBoolean(false);
    private static final String METRICS_NAME = "Global Policy Generator";
    private static long gpgStartupTime;
    private GPGContext gpgContext = new GPGContextImpl();
    private RegistryOperations registry;
    private ScheduledThreadPoolExecutor scheduledExecutorService;
    private SubClusterCleaner subClusterCleaner;
    private ApplicationCleaner applicationCleaner;
    private PolicyGenerator policyGenerator;
    private String webAppAddress;
    private JvmPauseMonitor pauseMonitor;
    private WebApp webApp;

    public GlobalPolicyGenerator() {
        super(GlobalPolicyGenerator.class.getName());
    }

    protected void doSecureLogin() throws IOException {
        Configuration config = this.getConfig();
        SecurityUtil.login((Configuration)config, (String)"yarn.federation.gpg.keytab.file", (String)"yarn.federation.gpg.kerberos.principal", (String)this.getHostName(config));
    }

    protected void initAndStart(Configuration conf, boolean hasToReboot) {
        if (hasToReboot && null != gpgShutdownHook) {
            ShutdownHookManager.get().removeShutdownHook((Runnable)gpgShutdownHook);
        }
        gpgShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)this);
        ShutdownHookManager.get().addShutdownHook((Runnable)gpgShutdownHook, 30);
        this.init(conf);
        this.start();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.gpgContext.setStateStoreFacade(FederationStateStoreFacade.getInstance((Configuration)conf));
        GPGPolicyFacade gpgPolicyFacade = new GPGPolicyFacade(this.gpgContext.getStateStoreFacade(), conf);
        this.gpgContext.setPolicyFacade(gpgPolicyFacade);
        this.registry = (RegistryOperations)FederationStateStoreFacade.createInstance((Configuration)conf, (String)"yarn.registry.class", (String)"org.apache.hadoop.registry.client.impl.FSRegistryOperationsService", RegistryOperations.class);
        this.registry.init(conf);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        FederationRegistryClient registryClient = new FederationRegistryClient(conf, this.registry, user);
        this.gpgContext.setRegistryClient(registryClient);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(conf.getInt("yarn.federation.gpg.scheduled.executor.threads", 10));
        this.subClusterCleaner = new SubClusterCleaner(conf, this.gpgContext);
        this.applicationCleaner = (ApplicationCleaner)FederationStateStoreFacade.createInstance((Configuration)conf, (String)"yarn.federation.gpg.application.cleaner.class", (String)"org.apache.hadoop.yarn.server.globalpolicygenerator.applicationcleaner.DefaultApplicationCleaner", ApplicationCleaner.class);
        this.applicationCleaner.init(conf, this.gpgContext);
        this.policyGenerator = new PolicyGenerator(conf, this.gpgContext);
        this.webAppAddress = WebAppUtils.getGPGWebAppURLWithoutScheme((Configuration)conf);
        DefaultMetricsSystem.initialize((String)METRICS_NAME);
        JvmMetrics jm = JvmMetrics.initSingleton((String)"GPG", null);
        this.pauseMonitor = new JvmPauseMonitor();
        this.addService((Service)this.pauseMonitor);
        jm.setPauseMonitor(this.pauseMonitor);
        super.serviceInit(conf);
        WebServiceClient.initialize((Configuration)conf);
    }

    protected void serviceStart() throws Exception {
        long appCleanerIntervalMs;
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed GPG login", (Throwable)e);
        }
        super.serviceStart();
        this.registry.start();
        Configuration config = this.getConfig();
        long scCleanerIntervalMs = config.getTimeDuration("yarn.federation.gpg.subcluster.cleaner.interval-ms", YarnConfiguration.DEFAULT_GPG_SUBCLUSTER_CLEANER_INTERVAL_MS, TimeUnit.MILLISECONDS);
        if (scCleanerIntervalMs > 0L) {
            this.scheduledExecutorService.scheduleAtFixedRate(this.subClusterCleaner, 0L, scCleanerIntervalMs, TimeUnit.MILLISECONDS);
            LOG.info("Scheduled sub-cluster cleaner with interval: {}", (Object)DurationFormatUtils.formatDurationISO((long)scCleanerIntervalMs));
        }
        if ((appCleanerIntervalMs = config.getTimeDuration("yarn.federation.gpg.application.cleaner.interval-ms", YarnConfiguration.DEFAULT_GPG_APPCLEANER_INTERVAL_MS, TimeUnit.MILLISECONDS)) > 0L) {
            this.scheduledExecutorService.scheduleAtFixedRate(this.applicationCleaner, 0L, appCleanerIntervalMs, TimeUnit.MILLISECONDS);
            LOG.info("Scheduled application cleaner with interval: {}", (Object)DurationFormatUtils.formatDurationISO((long)appCleanerIntervalMs));
        }
        long policyGeneratorIntervalMillis = 0L;
        String generatorIntervalMS = config.get("yarn.federation.gpg.policy.generator.interval-ms");
        if (generatorIntervalMS != null) {
            LOG.warn("yarn.federation.gpg.policy.generator.interval-ms is deprecated property,  we better set it yarn.federation.gpg.policy.generator.interval.");
            policyGeneratorIntervalMillis = Long.parseLong(generatorIntervalMS);
        }
        if (policyGeneratorIntervalMillis == 0L) {
            policyGeneratorIntervalMillis = config.getTimeDuration("yarn.federation.gpg.policy.generator.interval", YarnConfiguration.DEFAULT_GPG_POLICY_GENERATOR_INTERVAL, TimeUnit.MILLISECONDS);
        }
        if (policyGeneratorIntervalMillis > 0L) {
            this.scheduledExecutorService.scheduleAtFixedRate(this.policyGenerator, 0L, policyGeneratorIntervalMillis, TimeUnit.MILLISECONDS);
            LOG.info("Scheduled policy-generator with interval: {}", (Object)DurationFormatUtils.formatDurationISO((long)policyGeneratorIntervalMillis));
        }
        this.startWepApp();
    }

    protected void serviceStop() throws Exception {
        if (this.registry != null) {
            this.registry.stop();
            this.registry = null;
        }
        try {
            if (this.scheduledExecutorService != null && !this.scheduledExecutorService.isShutdown()) {
                this.scheduledExecutorService.shutdown();
                LOG.info("Stopped ScheduledExecutorService");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to shutdown ScheduledExecutorService", (Throwable)e);
            throw e;
        }
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
        WebServiceClient.destroy();
    }

    public String getName() {
        return "FederationGlobalPolicyGenerator";
    }

    public GPGContext getGPGContext() {
        return this.gpgContext;
    }

    @VisibleForTesting
    public void startWepApp() {
        Configuration configuration = this.getConfig();
        boolean enableCors = configuration.getBoolean("yarn.federation.gpg.webapp.cross-origin.enabled", false);
        if (enableCors) {
            configuration.setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        boolean hasHadoopAuthFilterInitializer = false;
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        Class[] initializersClasses = configuration.getClasses(filterInitializerConfKey, new Class[0]);
        ArrayList<String> targets = new ArrayList<String>();
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                    break;
                }
                targets.add(initializer.getName());
            }
        }
        if (!hasHadoopAuthFilterInitializer) {
            targets.add(AuthenticationFilterInitializer.class.getName());
            configuration.set(filterInitializerConfKey, StringUtils.join((CharSequence)",", targets));
        }
        LOG.info("Instantiating GPGWebApp at {}.", (Object)this.webAppAddress);
        GPGWebApp gpgWebApp = new GPGWebApp(this);
        this.webApp = WebApps.$for((String)"gpg", GPGContext.class, (Object)this.gpgContext, (String)"gpg-ws").at(this.webAppAddress).withResourceConfig(gpgWebApp.resourceConfig()).start((WebApp)gpgWebApp);
    }

    public static void startGPG(String[] argv, Configuration conf) {
        boolean federationEnabled = conf.getBoolean("yarn.federation.enabled", false);
        if (federationEnabled) {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            StringUtils.startupShutdownMessage(GlobalPolicyGenerator.class, (String[])argv, (Logger)LOG);
            GlobalPolicyGenerator globalPolicyGenerator = new GlobalPolicyGenerator();
            globalPolicyGenerator.initAndStart(conf, false);
        } else {
            LOG.warn("Federation is not enabled. The gpg cannot start.");
        }
    }

    private String getHostName(Configuration config) throws UnknownHostException {
        String name = config.get("yarn.federation.gpg.kerberos.principal.hostname");
        if (name == null) {
            name = InetAddress.getLocalHost().getHostName();
        }
        return name;
    }

    public static void main(String[] argv) {
        try {
            YarnConfiguration conf = new YarnConfiguration();
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            argv = hParser.getRemainingArgs();
            if (argv.length > 1) {
                if (argv[0].equals("-format-policy-store")) {
                    GlobalPolicyGenerator.handFormatPolicyStateStore((Configuration)conf);
                } else {
                    GlobalPolicyGenerator.printUsage(System.err);
                }
            } else {
                GlobalPolicyGenerator.startGPG(argv, (Configuration)conf);
            }
        }
        catch (Throwable t) {
            LOG.error("Error starting global policy generator", t);
            System.exit(-1);
        }
    }

    public static long getGPGStartupTime() {
        return gpgStartupTime;
    }

    @VisibleForTesting
    public WebApp getWebApp() {
        return this.webApp;
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: yarn gpg [-format-policy-store]");
    }

    private static void handFormatPolicyStateStore(Configuration conf) {
        try {
            System.out.println("Deleting Federation policy state store.");
            FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)conf);
            System.out.println("Federation policy state store has been cleaned.");
            facade.deleteAllPoliciesConfigurations();
        }
        catch (Exception e) {
            LOG.error("Delete Federation policy state store error.", (Throwable)e);
            System.err.println("Delete Federation policy state store error, exception = " + e);
        }
    }

    public void setConfig(Configuration conf) {
        super.setConfig(conf);
    }

    static {
        gpgStartupTime = System.currentTimeMillis();
    }
}

