/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;

public final class GPGUtils {
    private GPGUtils() {
    }

    public static <T> T invokeRMWebService(String webAddr, String path, Class<T> returnType, Configuration conf, String selectParam) {
        Client client = GPGUtils.createJerseyClient(conf);
        InetSocketAddress socketAddress = NetUtils.getConnectAddress((InetSocketAddress)NetUtils.createSocketAddr((String)webAddr));
        String scheme = YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://";
        String webAddress = scheme + socketAddress.getHostName() + ":" + socketAddress.getPort();
        WebTarget webResource = client.target(webAddress);
        if (selectParam != null) {
            webResource = webResource.queryParam("deSelects", new Object[]{selectParam});
        }
        Response response = null;
        try {
            response = (Response)webResource.path("/ws/v1/cluster").path(path).request(new String[]{"application/xml"}).get(Response.class);
            if (response.getStatus() == 200) {
                Object obj;
                Object object = obj = response.readEntity(returnType);
                return (T)object;
            }
            throw new YarnRuntimeException("Bad response from remote web service: " + response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
            client.close();
        }
    }

    public static <T> T invokeRMWebService(String webAddr, String path, Class<T> returnType, Configuration config) {
        return GPGUtils.invokeRMWebService(webAddr, path, returnType, config, null);
    }

    public static Map<SubClusterIdInfo, Float> createUniformWeights(Set<SubClusterId> ids) {
        HashMap<SubClusterIdInfo, Float> weights = new HashMap<SubClusterIdInfo, Float>();
        for (SubClusterId id : ids) {
            weights.put(new SubClusterIdInfo(id), Float.valueOf(1.0f));
        }
        return weights;
    }

    public static Client createJerseyClient(Configuration conf) {
        Client client = ClientBuilder.newClient();
        int connectTimeOut = (int)conf.getTimeDuration("yarn.federation.gpg.webapp.connect-timeout", YarnConfiguration.DEFAULT_GPG_WEBAPP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        client.property("jersey.config.client.connectTimeout", (Object)connectTimeOut);
        int readTimeout = (int)conf.getTimeDuration("yarn.federation.gpg.webapp.read-timeout", YarnConfiguration.DEFAULT_GPG_WEBAPP_READ_TIMEOUT, TimeUnit.MILLISECONDS);
        client.property("jersey.config.client.readTimeout", (Object)readTimeout);
        return client;
    }
}

