/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationGuavaCache
extends FederationCache {
    private static final Logger LOG = LoggerFactory.getLogger(FederationCache.class);
    private Cache<String, FederationCache.CacheRequest<String, ?>> cache;
    private int cacheTimeToLive;
    private long cacheEntityNums;
    private String className = this.getClass().getSimpleName();
    private boolean isCachingEnabled = false;

    @Override
    public boolean isCachingEnabled() {
        return this.isCachingEnabled;
    }

    @Override
    public void initCache(Configuration pConf, FederationStateStore pStateStore) {
        this.cacheTimeToLive = pConf.getInt("yarn.federation.cache-ttl.secs", 300);
        this.cacheEntityNums = pConf.getLong("yarn.federation.cache-entity.nums", 1000L);
        if (this.cacheTimeToLive <= 0) {
            this.isCachingEnabled = false;
            return;
        }
        this.setStateStore(pStateStore);
        LOG.info("Creating a JCache Manager with name {}. Cache TTL Time = {} secs. Cache Entity Nums = {}.", new Object[]{this.className, this.cacheTimeToLive, this.cacheEntityNums});
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheTimeToLive, TimeUnit.SECONDS).maximumSize(this.cacheEntityNums).build();
        this.isCachingEnabled = true;
    }

    @Override
    public void clearCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
        this.cache = null;
    }

    @Override
    public Map<SubClusterId, SubClusterInfo> getSubClusters(boolean filterInactiveSubClusters) throws YarnException {
        String cacheKey = this.buildCacheKey(this.className, "getSubClusters", Boolean.toString(filterInactiveSubClusters));
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterInfo>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterInfo>>)this.cache.getIfPresent((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetSubClustersCacheRequest(this.className, filterInactiveSubClusters);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        return FederationGuavaCache.buildSubClusterInfoMap(cacheRequest);
    }

    @Override
    public Map<String, SubClusterPolicyConfiguration> getPoliciesConfigurations() throws Exception {
        String cacheKey = this.buildCacheKey(this.className, "getPoliciesConfigurations");
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterPolicyConfiguration>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterPolicyConfiguration>>)this.cache.getIfPresent((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetPoliciesConfigurationsCacheRequest(this.className);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        return FederationGuavaCache.buildPolicyConfigMap(cacheRequest);
    }

    @Override
    public SubClusterId getApplicationHomeSubCluster(ApplicationId appId) throws Exception {
        String cacheKey = this.buildCacheKey(this.className, "getApplicationHomeSubCluster", appId.toString());
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterId>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterId>>)this.cache.getIfPresent((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetApplicationHomeSubClusterRequest(this.className, appId);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        FederationCache.CacheResponse response = (FederationCache.CacheResponse)FederationCache.ApplicationHomeSubClusterCacheResponse.class.cast(cacheRequest.getValue());
        return (SubClusterId)response.getItem();
    }

    @Override
    public void removeSubCluster(boolean flushCache) {
        String cacheKey = this.buildCacheKey(this.className, "getSubClusters", Boolean.toString(flushCache));
        this.cache.invalidate((Object)cacheKey);
    }
}

