/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.dao;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@XmlRootElement(name="federation-policy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedPolicyInfo {
    private static final Logger LOG = LoggerFactory.getLogger(WeightedPolicyInfo.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="routerPolicyWeights")
    private Map<SubClusterIdInfo, Float> routerPolicyWeights = new HashMap<SubClusterIdInfo, Float>();
    @JsonProperty(value="amrmPolicyWeights")
    private Map<SubClusterIdInfo, Float> amrmPolicyWeights = new HashMap<SubClusterIdInfo, Float>();
    @JsonProperty(value="headroomAlpha")
    private float headroomAlpha;

    public static WeightedPolicyInfo fromByteBuffer(ByteBuffer bb) throws FederationPolicyInitializationException {
        if (mapper == null) {
            throw new FederationPolicyInitializationException("JSONJAXBContext should not be null.");
        }
        try {
            byte[] bytes = new byte[bb.remaining()];
            bb.get(bytes);
            String params = new String(bytes, StandardCharsets.UTF_8);
            return (WeightedPolicyInfo)mapper.readValue(params, WeightedPolicyInfo.class);
        }
        catch (JsonProcessingException j) {
            throw new FederationPolicyInitializationException(j);
        }
    }

    public Map<SubClusterIdInfo, Float> getRouterPolicyWeights() {
        return this.routerPolicyWeights;
    }

    public void setRouterPolicyWeights(Map<SubClusterIdInfo, Float> policyWeights) {
        this.routerPolicyWeights = policyWeights;
    }

    public Map<SubClusterIdInfo, Float> getAMRMPolicyWeights() {
        return this.amrmPolicyWeights;
    }

    public void setAMRMPolicyWeights(Map<SubClusterIdInfo, Float> policyWeights) {
        this.amrmPolicyWeights = policyWeights;
    }

    public ByteBuffer toByteBuffer() throws FederationPolicyInitializationException {
        if (mapper == null) {
            throw new FederationPolicyInitializationException("JSONJAXBContext should not be null.");
        }
        try {
            String value = mapper.writeValueAsString((Object)this);
            return ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException j) {
            throw new FederationPolicyInitializationException(j);
        }
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        WeightedPolicyInfo otherPolicy = (WeightedPolicyInfo)other;
        Map<SubClusterIdInfo, Float> otherAMRMWeights = otherPolicy.getAMRMPolicyWeights();
        Map<SubClusterIdInfo, Float> otherRouterWeights = otherPolicy.getRouterPolicyWeights();
        boolean amrmWeightsMatch = otherAMRMWeights != null && this.getAMRMPolicyWeights() != null && CollectionUtils.isEqualCollection(otherAMRMWeights.entrySet(), this.getAMRMPolicyWeights().entrySet());
        boolean routerWeightsMatch = otherRouterWeights != null && this.getRouterPolicyWeights() != null && CollectionUtils.isEqualCollection(otherRouterWeights.entrySet(), this.getRouterPolicyWeights().entrySet());
        return amrmWeightsMatch && routerWeightsMatch;
    }

    public int hashCode() {
        return 31 * this.amrmPolicyWeights.hashCode() + this.routerPolicyWeights.hashCode();
    }

    public float getHeadroomAlpha() {
        return this.headroomAlpha;
    }

    public void setHeadroomAlpha(float headroomAlpha) {
        this.headroomAlpha = headroomAlpha;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "Error serializing to string.";
        }
    }
}

