/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import java.net.URI;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationMembershipStateStoreInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FederationMembershipStateStoreInputValidator.class);

    private FederationMembershipStateStoreInputValidator() {
    }

    public static void validate(SubClusterRegisterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing SubClusterRegister Request. Please try again by specifying a SubCluster Register Information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationMembershipStateStoreInputValidator.checkSubClusterInfo(request.getSubClusterInfo());
    }

    public static void validate(SubClusterDeregisterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing SubClusterDeregister Request. Please try again by specifying a SubCluster Deregister Information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationMembershipStateStoreInputValidator.checkSubClusterId(request.getSubClusterId());
        FederationMembershipStateStoreInputValidator.checkSubClusterState(request.getState());
        if (!request.getState().isFinal()) {
            String message = "Invalid non-final state: " + request.getState();
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    public static void validate(SubClusterHeartbeatRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing SubClusterHeartbeat Request. Please try again by specifying a SubCluster Heartbeat Information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationMembershipStateStoreInputValidator.checkSubClusterId(request.getSubClusterId());
        FederationMembershipStateStoreInputValidator.checkTimestamp(request.getLastHeartBeat());
        FederationMembershipStateStoreInputValidator.checkCapability(request.getCapability());
        FederationMembershipStateStoreInputValidator.checkSubClusterState(request.getState());
    }

    public static void validate(GetSubClusterInfoRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing GetSubClusterInfo Request. Please try again by specifying a Get SubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationMembershipStateStoreInputValidator.checkSubClusterId(request.getSubClusterId());
    }

    public static void checkSubClusterInfo(SubClusterInfo subClusterInfo) throws FederationStateStoreInvalidInputException {
        if (subClusterInfo == null) {
            String message = "Missing SubCluster Information. Please try again by specifying SubCluster Information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationMembershipStateStoreInputValidator.checkSubClusterId(subClusterInfo.getSubClusterId());
        FederationMembershipStateStoreInputValidator.checkAddress(subClusterInfo.getAMRMServiceAddress());
        FederationMembershipStateStoreInputValidator.checkAddress(subClusterInfo.getClientRMServiceAddress());
        FederationMembershipStateStoreInputValidator.checkAddress(subClusterInfo.getRMAdminServiceAddress());
        FederationMembershipStateStoreInputValidator.checkAddress(subClusterInfo.getRMWebServiceAddress());
        FederationMembershipStateStoreInputValidator.checkTimestamp(subClusterInfo.getLastHeartBeat());
        FederationMembershipStateStoreInputValidator.checkTimestamp(subClusterInfo.getLastStartTime());
        FederationMembershipStateStoreInputValidator.checkSubClusterState(subClusterInfo.getState());
    }

    private static void checkTimestamp(long timestamp) throws FederationStateStoreInvalidInputException {
        if (timestamp < 0L) {
            String message = "Invalid timestamp information. Please try again by specifying valid Timestamp Information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    private static void checkCapability(String capability) throws FederationStateStoreInvalidInputException {
        if (capability == null || capability.isEmpty()) {
            String message = "Invalid capability information. Please try again by specifying valid Capability Information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    protected static void checkSubClusterId(SubClusterId subClusterId) throws FederationStateStoreInvalidInputException {
        if (subClusterId == null) {
            String message = "Missing SubCluster Id information. Please try again by specifying Subcluster Id information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        if (subClusterId.getId().isEmpty()) {
            String message = "Invalid SubCluster Id information. Please try again by specifying valid Subcluster Id.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    private static void checkAddress(String address) throws FederationStateStoreInvalidInputException {
        if (address == null || address.isEmpty()) {
            String message = "Missing SubCluster Endpoint information. Please try again by specifying SubCluster Endpoint information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        boolean hasScheme = address.contains("://");
        URI uri = null;
        try {
            uri = hasScheme ? URI.create(address) : URI.create("dummyscheme://" + address);
        }
        catch (IllegalArgumentException e) {
            String message = "The provided SubCluster Endpoint does not contain a valid host:port authority: " + address;
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        if (host == null || port < 0 || !hasScheme && path != null && !path.isEmpty()) {
            String message = "The provided SubCluster Endpoint does not contain a valid host:port authority: " + address;
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    private static void checkSubClusterState(SubClusterState state) throws FederationStateStoreInvalidInputException {
        if (state == null) {
            String message = "Missing SubCluster State information. Please try again by specifying SubCluster State information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }
}

