/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.cache;

import java.time.Duration;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.ExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationJCache
extends FederationCache {
    private static final Logger LOG = LoggerFactory.getLogger(FederationJCache.class);
    private Cache<String, FederationCache.CacheRequest> cache;
    private int cacheTimeToLive;
    private long cacheEntityNums;
    private boolean isCachingEnabled = false;
    private final String className = this.getClass().getSimpleName();

    @Override
    public boolean isCachingEnabled() {
        return this.isCachingEnabled;
    }

    @Override
    public void initCache(Configuration pConf, FederationStateStore pStateStore) {
        this.cacheTimeToLive = pConf.getInt("yarn.federation.cache-ttl.secs", 300);
        this.cacheEntityNums = pConf.getLong("yarn.federation.cache-entity.nums", 1000L);
        if (this.cacheTimeToLive <= 0) {
            this.isCachingEnabled = false;
            return;
        }
        this.setStateStore(pStateStore);
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        if (this.cache == null) {
            LOG.info("Creating a JCache Manager with name {}. Cache TTL Time = {} secs. Cache Entity Nums = {}.", new Object[]{this.className, this.cacheTimeToLive, this.cacheEntityNums});
            ResourcePoolsBuilder poolsBuilder = ResourcePoolsBuilder.heap((long)this.cacheEntityNums);
            ExpiryPolicy expiryPolicy = ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(this.cacheTimeToLive));
            CacheConfigurationBuilder configurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, FederationCache.CacheRequest.class, (Builder)poolsBuilder).withExpiry(expiryPolicy);
            this.cache = cacheManager.createCache(this.className, (Builder)configurationBuilder);
        }
        this.isCachingEnabled = true;
    }

    @Override
    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.cache = null;
    }

    @Override
    public Map<SubClusterId, SubClusterInfo> getSubClusters(boolean filterInactiveSubClusters) throws YarnException {
        String cacheKey = this.buildCacheKey(this.className, "getSubClusters", Boolean.toString(filterInactiveSubClusters));
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterInfo>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterInfo>>)this.cache.get((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetSubClustersCacheRequest(this.className, filterInactiveSubClusters);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        return FederationJCache.buildSubClusterInfoMap(cacheRequest);
    }

    @Override
    public Map<String, SubClusterPolicyConfiguration> getPoliciesConfigurations() throws Exception {
        String cacheKey = this.buildCacheKey(this.className, "getPoliciesConfigurations");
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterPolicyConfiguration>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterPolicyConfiguration>>)this.cache.get((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetPoliciesConfigurationsCacheRequest(this.className);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        return FederationJCache.buildPolicyConfigMap(cacheRequest);
    }

    @Override
    public SubClusterId getApplicationHomeSubCluster(ApplicationId appId) throws Exception {
        String cacheKey = this.buildCacheKey(this.className, "getApplicationHomeSubCluster", appId.toString());
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterId>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterId>>)this.cache.get((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetApplicationHomeSubClusterRequest(this.className, appId);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        FederationCache.CacheResponse response = (FederationCache.CacheResponse)FederationCache.ApplicationHomeSubClusterCacheResponse.class.cast(cacheRequest.getValue());
        return (SubClusterId)response.getItem();
    }

    @Override
    public void removeSubCluster(boolean flushCache) {
        String cacheKey = this.buildCacheKey(this.className, "getSubClusters", Boolean.toString(flushCache));
        this.cache.remove((Object)cacheKey);
    }

    @VisibleForTesting
    public Cache<String, FederationCache.CacheRequest> getCache() {
        return this.cache;
    }

    @VisibleForTesting
    public String getAppHomeSubClusterCacheKey(ApplicationId appId) {
        return this.buildCacheKey(this.className, "getApplicationHomeSubCluster", appId.toString());
    }
}

