/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.webapp.ContainerBlock;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.webapp.View;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ContainerBlockTest {
    private ContainerReport createContainerReport() {
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        HashMap ports = new HashMap();
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("abc", "123");
        list.add(map);
        ports.put("192.168.0.1", list);
        ContainerReport container = ContainerReport.newInstance((ContainerId)containerId, null, (NodeId)NodeId.newInstance((String)"host", (int)1234), (Priority)Priority.UNDEFINED, (long)1234L, (long)5678L, (String)"diagnosticInfo", (String)"logURL", (int)0, (ContainerState)ContainerState.COMPLETE, (String)("http://" + NodeId.newInstance((String)"host", (int)2345).toString()));
        container.setExposedPorts(ports);
        return container;
    }

    @Test
    public void testRenderResourcesString() {
        CustomResourceTypesConfigurationProvider.initResourceTypes((String[])new String[]{"yarn.io/gpu"});
        Resource resource = ResourceTypesTestHelper.newResource((long)8192L, (int)4, (Map)ImmutableMap.builder().put((Object)"yarn.io/gpu", (Object)"5").build());
        ContainerBlock block = new ContainerBlock((ApplicationBaseProtocol)Mockito.mock(ApplicationBaseProtocol.class), (View.ViewContext)Mockito.mock(View.ViewContext.class));
        ContainerReport containerReport = this.createContainerReport();
        containerReport.setAllocatedResource(resource);
        ContainerInfo containerInfo = new ContainerInfo(containerReport);
        String resources = block.getResources(containerInfo);
        Assertions.assertEquals((Object)"8192 Memory, 4 VCores, 5 yarn.io/gpu", (Object)resources);
    }
}

