/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilterInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestTimelineAuthenticationFilterInitializer {
    @Test
    public void testProxyUserConfiguration() {
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        for (int i = 0; i < 3; ++i) {
            YarnConfiguration conf = new YarnConfiguration();
            switch (i) {
                case 0: {
                    conf.set("hadoop.proxyuser.foo.hosts", "*");
                    conf.set("hadoop.proxyuser.foo.users", "*");
                    conf.set("hadoop.proxyuser.foo.groups", "*");
                    break;
                }
                case 1: {
                    conf.set("yarn.timeline-service.http-authentication.proxyuser.foo.hosts", "*");
                    conf.set("yarn.timeline-service.http-authentication.proxyuser.foo.users", "*");
                    conf.set("yarn.timeline-service.http-authentication.proxyuser.foo.groups", "*");
                    break;
                }
                case 2: {
                    conf.set("hadoop.proxyuser.foo.hosts", "bar");
                    conf.set("hadoop.proxyuser.foo.users", "bar");
                    conf.set("hadoop.proxyuser.foo.groups", "bar");
                    conf.set("yarn.timeline-service.http-authentication.proxyuser.foo.hosts", "*");
                    conf.set("yarn.timeline-service.http-authentication.proxyuser.foo.users", "*");
                    conf.set("yarn.timeline-service.http-authentication.proxyuser.foo.groups", "*");
                    break;
                }
            }
            TimelineAuthenticationFilterInitializer initializer = new TimelineAuthenticationFilterInitializer();
            initializer.initFilter(container, (Configuration)conf);
            Assertions.assertEquals((Object)"*", initializer.filterConfig.get("proxyuser.foo.hosts"));
            Assertions.assertEquals((Object)"*", initializer.filterConfig.get("proxyuser.foo.users"));
            Assertions.assertEquals((Object)"*", initializer.filterConfig.get("proxyuser.foo.groups"));
        }
    }
}

