/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.Spy;

public class TestOpportunisticContainerContext {
    @Spy
    private OpportunisticContainerContext opportunisticContainerContext;
    private Map<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest> reqMap = new HashMap<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest>();
    private TreeMap<SchedulerRequestKey, Map<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest>> outstandingOpReqs;

    @BeforeEach
    public void setUp() {
        this.opportunisticContainerContext = (OpportunisticContainerContext)Mockito.spy((Object)new OpportunisticContainerContext());
        this.outstandingOpReqs = new TreeMap();
    }

    @Test
    public void testAddToOutstandingReqsWithANYRequest() {
        ResourceRequest request = this.getResourceRequest("*", 1);
        ArrayList<ResourceRequest> resourceRequestList = new ArrayList<ResourceRequest>();
        resourceRequestList.add(request);
        this.opportunisticContainerContext.addToOutstandingReqs(resourceRequestList);
        Assertions.assertEquals((int)this.opportunisticContainerContext.getOutstandingOpReqs().size(), (int)1);
    }

    @Test
    public void testAddToOutstandingReqsWithZeroContainer() {
        ResourceRequest request = this.getResourceRequest("resource", 0);
        this.createOutstandingOpReqs(request, this.getResource());
        ((OpportunisticContainerContext)Mockito.doReturn(this.outstandingOpReqs).when((Object)this.opportunisticContainerContext)).getOutstandingOpReqs();
        ArrayList<ResourceRequest> resourceRequestList = new ArrayList<ResourceRequest>();
        resourceRequestList.add(request);
        this.opportunisticContainerContext.addToOutstandingReqs(resourceRequestList);
        Assertions.assertEquals((int)this.opportunisticContainerContext.getOutstandingOpReqs().size(), (int)1);
    }

    @Test
    public void testAddToOutstandingReqsWithZeroContainerAndMultipleSchedulerKey() {
        ResourceRequest req1 = this.getResourceRequest("resource", 0);
        ResourceRequest req2 = this.getResourceRequest("*", 0);
        this.createOutstandingOpReqs(req1, this.getResource());
        this.createOutstandingOpReqs(req2, this.getResource());
        ((OpportunisticContainerContext)Mockito.doReturn(this.outstandingOpReqs).when((Object)this.opportunisticContainerContext)).getOutstandingOpReqs();
        ArrayList<ResourceRequest> resourceRequestList = new ArrayList<ResourceRequest>();
        resourceRequestList.add(req1);
        resourceRequestList.add(req2);
        this.opportunisticContainerContext.addToOutstandingReqs(resourceRequestList);
        Assertions.assertEquals((int)this.opportunisticContainerContext.getOutstandingOpReqs().size(), (int)1);
    }

    @Test
    public void testAddToOutstandingReqsWithMultipleSchedulerKey() {
        ResourceRequest req1 = this.getResourceRequest("resource", 0);
        ResourceRequest req2 = this.getResourceRequest("*", 1);
        this.createOutstandingOpReqs(req1, this.getResource());
        this.createOutstandingOpReqs(req2, this.getResource());
        ((OpportunisticContainerContext)Mockito.doReturn(this.outstandingOpReqs).when((Object)this.opportunisticContainerContext)).getOutstandingOpReqs();
        ArrayList<ResourceRequest> resourceRequestList = new ArrayList<ResourceRequest>();
        resourceRequestList.add(req1);
        resourceRequestList.add(req2);
        this.opportunisticContainerContext.addToOutstandingReqs(resourceRequestList);
        Assertions.assertEquals((int)this.opportunisticContainerContext.getOutstandingOpReqs().size(), (int)1);
    }

    @Test
    public void testAddToOutstandingReqsWithZeroContainerAndNullCapability() {
        ResourceRequest request = this.getResourceRequestWithoutCapability();
        this.createOutstandingOpReqs(request, this.getResource());
        ((OpportunisticContainerContext)Mockito.doReturn(this.outstandingOpReqs).when((Object)this.opportunisticContainerContext)).getOutstandingOpReqs();
        ArrayList<ResourceRequest> resourceRequestList = new ArrayList<ResourceRequest>();
        resourceRequestList.add(request);
        this.opportunisticContainerContext.addToOutstandingReqs(resourceRequestList);
        Assertions.assertEquals((int)this.opportunisticContainerContext.getOutstandingOpReqs().size(), (int)1);
    }

    @Test
    public void testAddToOutstandingReqsWithEmptyReqMap() {
        ResourceRequest request = this.getResourceRequest("resource", 0);
        ((OpportunisticContainerContext)Mockito.doReturn(new TreeMap()).when((Object)this.opportunisticContainerContext)).getOutstandingOpReqs();
        ArrayList<ResourceRequest> resourceRequestList = new ArrayList<ResourceRequest>();
        resourceRequestList.add(request);
        this.opportunisticContainerContext.addToOutstandingReqs(resourceRequestList);
        Assertions.assertEquals((int)this.opportunisticContainerContext.getOutstandingOpReqs().size(), (int)0);
    }

    private void createOutstandingOpReqs(ResourceRequest req, Resource resource) {
        SchedulerRequestKey schedulerRequestKey = SchedulerRequestKey.create((ResourceRequest)req);
        this.reqMap.put(resource, new OpportunisticContainerAllocator.EnrichedResourceRequest(req));
        this.outstandingOpReqs.put(schedulerRequestKey, this.reqMap);
    }

    private ResourceRequest getResourceRequest(String resourceName, int numContainer) {
        return ResourceRequest.newBuilder().resourceName(resourceName).numContainers(numContainer).allocationRequestId(1L).priority(Priority.newInstance((int)1)).capability(this.getResource()).build();
    }

    private ResourceRequest getResourceRequestWithoutCapability() {
        return ResourceRequest.newBuilder().resourceName("resource").numContainers(0).allocationRequestId(1L).priority(Priority.newInstance((int)1)).build();
    }

    private Resource getResource() {
        return Resource.newInstance((int)1024, (int)2);
    }
}

